
var pubContactOrgAccountMiddleLogGrid = $("#pubContactOrgAccountMiddleLogGrid");
$(function(){
	initPubContactOrgAccountMiddleLogGrid();
});


/**
 * 初始化
 */
function initPubContactOrgAccountMiddleLogGrid(){
	pubContactOrgAccountMiddleLogGrid.datagrid({
		height : getMixGridHeight(),
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		queryParams:{
		},
		cls:'md',
		toolbar:"#pubContactOrgAccountMiddleLogGridTbar",
	    url:ctx+'/pubContactOrgAccountMiddleLog/pageAll',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){
				return '<div onclick="pubContactOrgAccountMiddleLogFormDetail('+row.accountLogId+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    {field:'logMsg',title:'日志内容',width:100,align:'center',halign:'center',sortable:true},
	    {field:'logTypeText',title:'日志类型',width:100,align:'center',halign:'center'},
	    {field:'logTime',title:'日志发生时间',width:100,align:'center',halign:'center',sortable:true},
	    {field:'createAccount',title:'创建人',width:100,align:'center',halign:'center',sortable:true},
	    {field:'createTime',title:'创建时间',width:100,align:'center',halign:'center',sortable:true}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			pubContactOrgAccountMiddleLogFormDetail(row.accountLogId);
	    }
	});
	
    pubContactOrgAccountMiddleLogGrid.datagrid('doCellTip');
    var pager = pubContactOrgAccountMiddleLogGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('pubContactOrgAccountMiddleLogGrid',menuName)
	        }    
	    }]   
	});
}


/**
 * 查看表单明细
 */
function pubContactOrgAccountMiddleLogFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=PubContactOrgAccountMiddleLog&isdetail=true&id="+id
	});
}


/**
 * 重新加载
 */
function reloadPubContactOrgAccountMiddleLog(){
	pubContactOrgAccountMiddleLogGrid.datagrid('reload');
}


/**
 * 查询
 */
function searchPubContactOrgAccountMiddleLog(){
	pubContactOrgAccountMiddleLogGrid.datagrid('load',{

		logType : $("#logTypeQuery").combobox("getValue"),
		createTimeStart : $("#createTimeStartQuery").datebox("getValue"),
		createTimeEnd : $("#createTimeEndQuery").datebox("getValue")
	});
}


/**
 * 增加
 */
function addPubContactOrgAccountMiddleLog() {
	openSaveDialog({
		title : "添加记录",
		maximized : true,
		contenturl : "/GenForm/form?formcode=PubContactOrgAccountMiddleLog",
		submiturl : "/pubContactOrgAccountMiddleLog/savePubContactOrgAccountMiddleLog?formcode=PubContactOrgAccountMiddleLog",
		callback : reloadPubContactOrgAccountMiddleLog
	});
	
}


/**
 * 修改
 */
function editPubContactOrgAccountMiddleLog() {

	var row = pubContactOrgAccountMiddleLogGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	openSaveDialog({
		title : "修改记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=PubContactOrgAccountMiddleLog&id=" + row.accountLogId,
		submiturl:"/pubContactOrgAccountMiddleLog/savePubContactOrgAccountMiddleLog?formcode=PubContactOrgAccountMiddleLog",
		callback : reloadPubContactOrgAccountMiddleLog
	});
}


/**
 * 删除
 */
function delPubContactOrgAccountMiddleLog() {

	var row = pubContactOrgAccountMiddleLogGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
		if (r) {
			$.ajax({
				type : "post",
				url : ctx+"/pubContactOrgAccountMiddleLog/delPubContactOrgAccountMiddleLog",
				data : {
					id : row.accountLogId
				},
				dataType : 'json',
				success : function(result) {
					if (result.success) {
						pubContactOrgAccountMiddleLogGrid.datagrid('reload');
						alertInfo(result.msg);
					}else{
						alertError(result.msg);
					}
				}
			});
		}
	});
	
}
