var GenFormPrintDataGrid = $('#GenFormPrint_datagrid');
$(function () {
    initGenFormPrintGrid();
});

function initGenFormPrintGrid() {
    GenFormPrintDataGrid.datagrid({
		height:getMixGridHeight(),
        border: false,
        singleSelect: true,
        rownumbers: true,
        fitColumns: true,
        pagination: true,
        queryParams: {
            startDate: $('#sDate').datebox('getValue'),
            endDate: $('#eDate').datebox('getValue')
        },
        cls: 'md',
        toolbar: "#GenFormPrint_datagrid_tb",
        url: ctx + '/GenFormPrint/pageGenFormPrint',
        columns: [[
            {
                field: 'opt', title: '明细', width: 40, align: 'center',
                formatter: function (value, row, index) {	//value表示字段的值,rowData行记录数据,index行索引
                    return '<div onclick="GenFormPrintFormDetail(' + row.printId + ')" class="icon-detail iconfont blue">&nbsp;</div>';
                }
            },
            // {field: 'printId', title: '主键ID', width: 100, align: 'center', halign: 'center', sortable: true},
            {field: 'printTitle', title: '标题', width: 100, align: 'center', halign: 'center', sortable: true},
            {field: 'printFormCode', title: '表单编码', width: 100, align: 'center', halign: 'center', sortable: true},
            {field: 'printFlowCode', title: '流程编码', width: 100, align: 'center', halign: 'center', sortable: true},
            {field: 'printColumnNumbers', title: '表单列数', width: 100, align: 'center', halign: 'center', sortable: true},
            {field: 'printLabelPercent', title: '标签列百分比', width: 100, align: 'center', halign: 'center', sortable: true},
            {field: 'isPrintQrText', title: '是否显示二维码', width: 100, align: 'center', halign: 'center', sortable: true},
            // {field: 'printQrContent', title: '二维码内容', width: 100, align: 'center', halign: 'center', sortable: true},
            {field: 'belongToOrgText', title: '适用单位', width: 100, align: 'center', halign: 'center', sortable: true},
            {field: 'printStartTime', title: '生效时间', width: 100, align: 'center', halign: 'center', sortable: true},
            {field: 'printEndTime', title: '失效时间', width: 100, align: 'center', halign: 'center', sortable: true},
            // {field: 'createAccount', title: '创建人', width: 100, align: 'center', halign: 'center', sortable: true},
            // {field: 'createTime', title: '创建时间', width: 100, align: 'center', halign: 'center', sortable: true},
            // {field: 'modifyAccount', title: '最后修改人', width: 100, align: 'center', halign: 'center', sortable: true},
            // {field: 'modifyTime', title: '最后修改时间', width: 100, align: 'center', halign: 'center', sortable: true},
            // {field: 'isUse', title: 'Is Use', width: 100, align: 'center', halign: 'center', sortable: true}
        ]],
        onDblClickRow: function (index, row) {
            //查看明细
            GenFormPrintFormDetail(row.printId);
        }
    });
    GenFormPrintDataGrid.datagrid('doCellTip');
    var pager = GenFormPrintDataGrid.datagrid('getPager');
    pager.pagination({
        buttons: [{
            iconCls: 'icon-page_excel',
            handler: function () {
                exportExcel('GenFormPrint_datagrid', "title");
            }
        }]
    });
}

//查看表单明细
function GenFormPrintFormDetail(id) {
    openDetailDialog({
        title: "查看记录",
        maximized: true,
        contenturl: "/GenForm/form?formcode=GenFormPrint&isdetail=true&id=" + id
    });
}

//重新加载表格
function reloadGenFormPrint() {
    GenFormPrintDataGrid.datagrid('reload');
}

//查询表格
function searchGenFormPrint() {
    GenFormPrintDataGrid.datagrid('load', {
        search: $("#searchGenFormPrint").val(),
        startDate: $('#sDate').datebox('getValue'),
        endDate: $('#eDate').datebox('getValue'),
        applyPerson: $("#applyPerson").textbox('getValue'),
        applyDept: $("#applyDept").combobox('getValue')
    });
}

//增加记录
function addGenFormPrint() {
    openSaveDialog({
        title: "添加记录",
        // width: 800,
        // height: 600,
        maximized: true,
        contenturl: "/GenForm/form?formcode=GenFormPrint",
        submiturl: "/GenFormPrint/saveGenFormPrint?formcode=GenFormPrint",
//		contenturl:"/view/gen/GenFormPrint",
//		submiturl:"/GenFormPrint/saveGenFormPrint",
        callback: reloadGenFormPrint
    });

}

//修改记录
function editGenFormPrint() {
    var row = GenFormPrintDataGrid.datagrid('getSelected');
    if (row) {
        var id = row.printId;
        openSaveDialog({
            title: "修改记录",
            maximized: true,
            contenturl: "/GenForm/form?formcode=GenFormPrint&id=" + id,
            submiturl: "/GenFormPrint/saveGenFormPrint?formcode=GenFormPrint",
//			contenturl : "/view/gen/GenFormPrint",
//			submiturl : "/GenFormPrint/saveGenFormPrint",
//			onload : "/GenFormPrint/findGenFormPrint?id=" + id,
            callback: reloadGenFormPrint
        });

    } else {
        alertInfo('请选择一条记录进行修改');
    }
}

//删除记录
function delGenFormPrint() {
    var row = GenFormPrintDataGrid.datagrid('getSelected');
    if (row) {
        var id = row.printId;
        alertConfirmYes('您是否要删除当前选中的数据？', function (r) {
            if (r) {
                $.ajax({
                    url: ctx + "/GenFormPrint/delGenFormPrint",
                    data: {
                        id: id
                    },
                    dataType: 'json',
                    success: function (result) {
                        if (result.success) {
                            GenFormPrintDataGrid.datagrid('reload');
                            alertInfo(result.msg);
                        } else {
                            alertError(result.msg);
                        }
                    }
                });
            }
        });
    } else {
        alertInfo('请先选择要删除的数据信息');
    }
}
