
var maLeaseRentRebateLogGrid = $("#maLeaseRentRebateLogGrid");
$(function(){
	initMaLeaseRentRebateLogGrid();
});


/**
 * 初始化
 */
function initMaLeaseRentRebateLogGrid(){
	maLeaseRentRebateLogGrid.datagrid({
		height : getMixGridHeight(),
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		queryParams:{
		},
		cls:'md',
		toolbar:"#maLeaseRentRebateLogGridTbar",
	    url:ctx+'/maLeaseRentRebateLog/pageAll',
	    columns:[[
	    // {
		// 	field:'opt',title:'明细',width:40,align:'center',
		// 	formatter:function(value,row,index){
		// 		return '<div onclick="maLeaseRentRebateLogFormDetail('+row.middleLogId+')" class="icon-detail iconfont blue">&nbsp;</div>';
		// }},
	    {field:'logMsg',title:'日志内容',width:100,align:'center',halign:'center',sortable:true},
	    {field:'logTypeText',title:'日志类型',width:100,align:'center',halign:'center'},
	    {field:'logTime',title:'日志发生时间',width:100,align:'center',halign:'center',sortable:true},
	    {field:'createAccountText',title:'创建人',width:100,align:'center',halign:'center',sortable:true}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			// maLeaseRentRebateLogFormDetail(row.middleLogId);
	    }
	});
	
    maLeaseRentRebateLogGrid.datagrid('doCellTip');
    var pager = maLeaseRentRebateLogGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('maLeaseRentRebateLogGrid',menuName)
	        }    
	    }]   
	});
}


/**
 * 查看表单明细
 */
function maLeaseRentRebateLogFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=MaLeaseRentRebateLog&isdetail=true&id="+id
	});
}


/**
 * 重新加载
 */
function reloadMaLeaseRentRebateLog(){
	maLeaseRentRebateLogGrid.datagrid('reload');
}


/**
 * 查询
 */
function searchMaLeaseRentRebateLog(){
	maLeaseRentRebateLogGrid.datagrid('load',{

		logType : $("#logTypeQuery").combobox("getValue"),
		logTimeStart : $("#logTimeStartQuery").datebox("getValue"),
		logTimeEnd : $("#logTimeEndQuery").datebox("getValue")
	});
}


/**
 * 增加
 */
function addMaLeaseRentRebateLog() {
	openSaveDialog({
		title : "添加记录",
		maximized : true,
		contenturl : "/GenForm/form?formcode=MaLeaseRentRebateLog",
		submiturl : "/maLeaseRentRebateLog/saveMaLeaseRentRebateLog?formcode=MaLeaseRentRebateLog",
		callback : reloadMaLeaseRentRebateLog
	});
	
}


/**
 * 修改
 */
function editMaLeaseRentRebateLog() {

	var row = maLeaseRentRebateLogGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	openSaveDialog({
		title : "修改记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=MaLeaseRentRebateLog&id=" + row.middleLogId,
		submiturl:"/maLeaseRentRebateLog/saveMaLeaseRentRebateLog?formcode=MaLeaseRentRebateLog",
		callback : reloadMaLeaseRentRebateLog
	});
}


/**
 * 删除
 */
function delMaLeaseRentRebateLog() {

	var row = maLeaseRentRebateLogGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
		if (r) {
			$.ajax({
				type : "post",
				url : ctx+"/maLeaseRentRebateLog/delMaLeaseRentRebateLog",
				data : {
					id : row.middleLogId
				},
				dataType : 'json',
				success : function(result) {
					if (result.success) {
						maLeaseRentRebateLogGrid.datagrid('reload');
						alertInfo(result.msg);
					}else{
						alertError(result.msg);
					}
				}
			});
		}
	});
	
}
