
var basUkeyGrid = $("#basUkeyGrid");
$(function(){
	initBasUkeyGrid();
});




/**
 * 初始化
 */
function initBasUkeyGrid(){
	basUkeyGrid.datagrid({
		height : getMixGridHeight(),
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		queryParams:{
		},
		cls:'md',
		toolbar:"#basUkeyGridTbar",
	    url:ctx+'/basUkey/pageAll',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){
				return `<div onclick="basUkeyFormDetail(`+row.ukeyId + `,'` +row.ownusertext+ `')" class="icon-detail iconfont blue">&nbsp;</div>`;
		}},
	    {field:'ukeyId',hidden:true},
		{field:'manufacturer',title:'厂商',width:100,align:'center',halign:'center',sortable:true},
		{field:'deviceModel',title:'设备型号',width:100,align:'center',halign:'center',sortable:true},
	    {field:'ownusertext',title:'持有用户',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'publicKeyX',title:'公钥X',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'publicKeyY',title:'公钥Y',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'deviceChipId',title:'设备芯片id',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'macAddress',title:'绑定mac地址',width:100,align:'center',halign:'center',sortable:true},
	    {field:'isEnableText',title:'是否启用',width:100,align:'center',halign:'center'},
	    {field:'produceDate',title:'出厂日期',width:100,align:'center',halign:'center',sortable:true},
		{field:'picUrl',title:'设备图片',width:100,align:'center',halign:'center',formatter:function(value,row,index){
				return `<img src="` + ctx +`/file/viewfile/preview.JPG?versionid=`+value+`"className="el-image__inner el-image__preview" style="width: 50px;height: 50px">`
		}},
			{field:'opt2',title:'操作',width:100,align:'center',halign:'center',formatter:function(value,row,index){
				return `<div  class="rowbtn" onclick="enableBasUkey('`+row.ukeyId+`')">启用</div>`
		}},

	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			basUkeyFormDetail(row.ukeyId,row.ownusertext);
	    }
	});

    basUkeyGrid.datagrid('doCellTip');
    var pager = basUkeyGrid.datagrid('getPager');
    pager.pagination({
	    buttons:[{
	        iconCls:'icon-page_excel',
	        handler:function(){
	           exportExcel('basUkeyGrid',"用户Ukey信息")
	        }
	    }]
	});
}


/**
 * 查看表单明细
 */
function basUkeyFormDetail(id,ownusertext){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasUkey&isdetail=true&id="+id,
		onload:function () {
			$("#ownUser_span").text(ownusertext)
			$("#picUrlImg").css({"width":"50px","height":"50px"})
		}
	});
}


/**
 * 重新加载
 */
function reloadBasUkey(){
	basUkeyGrid.datagrid('reload');
	$("#isChangeOwnUser").val(false)
}


/**
 * 查询
 */
function searchBasUkey(){
	basUkeyGrid.datagrid('load',{
		fuzzy : $("#fuzzy").textbox("getValue"),
		produceDateStart : $("#produceDateStartQuery").datebox("getValue"),
		produceDateEnd : $("#produceDateEndQuery").datebox("getValue")
	});
}


/**
 * 增加
 */
function addBasUkey() {
	openSaveDialog({
		title : "添加记录",
		maximized : true,
		contenturl : "/GenForm/form?formcode=BasUkey",
		submiturl : "/basUkey/saveBasUkey?formcode=BasUkey",
		callback : reloadBasUkey,
		onload:function () {
			$("#picUrlImg").css({"width":"100px","height":"100px"})
		}
	});

}


/**
 * 修改
 */
function editBasUkey() {

	var row = basUkeyGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	openSaveDialog({
		title : "修改记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasUkey&id=" + row.ukeyId,
		submiturl:"/basUkey/saveBasUkey?formcode=BasUkey",
		onload:function () {
			// 需要手动设置显示值，这里用的是bas_emp的用户名
			$("#ownUser_TEXT_").textbox("setValue",row.ownusertext)
			// 设置持有人没有改变
			$("#isChangeOwnUser").val(false)
			$("#picUrlImg").css({"width":"100px","height":"100px"})

		},
		callback : reloadBasUkey
	});
}


/**
 * 删除
 */
function delBasUkey() {

	var row = basUkeyGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
		if (r) {
			$.ajax({
				type : "post",
				url : ctx+"/basUkey/delBasUkey",
				data : {
					id : row.ukeyId
				},
				dataType : 'json',
				success : function(result) {
					if (result.success) {
						basUkeyGrid.datagrid('reload');
						alertInfo(result.msg);
					}else{
						alertError(result.msg);
					}
				}
			});
		}
	});

}


/**
 * 启用
 * @param ukeyId
 */
function enableBasUkey(ukeyId) {
	$.ajax({
		type : "post",
		url : ctx+"/basUkey/enableBasUkey",
		data : {
			id : ukeyId
		},
		dataType : 'json',
		success : function(result) {
			if (result.success) {
				basUkeyGrid.datagrid('reload');
				// alertInfo(result.msg);
			}else{
				alertError(result.msg);
			}
		}
	});

}


/**
 *
 *
 * 页面内容维护中配置了selectOwnUser事件对应这个方法
 */
function selectOwnUser(){
	var orgId = "";
	var type = 1;
	var that = this
	if (!that) {
		that = this;
	}
	var inputobj = formatterInputobj(that);
	if ($('#FmFinancialReceivable').length > 0) {
		orgId = $('#payee').combobox('getValue');
	}
	$.get(ctx + '/view/sys/empSelectWin?type=' + type + '&orgId=' + orgId, function (str) {
		var epmIndex = layer.open({
			type: 1,
			title: "<span class='icon iconfont icon-renshifenxi blue2'></span>人员选择",
			closeBtn: 1, //不显示关闭按钮
			btn: ['确定', '清空', '关闭'],
			//skin: 'layui-layer-qllan',
			area: ['800px', $("body").height() > 600 ? '560px' : $("body").height() + "px"],
			content: str, //iframe的url，no代表不显示滚动条
			btn2: function () {
				$('#' + inputobj.inputId).val('');
				$('#' + inputobj.inputText).textbox('setValue', '');
				if ($("#GmAssetsAdjustment").length > 0) {
					if ('management' == inputobj.inputId) {
						$('#manageOrg').combobox('clear');
						$('#manageDept').val('');
						$('#manageDept_TEXT_').textbox('clear');
					} else if ('useAccount' == inputobj.inputId) {
						$('#useDept').val('');
						$('#useDept_TEXT_').textbox('clear');
					}
				}
				if ('manageAccount' == inputobj.inputId) {
					$('#manageOrg').combobox('clear');
					$('#manageDept').val('');
					$('#manageDept_TEXT_').textbox('clear');
				}
				if (haseasyui('#manageOrg') && haseasyui('#manageDept')) {
					$('#manageOrg').combobox('clear');
					$('#manageDept').val('');
					$('#manageDept_TEXT_').textbox('clear');
				}
				if ('safekeepingAccount' == inputobj.inputId) {
					$('#safekeepingDept').val('');
					$('#safekeepingDept_TEXT_').textbox('clear');
				}
				if ($("#GmAssetsInventory").length > 0) {
					autoSetValue('manageOrg', '');
					autoSetValue('manageDept', '');
				} else if ($("#GmInventoryApply").length > 0) {
					autoSetValue('supervisDept', '');
				} else if ($("#GmSealKZ").length > 0) {
					autoSetValue('applyOrg', '');
					autoSetValue('deptId', '');
				} else if ($("#feeDetailList").length > 0) {
					var feeDIndex = inputobj.inputId.replace("writerByText", "");
					$('#writerBy' + feeDIndex).val('');
					$('#writerByText' + feeDIndex).textbox('clear');
					$('#orgId' + feeDIndex).combobox('clear');
					$('#deptId' + feeDIndex).combobox('clear');
				} else if ($("#GmSubmittedUnit").length > 0) {     // 单位用印申请陪同人员选择
					var index = inputobj.inputId.replace("submitPersonText", "");
					$('#submitPerson' + index).val('');
					$('#submitPersonText' + index).textbox('clear');
				} else {
					$('#applyDept').val('');
					$('#applyOrg').val('');
					autoSetValue("issueDept", '');
					autoSetValue("issueDept_TEXT_", '');
				}
			},
			yes: function (index, layero) {
				var empWinIndexCal = "";
				if (empWinSelectIndex === 1) {
					empWinIndexCal = 1;
				} else if (empWinSelectIndex === 2) {
					empWinIndexCal = 2;
				}
				var r = $('#empSelect_datagrid' + empWinIndexCal).datagrid('getSelected');
				if (r) {
					var fcode = $('#assetsCatagory').val();
					if ($("#GmAssetsInventory").length > 0) {
						$('#' + inputobj.inputId).val(r.ACCOUNT_ID);
						$('#' + inputobj.inputText).textbox('setValue', r.ACCOUNT_NAME);
						autoSetValue('manageOrg', r.ORG_ID);
						autoSetValue('manageDept', r.DEPT_ID);
					} else {
						$('#' + inputobj.inputId).val(r.EMP_ID);
						$('#' + inputobj.inputText).textbox('setValue', r.ACCOUNT_NAME);
						$('#applyDept').val(r.DEPT_ID);
						$('#applyOrg').val(r.ORG_ID);
						autoSetValue("issueDept", r.DEPT_ID);
						autoSetValue("issueDept_TEXT_", r.DEPT_NAME);
					}
					layer.close(index);
					return true;
				} else {
					alertInfo("请选择人员");
					return false;
				}
			},
			success: function (layero, index) {
			},
			end: function () {
				$(".todolist.intervalRefresh").closest(".layui-card").find(".refresh").trigger("click");
			}
		});
	});

}
