var basTemplateGrid = $("#basTemplateGrid");
$(function () {
    initBasTemplateGrid();
    bindEnterKey("#fuzzy",searchBasTemplate);
});


/**
 * 初始化
 */
function initBasTemplateGrid() {
    basTemplateGrid.datagrid({
        height: getMixGridHeight(),
        border: false,
        singleSelect: true,
        rownumbers: true,
        fitColumns: true,
        pagination: true,
        queryParams: {},
        cls: 'md',
        toolbar: "#basTemplateGridTbar",
        url: ctx + '/basTemplate/pageAll',
        columns: [[
            {
                field: 'opt', title: '明细', width: 40, align: 'center',
                formatter: function (value, row, index) {
                    return '<div onclick="basTemplateFormDetail(' + row.templateId + ')" class="icon-detail iconfont blue">&nbsp;</div>';
                }
            },
            {
                field: 'templateName', title: '模板名称', align: 'center', width: 100
            },
			{
				field: 'templateCode', title: '模板编码', align: 'center', width: 100
			},
            {
                field: 'enableText', title: '启用授权', align: 'center', width: 100
            }
        ]],
        onDblClickRow: function (index, row) {
            //查看明细
            basTemplateFormDetail(row.templateId);
        }
    });

    basTemplateGrid.datagrid('doCellTip');
    var pager = basTemplateGrid.datagrid('getPager');
    pager.pagination({
        buttons: [{
            iconCls: 'icon-page_excel',
            handler: function () {
                exportExcel('basTemplateGrid', "自定义模板")
            }
        }]
    });
}


/**
 * 查看表单明细
 */
function basTemplateFormDetail(id) {
    openDetailDialog({
        title: "查看记录",
        maximized: true,
        contenturl: "/GenForm/form?formcode=BasTemplate&isdetail=true&id=" + id
    });
}


/**
 * 重新加载
 */
function reloadBasTemplate() {
    basTemplateGrid.datagrid('reload');
}


/**
 * 查询
 */
function searchBasTemplate() {
    basTemplateGrid.datagrid('load', {
        fuzzy: $("#fuzzy").textbox("getValue")
    });
}


/**
 * 增加
 */
function addBasTemplate() {
    openSaveDialog({
        title: "添加记录",
        maximized: true,
        contenturl: "/GenForm/form?formcode=BasTemplate&isdetail=false",
        submiturl: "/basTemplate/saveBasTemplate?formcode=BasTemplate",
        callback: reloadBasTemplate,
        onsubmit:function(param){
            param.data = getBasTemplateUserData();
            return true;
        }
    });

}


/**
 * 修改
 */
function editBasTemplate() {

    var row = basTemplateGrid.datagrid('getSelected');
    if (!row) {
        alertWarn('请选择记录!');
        return;
    }

    openSaveDialog({
        title: "修改记录",
        maximized: true,
        contenturl: "/GenForm/form?formcode=BasTemplate&isdetail=false&id=" + row.templateId,
        submiturl: "/basTemplate/saveBasTemplate?formcode=BasTemplate",
        callback: reloadBasTemplate,
        onsubmit:function(param){
            param.data = getBasTemplateUserData();
            return true;
        }
    });
}


/**
 * 发布/取消发布
 */
function enableTemplate(enable){
    var row = basTemplateGrid.datagrid('getSelected');
    if(!row){
        alertWarn('请选择需要授权的信息!');
        return;
    }
    if(row.enable == 'Y' && enable == 'Y'){
        alertWarn('该数据已授权!');
        return;
    }
    if(row.enable == 'N' && enable == 'N'){
        alertWarn('该数据未授权!');
        return;
    }
    let msg = "";
    if(enable == 'Y'){
        msg = "您是否要授权当前选中的数据？"
    }else{
        msg = "您是否要取消授权当前选中的数据？"
    }
    alertConfirmYes(msg, function(r) {
        if (r) {
            $.ajax({
                type : "post",
                url : ctx+"/basTemplate/enableTemplate",
                data : {
                    id : row.templateId,
                    enable:enable
                },
                dataType : 'json',
                success : function(result) {
                    if (result.success) {
                        basTemplateGrid.datagrid('reload');
                        alertInfo(result.msg);
                    }else{
                        alertError(result.msg);
                    }
                }
            });
        }
    });
}


/**
 * 删除
 */
function delBasTemplate() {

    var row = basTemplateGrid.datagrid('getSelected');
    if (!row) {
        alertWarn('请选择记录!');
        return;
    }

    alertConfirmYes('您是否要删除当前选中的数据？', function (r) {
        if (r) {
            $.ajax({
                type: "post",
                url: ctx + "/basTemplate/delBasTemplate",
                data: {
                    id: row.templateId
                },
                dataType: 'json',
                success: function (result) {
                    if (result.success) {
                        basTemplateGrid.datagrid('reload');
                        alertInfo(result.msg);
                    } else {
                        alertError(result.msg);
                    }
                }
            });
        }
    });

}
