
var basSystemInfoGrid = $("#basSystemInfoGrid");
$(function(){
	initBasSystemInfoGrid();
});


/**
 * 初始化
 */
function initBasSystemInfoGrid(){
	basSystemInfoGrid.datagrid({
		height : getMixGridHeight(),
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		queryParams:{
		},
		cls:'md',
		toolbar:"#basSystemInfoGridTbar",
	    url:ctx+'/basSystemInfo/pageAll',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){
				return '<div onclick="basSystemInfoFormDetail('+row.id+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    {field:'id',hidden:true},
	    {field:'iconCls',title:'图标',width:40,align:'center',halign:'center',
			formatter:function(value,row,index){
				return '<i  class="'+value+' iconfont blue2">&nbsp;</i>';
		}},
	    {field:'systemName',title:'系统名称',width:120,align:'left',halign:'left',sortable:true},
	    {field:'systemCode',title:'系统编码',width:80,align:'center',halign:'center',sortable:true},
	    {field:'systemUrl',title:'系统地址',width:100,align:'center',halign:'center',sortable:true},
//	    {field:'params',title:'登录参数',width:100,align:'center',halign:'center',sortable:true},
//	    {field:'nameField',title:'用户名字段',width:100,align:'center',halign:'center',sortable:true},
//	    {field:'passwordField',title:'密码字段',width:100,align:'center',halign:'center',sortable:true},
//	    {field:'loginUrl',title:'登录地址',width:100,align:'center',halign:'center',sortable:true},
	    {field:'orderNum',title:'排序',width:100,align:'center',halign:'center',sortable:true}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			basSystemInfoFormDetail(row.id);
	    }
	});
	
    basSystemInfoGrid.datagrid('doCellTip');
    var pager = basSystemInfoGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('basSystemInfoGrid',"应用信息")
	        }    
	    }]   
	});
}


/**
 * 查看表单明细
 */
function basSystemInfoFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasSystemInfo&isdetail=true&id="+id
	});
}


/**
 * 重新加载
 */
function reloadBasSystemInfo(){
	basSystemInfoGrid.datagrid('reload');
}


/**
 * 查询
 */
function searchBasSystemInfo(){
	basSystemInfoGrid.datagrid('load',{
		fuzzy : $("#fuzzy").textbox("getValue")
	});
}


/**
 * 增加
 */
function addBasSystemInfo() {
	openSaveDialog({
		title : "添加记录",
		maximized : true,
		contenturl : "/GenForm/form?formcode=BasSystemInfo",
		submiturl : "/basSystemInfo/saveBasSystemInfo?formcode=BasSystemInfo",
		callback : reloadBasSystemInfo
	});
	
}


/**
 * 修改
 */
function editBasSystemInfo() {

	var row = basSystemInfoGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	openSaveDialog({
		title : "修改记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasSystemInfo&id=" + row.id,
		submiturl:"/basSystemInfo/saveBasSystemInfo?formcode=BasSystemInfo",
		callback : reloadBasSystemInfo
	});
}


/**
 * 删除
 */
function delBasSystemInfo() {

	var row = basSystemInfoGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
		if (r) {
			$.ajax({
				type : "post",
				url : ctx+"/basSystemInfo/delBasSystemInfo",
				data : {
					id : row.id
				},
				dataType : 'json',
				success : function(result) {
					if (result.success) {
						basSystemInfoGrid.datagrid('reload');
						alertInfo(result.msg);
					}else{
						alertError(result.msg);
					}
				}
			});
		}
	});
	
}
