
var basQuerySettingGrid = $("#basQuerySettingGrid");
$(function(){
	initBasQuerySettingGrid();
	bindEnterKey('#searchBasQuerySetting',searchBasQuerySetting);
});


/**
 * 初始化
 */
function initBasQuerySettingGrid(){
	basQuerySettingGrid.datagrid({
		height : $("body").height()*0.5-152,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		// pagination:true,
		queryParams:{
		},
		cls:'md',
		toolbar:"#basQuerySettingGridTbar",
	    url:ctx+'/basQuerySetting/pageAll',
	    columns:[[
	    {
			field:'opt',title:'明细',width:20,align:'center',
			formatter:function(value,row,index){
				return '<div onclick="basQuerySettingFormDetail('+row.id+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
			{field:'id',hidden:true},
			{field: 'settingName',title:'名称',width:40,align:'center',halign:'center',sortable:true},
			{field: 'settingCode',title:'编码',width:40,align:'center',halign:'center',sortable:true},
			{field: 'settingUrl',title:'跳转地址',width:40,align:'center',halign:'center',sortable:true},
			{field: 'remark',title:'备注',width:40,align:'center',halign:'center',sortable:true},
	    ]],
		onClickRow : function(index, row) {
			searchBasQuerySettingd(row.id);
			if ("Y"==row.isFilter){
				$('#addBasQuerySettingd').linkbutton('enable');
				$('#editBasQuerySettingd').linkbutton('enable');
				$('#delBasQuerySettingd').linkbutton('enable');
			}else{
				$('#addBasQuerySettingd').linkbutton('disable');
				$('#editBasQuerySettingd').linkbutton('disable');
				$('#delBasQuerySettingd').linkbutton('disable');
			}
		},
	    onDblClickRow:function(index, row){
    		//查看明细
			basQuerySettingFormDetail(row.id);
	    }
	});
	
    basQuerySettingGrid.datagrid('doCellTip');
    var pager = basQuerySettingGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('basQuerySettingGrid',"综合查询过滤")
	        }    
	    }]   
	});
}


/**
 * 查看表单明细
 */
function basQuerySettingFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : false,
		contenturl:"/GenForm/form?formcode=BasQuerySetting&isdetail=true&id="+id
	});
}


/**
 * 重新加载
 */
function reloadBasQuerySetting(){
	basQuerySettingGrid.datagrid('reload');
}


/**
 * 查询
 */
function searchBasQuerySetting(){
	basQuerySettingGrid.datagrid('load',{
		search:$("#searchBasQuerySetting").val()
	});
}


/**
 * 增加
 */
function addBasQuerySetting() {
	openSaveDialog({
		title : "添加记录",
		maximized : false,
		height: 400,
		contenturl : "/GenForm/form?formcode=BasQuerySetting",
		submiturl : "/basQuerySetting/saveBasQuerySetting?formcode=BasQuerySetting",
		callback : reloadBasQuerySetting
	});
	
}


/**
 * 修改
 */
function editBasQuerySetting() {

	var row = basQuerySettingGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	openSaveDialog({
		title : "修改记录",
		maximized : false,
		height: 400,
		contenturl:"/GenForm/form?formcode=BasQuerySetting&id=" + row.id,
		submiturl:"/basQuerySetting/saveBasQuerySetting?formcode=BasQuerySetting",
		callback : reloadBasQuerySetting
	});
}


/**
 * 删除
 */
function delBasQuerySetting() {

	var row = basQuerySettingGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
		if (r) {
			$.ajax({
				type : "post",
				url : ctx+"/basQuerySetting/delBasQuerySetting",
				data : {
					id : row.id
				},
				dataType : 'json',
				success : function(result) {
					if (result.success) {
						basQuerySettingGrid.datagrid('reload');
						alertInfo(result.msg);
					}else{
						alertError(result.msg);
					}
				}
			});
		}
	});
	
}
