
var basProcessForwardingdGrid = $("#basProcessForwardingdGrid");
$(function(){
	initBasProcessForwardingdGrid();
});


/**
 * 初始化
 */
function initBasProcessForwardingdGrid(){
	basProcessForwardingdGrid.datagrid({
		height : getMixGridHeight(),
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		queryParams:{
		},
		cls:'md',
		toolbar:"#basProcessForwardingdGridTbar",
	    url:ctx+'/basProcessForwardingd/pageAll',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){
				return '<div onclick="basProcessForwardingdFormDetail('+row.id+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			basProcessForwardingdFormDetail(row.id);
	    }
	});
	
    basProcessForwardingdGrid.datagrid('doCellTip');
    var pager = basProcessForwardingdGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('basProcessForwardingdGrid',"流程转发子表")
	        }    
	    }]   
	});
}


/**
 * 查看表单明细
 */
function basProcessForwardingdFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasProcessForwardingd&isdetail=true&id="+id
	});
}


/**
 * 重新加载
 */
function reloadBasProcessForwardingd(){
	basProcessForwardingdGrid.datagrid('reload');
}


/**
 * 查询
 */
function searchBasProcessForwardingd(){
	basProcessForwardingdGrid.datagrid('load',{

	});
}


/**
 * 增加
 */
function addBasProcessForwardingd() {
	openSaveDialog({
		title : "添加记录",
		maximized : true,
		contenturl : "/GenForm/form?formcode=BasProcessForwardingd",
		submiturl : "/basProcessForwardingd/saveBasProcessForwardingd?formcode=BasProcessForwardingd",
		callback : reloadBasProcessForwardingd
	});
	
}


/**
 * 修改
 */
function editBasProcessForwardingd() {

	var row = basProcessForwardingdGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	openSaveDialog({
		title : "修改记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasProcessForwardingd&id=" + row.id,
		submiturl:"/basProcessForwardingd/saveBasProcessForwardingd?formcode=BasProcessForwardingd",
		callback : reloadBasProcessForwardingd
	});
}


/**
 * 删除
 */
function delBasProcessForwardingd() {

	var row = basProcessForwardingdGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
		if (r) {
			$.ajax({
				type : "post",
				url : ctx+"/basProcessForwardingd/delBasProcessForwardingd",
				data : {
					id : row.id
				},
				dataType : 'json',
				success : function(result) {
					if (result.success) {
						basProcessForwardingdGrid.datagrid('reload');
						alertInfo(result.msg);
					}else{
						alertError(result.msg);
					}
				}
			});
		}
	});
	
}
