
var basAppUpdateGrid = $("#basAppUpdateGrid");
$(function(){
	initBasAppUpdateGrid();
	bindEnterKey('#searchBasAppUpdate',searchBasAppUpdate);
});


/**
 * 初始化
 */
function initBasAppUpdateGrid(){
	basAppUpdateGrid.datagrid({
		height : getMixGridHeight(),
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		queryParams:{
		},
		cls:'md',
		toolbar:"#basAppUpdateGridTbar",
	    url:ctx+'/basAppUpdate/pageAll',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){
				return '<div onclick="basAppUpdateFormDetail('+row.updateId+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    {field:'updateId',hidden:true},
	    {field:'appid',hidden:true},
	    {field:'appiosid',hidden:true},
	    {field:'version',title:'版本号',width:60,align:'center',halign:'center',sortable:true},
			{field:'updateTypeText',title:'更新类型',width:60,align:'center',halign:'center'},
			{field:'title',title:'标题',width:150,align:'center',halign:'center',sortable:true},
	    {field:'note',title:'更新内容',width:150,align:'center',halign:'center',sortable:true},
	    // {field:'fileId',title:'更新文件wgt/apk',width:100,align:'center',halign:'center',sortable:true},
	    {field:'updateAppTime',title:'APP更新时间',width:80,align:'center',halign:'center',sortable:true},
	    {field:'cou',title:'当前人数',width:80,align:'center',halign:'center',sortable:true,formatter:function(value,row){
	    	if(value){
	    		 return '<div style="cursor: pointer;color:#409eff;" onclick="appUseDetail(\''+row.version+'\')" >'+value+'</div>';
	    	}else{
	    		return value;
	    	}
	    }}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			basAppUpdateFormDetail(row.updateId);
	    }
	});
	
    basAppUpdateGrid.datagrid('doCellTip');
    var pager = basAppUpdateGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('basAppUpdateGrid',"APP更新发布")
	        }    
	    }]   
	});
}

function appUseDetail(version){
	openChooseDialog({
        title:  (version?"【"+version+"】":"")+"人员列表",
        iconCls: 'icon-jingyingfenxi iconfont blue2',
        width: 700,
        height: $("body").height()*0.9,
        isframe : true,
        okhandler:function(){
        	
        },
        contenturl: '/ReportBase/genReport?reportCode=appEmpVersion&showTitle=false&version=' + version
    });
}

function appUseSum(){
	openChooseDialog({
        title:  "版本统计",
        iconCls: 'icon-jingyingfenxi iconfont blue2',
        width: $("body").height()*0.8,
        height: $("body").height()*0.8,
        isframe : true,
        okhandler:function(){
        	
        },
        contenturl: '/ReportBase/genReport?reportCode=appEmpPie&showTitle=false'
    });
}
/**
 * 查看表单明细
 */
function basAppUpdateFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasAppUpdate&isdetail=true&id="+id
	});
}


/**
 * 重新加载
 */
function reloadBasAppUpdate(){
	basAppUpdateGrid.datagrid('reload');
}


/**
 * 查询
 */
function searchBasAppUpdate(){
	basAppUpdateGrid.datagrid('load',{
		search:$("#searchBasAppUpdate").val(),
	});
}


/**
 * 增加
 */
function addBasAppUpdate() {
	openSaveDialog({
		title : "添加记录",
		maximized : true,
		contenturl : "/GenForm/form?formcode=BasAppUpdate",
		submiturl : "/basAppUpdate/saveBasAppUpdate?formcode=BasAppUpdate",
		callback : reloadBasAppUpdate
	});
	
}


/**
 * 修改
 */
function editBasAppUpdate() {

	var row = basAppUpdateGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	openSaveDialog({
		title : "修改记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasAppUpdate&id=" + row.updateId,
		submiturl:"/basAppUpdate/saveBasAppUpdate?formcode=BasAppUpdate",
		callback : reloadBasAppUpdate
	});
}


/**
 * 删除
 */
function delBasAppUpdate() {

	var row = basAppUpdateGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
		if (r) {
			$.ajax({
				type : "post",
				url : ctx+"/basAppUpdate/delBasAppUpdate",
				data : {
					id : row.updateId
				},
				dataType : 'json',
				success : function(result) {
					if (result.success) {
						basAppUpdateGrid.datagrid('reload');
						alertInfo(result.msg);
					}else{
						alertError(result.msg);
					}
				}
			});
		}
	});
	
}
