var BasQrcodeDataGrid=$('#BasQrcode_datagrid');
$(function(){
    initBasQrcodeGrid();
    bindEnterKey("#searchBasQrcode",searchBasQrcode);
});

function initBasQrcodeGrid(){
    BasQrcodeDataGrid.datagrid({
        height:$("body").height()-172,
        border:false,
        singleSelect:true,
        rownumbers:true,
        fitColumns:true,
        pagination:true,
        queryParams:{
//			startDate:$('#sDate').datebox('getValue'),
//			endDate:$('#eDate').datebox('getValue')
        },
        cls:'md',
        toolbar:"#BasQrcode_datagrid_tb",
        url:ctx+'/BasQrcode/pageBasQrcode',
        columns:[[
            {
                field:'opt',title:'明细',width:40,align:'center',
                formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
                    return '<div onclick="BasQrcodeFormDetail('+row.id+')" class="icon-detail iconfont blue">&nbsp;</div>';
                }},
//	    {field:'id',title:'',width:100,align:'center',halign:'center',sortable:true},
            {field:'typeCode',title:'编码',width:100,align:'center',halign:'center',sortable:true},
            {field:'typeName',title:'名称',width:100,align:'center',halign:'center',sortable:true},
            {field:'url',title:'跳转地址',width:100,align:'center',halign:'center',sortable:true},
            {field:'formCode',title:'页面编码',width:100,align:'center',halign:'center',sortable:true},
            {field:'isEnable',hidden:true},
            {field:'isEnableText',title:'是否启用',width:100,align:'center',halign:'center',sortable:true},
            {field:'logo',title:'logo',width:100,align:'center',halign:'center',sortable:true}
        ]],
        onDblClickRow:function(index, row){
            //查看明细
            BasQrcodeFormDetail(row.id);
        }
    });
    BasQrcodeDataGrid.datagrid('doCellTip');
    var pager = BasQrcodeDataGrid.datagrid('getPager');
    pager.pagination({
        buttons:[{
            iconCls:'icon-page_excel',
            handler:function(){
                exportExcel('BasQrcode_datagrid',"title");
            }
        }]
    });
}
//查看表单明细
function BasQrcodeFormDetail(id){
    openDetailDialog({
        title : "查看记录",
        maximized : true,
        contenturl:"/GenForm/form?formcode=BasQrcode&isdetail=true&id="+id
    });
}
//重新加载表格
function reloadBasQrcode(){
    BasQrcodeDataGrid.datagrid('reload');
}
//查询表格
function searchBasQrcode(){
    BasQrcodeDataGrid.datagrid('load',{
        search:$("#searchBasQrcode").val()
    });
}

//增加记录
function addBasQrcode() {
    openSaveDialog({
        title:"添加记录",
        maximized : true,
        contenturl:"/GenForm/form?formcode=BasQrcode",
        submiturl:"/BasQrcode/saveBasQrcode?formcode=BasQrcode",
//		contenturl:"/view/base/BasQrcode",
//		submiturl:"/BasQrcode/saveBasQrcode",
        callback:reloadBasQrcode
    });

}

//修改记录
function editBasQrcode() {
    var row = BasQrcodeDataGrid.datagrid('getSelected');
    if (row) {
        var id = row.id;
        openSaveDialog({
            title : "修改记录",
            maximized : true,
            contenturl:"/GenForm/form?formcode=BasQrcode&id=" + id,
            submiturl:"/BasQrcode/saveBasQrcode?formcode=BasQrcode",
            callback : reloadBasQrcode
        });

    } else {
        alertWarn('请选择一条记录进行修改');
    }
}

//删除记录
function delBasQrcode() {
    var row = BasQrcodeDataGrid.datagrid('getSelected');
    if (row) {
        var id =row.id;
        alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
            if (r) {
                $.ajax({
                    url : ctx+"/BasQrcode/delBasQrcode",
                    data : {
                        id : id
                    },
                    dataType : 'json',
                    success : function(result) {
                        if (result.success) {
                            BasQrcodeDataGrid.datagrid('reload');
                            alertInfo(result.msg);
                        }else{
                            alertError(result.msg);
                        }
                    }
                });
            }
        });
    } else {
        alertWarn('请先选择要删除的数据信息');
    }
}
