/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.workflow.service;

import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import com.guochuang.imp.util.StringUtil;
import com.guochuang.imp.workflow.dao.WfWorkitemTransferDao;
import com.guochuang.imp.workflow.entity.WfWorkitemTransfer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class WfWorkitemTransferService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private WfWorkitemTransferDao wfWorkitemTransferDao;

    public PageObject pageAll(String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtil.isEmpty(search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtil.isEmpty(sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtil.isEmpty(order)) {
            params.put("order", order);
        }
        PageObject<Map<String, Object>> pageObject = this.bSqlHelper.serachPage("workflow.WfWorkitemTransfer.pageAll", params, PageRequest.of((int)page, (int)rows));
        return pageObject;
    }

    @Transactional
    public void saveWfWorkitemTransfer(WfWorkitemTransfer entity) {
        this.wfWorkitemTransferDao.save(entity);
    }

    public WfWorkitemTransfer findWfWorkitemTransfer(Long id) {
        WfWorkitemTransfer entity = (WfWorkitemTransfer)this.wfWorkitemTransferDao.findById(id).get();
        return entity;
    }

    public void delWfWorkitemTransfer(Long id) {
        WfWorkitemTransfer entity = (WfWorkitemTransfer)this.wfWorkitemTransferDao.findById(id).get();
        entity.setIsUse("N");
        this.wfWorkitemTransferDao.save(entity);
    }

    public List<WfWorkitemTransfer> findWfWorkitemTransfersByFromWorkitemid(Long fromWorkitemid) {
        List<WfWorkitemTransfer> list = this.wfWorkitemTransferDao.findWfWorkitemTransferByFromWorkitemidAndIsUse(fromWorkitemid, "Y");
        return list;
    }

    public List<WfWorkitemTransfer> findWfWorkitemTransfersByProcessinstid(Long processinstid) {
        List<WfWorkitemTransfer> list = this.wfWorkitemTransferDao.findWfWorkitemTransferByProcessinstidAndIsUse(processinstid, "Y");
        return list;
    }
}

