/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.workflow.service;

import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.dao.BasEmpAccountDao;
import com.guochuang.imp.base.entity.BasEmpAccount;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import com.guochuang.imp.util.StringUtil;
import com.guochuang.imp.workflow.dao.WfConfirmPersonsDao;
import com.guochuang.imp.workflow.entity.WfConfirmPersons;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class WfConfirmPersonsService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private WfConfirmPersonsDao wfConfirmPersonsDao;
    @Autowired
    private BasEmpAccountDao basEmpAccountDao;

    public PageObject pageAll(String groupName, String affirmWay, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtil.isEmpty(groupName)) {
            params.put("groupName", "%" + groupName + "%");
        }
        if (!StringUtil.isEmpty(affirmWay)) {
            params.put("affirmWay", affirmWay);
        }
        if (!StringUtil.isEmpty(sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtil.isEmpty(order)) {
            params.put("order", order);
        }
        PageObject<Map<String, Object>> pageObject = this.bSqlHelper.serachPage("workflow.WfConfirmPersons.pageAll", params, PageRequest.of((int)page, (int)rows));
        return pageObject;
    }

    @Transactional
    @CacheEvict(cacheNames={"ConfirmCache"}, allEntries=true)
    public void saveWfConfirmPersons(WfConfirmPersons entity) {
        this.wfConfirmPersonsDao.save(entity);
    }

    public WfConfirmPersons findWfConfirmPersons(Long id) {
        WfConfirmPersons entity = (WfConfirmPersons)this.wfConfirmPersonsDao.findById(id).get();
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (id != null) {
            params.put("confirmId", id);
        }
        Map<String, Object> mapUser = this.bSqlHelper.getMap("workflow.WfConfirmPersons.getUserIdTextByConfirmId", params);
        Map<String, Object> mapFlow = this.bSqlHelper.getMap("workflow.WfConfirmPersons.getFlowListTextByConfirmId", params);
        entity.setUserId((String)mapUser.get("userId"));
        entity.setUserId_TEXT_((String)mapUser.get("userName"));
        entity.setFlowList_TEXT_((String)mapFlow.get("flowText"));
        return entity;
    }

    @CacheEvict(cacheNames={"ConfirmCache"}, allEntries=true)
    public void delWfConfirmPersons(Long id) {
        WfConfirmPersons entity = (WfConfirmPersons)this.wfConfirmPersonsDao.findById(id).get();
        entity.setIsUse("N");
        this.wfConfirmPersonsDao.save(entity);
    }

    @Cacheable(cacheNames={"ConfirmCache"}, key="targetClass + '.' + methodName + '.'+#root.args[0]+ '.'+#root.args[1]")
    public String findAffirmWayByAccountId(Long accountId, Long businessProcessId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        BasEmpAccount basEmpAccount = this.basEmpAccountDao.findByAccountIdAndIsUse(accountId, "Y");
        params.put("orgId", basEmpAccount.getOrgId());
        params.put("deptId", basEmpAccount.getDeptId());
        params.put("userId", accountId);
        params.put("businessProcessId", businessProcessId.toString());
        Map<String, Object> map = this.bSqlHelper.getMap("workflow.WfConfirmPersons.findAffirmWayByAccountId", params);
        if ("Y".equals(Objects.toString(map.get("isMsgConfirm")))) {
            return "msg";
        }
        if ("Y".equals(Objects.toString(map.get("isPasswordConfirm")))) {
            return "password";
        }
        return null;
    }
}

