/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.workflow.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.controller.BaseController;
import com.guochuang.imp.workflow.entity.WfCommonphrase;
import com.guochuang.imp.workflow.service.WfCommonphraseService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/WfCommonphrase"})
public class WfCommonphraseController
extends BaseController {
    @Autowired
    private WfCommonphraseService wfcommonphraseService;

    @RequestMapping(value={"/pageWfCommonphrase"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pageWfCommonphrase(HttpServletRequest request, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, String sort, String order, String phraseType, String commonPhrase) {
        Long accountid = this.getLoginUser(request).getAccountid();
        return this.wfcommonphraseService.PageAll(accountid, search, page, rows, sort, order, phraseType, commonPhrase);
    }

    @RequestMapping(value={"/findWfCommonphrase"})
    @ResponseBody
    public Object findWfCommonphrase(Long id) {
        WfCommonphrase entity = this.wfcommonphraseService.findWfCommonphrase(id);
        return entity;
    }

    @RequestMapping(value={"/saveWfCommonphrase"})
    @ResponseBody
    public Object saveWfCommonphrase(HttpServletRequest request, WfCommonphrase entity) {
        JsonMsg msg = new JsonMsg();
        entity.setModifyAccount(this.getLoginUser(request).getAccountid());
        entity.setModifyTime(new Date());
        if (entity.getAccountId() == null) {
            entity.setAccountId(this.getLoginUser(request).getAccountid());
        }
        entity.setIsUse("Y");
        if (entity.getPhraseId() == null) {
            entity.setCreateAccount(this.getLoginUser(request).getAccountid());
            entity.setCreateTime(new Date());
        }
        if (StringUtils.isBlank((CharSequence)entity.getPhraseType())) {
            entity.setPhraseType("2");
        }
        if (entity.getDisplayNo() == null) {
            entity.setDisplayNo(this.wfcommonphraseService.getMaxDisplayNo(entity.getCreateAccount()));
        }
        this.wfcommonphraseService.saveWfCommonphrase(entity);
        msg.setO(entity);
        return msg;
    }

    @RequestMapping(value={"/delWfCommonphrase"})
    @ResponseBody
    public Object delWfCommonphrase(Long id) {
        this.wfcommonphraseService.delWfCommonphrase(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/findByAccountOrCommon"})
    @ResponseBody
    public List<WfCommonphrase> findByAccountOrCommon(HttpServletRequest request) {
        Long accountid = this.getLoginUser(request).getAccountid();
        return this.wfcommonphraseService.findByAccountOrCommon(accountid);
    }

    @RequestMapping(value={"/saveWfCommonphraseDisplayNo"})
    @ResponseBody
    public Object saveWfCommonphraseDisplayNo(HttpServletRequest request) {
        String data = request.getParameter("data");
        JSONArray listData = JSON.parseArray((String)data);
        for (int i = 0; i < listData.size(); ++i) {
            Map m = (Map)listData.get(i);
            String id = m.get("phraseId").toString();
            WfCommonphrase phrase = this.wfcommonphraseService.findWfCommonphrase(Long.parseLong(id));
            phrase.setDisplayNo(Long.valueOf(i + 1));
            this.wfcommonphraseService.saveWfCommonphrase(phrase);
        }
        return new JsonMsg();
    }

    @RequestMapping(value={"/getMaxDisplayNo"})
    @ResponseBody
    public Object getMaxDisplayNo(HttpServletRequest request) {
        Long accountid = this.getLoginUser(request).getAccountid();
        Long dispalyNo = this.wfcommonphraseService.getMaxDisplayNo(accountid);
        JsonMsg msg = new JsonMsg();
        msg.setO(dispalyNo);
        return msg;
    }
}

