/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.sys.controller;

import com.alibaba.fastjson.JSONObject;
import com.guochuang.imp.base.controller.BaseController;
import com.guochuang.imp.doc.common.FileService;
import com.guochuang.imp.doc.common.persist.FileInfo;
import com.guochuang.imp.doc.common.util.FileStoreException;
import com.guochuang.imp.sys.entity.ConfigManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"/ueditor"})
public class UEditorController
extends BaseController {
    @Autowired
    private FileService fileService;
    public static final int CONFIG = 0;
    public static final int UPLOAD_IMAGE = 1;
    public static final int UPLOAD_SCRAWL = 2;
    public static final int UPLOAD_VIDEO = 3;
    public static final int UPLOAD_FILE = 4;
    public static final int CATCH_IMAGE = 5;
    public static final int LIST_FILE = 6;
    public static final int LIST_IMAGE = 7;
    public static final Map<String, Integer> mapping = new HashMap<String, Integer>(){
        {
            this.put("config", 0);
            this.put("uploadimage", 1);
            this.put("uploadscrawl", 2);
            this.put("uploadvideo", 3);
            this.put("uploadfile", 4);
            this.put("catchimage", 5);
            this.put("listfile", 6);
            this.put("listimage", 7);
        }
    };

    @RequestMapping(value={"/action"})
    @ResponseBody
    public Object action(HttpServletResponse response, HttpServletRequest request, String action) throws FileStoreException, IOException, IllegalStateException, InterruptedException, ExecutionException {
        int actionCode = mapping.get(action);
        String callbackName = request.getParameter("callback");
        if (callbackName != null) {
            if (!this.validCallbackName(callbackName)) {
                JSONObject json = new JSONObject();
                json.put("state", (Object)"callback\u53c2\u6570\u540d\u4e0d\u5408\u6cd5");
                return json.toJSONString();
            }
            return callbackName + "(" + this.actionjson(actionCode, request) + ");";
        }
        return this.actionjson(actionCode, request);
    }

    public Map<String, Object> actionjson(int actionCode, HttpServletRequest request) throws FileStoreException, IllegalStateException, IOException, InterruptedException, ExecutionException {
        JSONObject json = new JSONObject();
        HashMap<String, Object> result = new HashMap<String, Object>();
        switch (actionCode) {
            case 0: {
                return ConfigManager.getInstance(request.getContextPath(), request.getContextPath(), request.getRequestURI()).getAllConfig();
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                MultipartHttpServletRequest filerequest = (MultipartHttpServletRequest)request;
                Map requestFile = filerequest.getFileMap();
                Iterator it = requestFile.values().iterator();
                if (it.hasNext()) {
                    MultipartFile file = (MultipartFile)it.next();
                    FileInfo docfile = new FileInfo();
                    docfile.setCatalogid("1");
                    docfile.setLoginuser(this.getLoginUser(request));
                    Long fileid = this.fileService.upLoadFile(file, docfile).getVersionid();
                    result.put("state", "SUCCESS");
                    result.put("url", request.getContextPath() + "/file/viewPic?versionid=" + fileid);
                    result.put("title", file.getOriginalFilename());
                    result.put("original", file.getOriginalFilename());
                    return result;
                }
            }
            case 5: {
                break;
            }
        }
        return result;
    }

    public boolean validCallbackName(String name) {
        return name.matches("^[a-zA-Z_]+[\\w0-9_]*$");
    }
}

