/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.report.service;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.DataSourceutil;
import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.common.util.LoginUser;
import com.guochuang.imp.base.common.util.NativeSqlHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.common.util.StrKit;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.base.service.CommonService;
import com.guochuang.imp.gen.util.FreeMarkerUtil;
import com.guochuang.imp.report.dao.ReportBaseChartDao;
import com.guochuang.imp.report.dao.ReportBaseColumnDao;
import com.guochuang.imp.report.dao.ReportBaseDao;
import com.guochuang.imp.report.dao.ReportBaseDsDao;
import com.guochuang.imp.report.entity.ReportBasVirtual;
import com.guochuang.imp.report.entity.ReportBase;
import com.guochuang.imp.report.entity.ReportBaseChart;
import com.guochuang.imp.report.entity.ReportBaseColumn;
import com.guochuang.imp.report.entity.ReportBaseDs;
import com.guochuang.imp.report.entity.ReportBean;
import com.guochuang.imp.report.service.ReportBaseChartService;
import com.guochuang.imp.report.service.ReportBaseColumnService;
import com.guochuang.imp.report.service.ReportBaseDsService;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class ReportBaseService {
    private static final Logger logger = Logger.getLogger(ReportBaseService.class);
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private ReportBaseDao reportbaseDao;
    @Autowired
    private ReportBaseColumnDao reportBaseColumnDao;
    @Autowired
    private ReportBaseChartDao reportBaseChartDao;
    @Autowired
    private ReportBaseDsDao reportBaseDsDao;
    @Autowired
    private DataSourceutil dataSourceutil;
    private static Pattern pattern = Pattern.compile("^[-\\+]?[\\d|\\.]*$");
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private ReportBaseService reportBaseService;
    @Autowired
    private ReportBaseChartService reportBaseChartService;
    @Autowired
    private ReportBaseColumnService reportBaseColumnService;
    @Autowired
    private ReportBaseDsService reportBaseDsService;

    public ReportBase findReportBase(Long id) {
        ReportBase entity = (ReportBase)this.reportbaseDao.findById(id).get();
        return entity;
    }

    public ReportBean genReport(String reportCode, LoginUser user, HttpServletRequest request) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        ReportBean bean = new ReportBean();
        HashMap<String, Object> freemarkmap = new HashMap<String, Object>();
        freemarkmap.put("loginuser", user);
        ReportBase reportold = this.reportbaseDao.findByReportCodeAndIsUse(reportCode, "Y");
        ReportBase report = (ReportBase)BeanUtils.cloneBean((Object)reportold);
        report.setDataOptions(FreeMarkerUtil.instance().genString(report.getDataOptions(), freemarkmap));
        bean.setReport(report);
        Enumeration enu = request.getParameterNames();
        while (enu.hasMoreElements()) {
            String paraName = (String)enu.nextElement();
            freemarkmap.put(paraName, request.getParameter(paraName));
        }
        if (StringUtils.isNotBlank((String)report.getDataOptions())) {
            report.setDataOptions(FreeMarkerUtil.instance().genString(report.getDataOptions(), freemarkmap));
        }
        if (StringUtils.isNotBlank((String)report.getReportScript())) {
            report.setReportScript(FreeMarkerUtil.instance().genString(report.getReportScript(), freemarkmap));
        }
        if ("1".equals(report.getReportType())) {
            List<ReportBaseColumn> columns = this.getColumnsByReportId(report.getId());
            for (ReportBaseColumn column : columns) {
                if ("Y".equals(column.getIsSearch())) {
                    bean.addSearchColumns(column);
                }
                if (!"Y".equals(column.getIsHidden())) {
                    if ("Y".equals(column.getIsFrozen())) {
                        bean.addFrozenColumns(column, column.getRowNum() == null ? 0 : column.getRowNum().intValue());
                    } else {
                        bean.addColumns(column, column.getRowNum() == null ? 0 : column.getRowNum().intValue());
                    }
                }
                column.setSearchOptions(FreeMarkerUtil.instance().genString(column.getSearchOptions(), freemarkmap));
            }
        } else if ("2".equals(report.getReportType())) {
            List<ReportBaseChart> charts = this.reportBaseChartDao.findByReportIdAndIsUse(report.getId(), "Y");
            for (ReportBaseChart chart : charts) {
                ReportBaseDs ds = (ReportBaseDs)this.reportBaseDsDao.findById(chart.getDsId()).get();
                String sqlstr = FreeMarkerUtil.instance().genString(ds.getSqlScript(), freemarkmap);
                chart.setData(this.sqlHelper.queryByNativeSQL(sqlstr, new int[0]));
                if (!StringUtils.isNotBlank((String)chart.getClassField())) continue;
                ArrayList<String> series = new ArrayList<String>();
                StringBuilder seriesSql = new StringBuilder("select \n");
                for (Map<?, ?> map : chart.getData()) {
                    if (ObjectUtil.isEmpty(map.get(chart.getNameField()))) {
                        logger.warn((Object)(reportCode + "\u62a5\u8868\u6709\u5206\u7c7b\u4e3a\u7a7a\u7684\u6570\u636e\uff0c\u5df2\u81ea\u52a8\u5ffd\u7565"));
                        continue;
                    }
                    String serie = map.get(chart.getNameField()).toString();
                    if (series.contains(serie)) continue;
                    series.add(serie);
                    seriesSql.append("max(DECODE_VARCHAR(" + chart.getNameField() + ",'" + serie + "'," + chart.getValueField() + ",0)) \"" + serie + "\",\n");
                }
                chart.setSeries(series);
                seriesSql.append(chart.getClassField());
                seriesSql.append("\n from(" + sqlstr + ")o \n");
                seriesSql.append(" group by ");
                seriesSql.append(chart.getClassField());
                if (StringUtils.isNotBlank((String)chart.getOrderByCol())) {
                    seriesSql.append("\n order by " + chart.getOrderByCol());
                } else {
                    seriesSql.append("\n order by \n");
                    seriesSql.append(chart.getClassField());
                }
                logger.info((Object)("\n\u6267\u884csql: \n" + seriesSql));
                chart.setData(this.sqlHelper.queryByNativeSQL(seriesSql.toString(), new int[0]));
            }
            bean.setCharts(charts);
        }
        return bean;
    }

    public List<ReportBaseColumn> getColumnsByReportId(Long reportId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select t.*, ");
        sql.append("(with recursive temp as(\n\t\t\t\t select a.*,1 level from report_base_column a where  a.id=t.id\n\t\t\t\t union all\n\t\t\t\t select a.*,temp.level+1 level  from report_base_column a,temp where temp.parent_field=a.column_code and a.REPORT_ID=temp.REPORT_ID)\n\t\t\t\t select group_concat( a.column_code order by level) from temp a) PARENT_FIELDS ");
        sql.append(" from REPORT_BASE_COLUMN t  ");
        sql.append(" where t.is_use=:isUse ");
        params.put("isUse", "Y");
        sql.append(" and t.report_id=:reportId ");
        params.put("reportId", reportId);
        sql.append(" order by case when t.IS_HIDDEN='Y' then 2 else 1 end,case when t.IS_FROZEN='Y' then 1 else 2 end ,t.row_num,t.order_by");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), params, new int[0]);
        return JSON.parseArray((String)JSON.toJSONString((Object)list), ReportBaseColumn.class);
    }

    public void saveReportBase(ReportBase entity, String rows) {
        List list;
        Long id = entity.getId();
        this.reportbaseDao.save(entity);
        if ("1".equals(entity.getReportType())) {
            Map<String, Map<String, Object>> columns = this.dataSourceutil.getColunms(entity.getSqlScript());
            Long i = 0L;
            for (Map.Entry<String, Map<String, Object>> entry : columns.entrySet()) {
                Map<String, Object> map = entry.getValue();
                Long l = i;
                Long l2 = i = Long.valueOf(i + 1L);
                if (!this.reportBaseColumnDao.findByReportIdAndColumnCode(entity.getId(), map.get("name").toString()).isEmpty()) continue;
                ReportBaseColumn column = new ReportBaseColumn();
                column.setColumnName(map.get("name").toString());
                column.setColumnCode(map.get("name").toString().toUpperCase());
                Long precision = Long.parseLong(map.get("precision").toString());
                precision = precision > 500L ? 500L : (precision < 100L ? 100L : precision);
                column.setColumnWidth(precision);
                column.setReportId(entity.getId());
                column.setIsUse("Y");
                column.setOrderBy(i);
                column.setColumnColspan(1L);
                column.setColumnRowspan(1L);
                column.setRowNum(0L);
                column.setIsFrozen("N");
                column.setIsSearch("N");
                column.setIsHidden("N");
                column.setColumnAlign("center");
                this.reportBaseColumnDao.save(column);
            }
            List list2 = JSON.parseArray((String)rows, ReportBaseColumn.class);
            if (list2 != null) {
                if (list2.size() > 0) {
                    for (ReportBaseColumn column : list2) {
                        column.setReportId(entity.getId());
                        column.setIsUse(entity.getIsUse());
                    }
                }
                this.reportBaseColumnDao.saveAll(list2);
            }
        } else if ("2".equals(entity.getReportType()) && (list = JSON.parseArray((String)rows, ReportBaseChart.class)) != null) {
            if (list.size() > 0) {
                for (ReportBaseChart chart : list) {
                    chart.setReportId(entity.getId());
                    chart.setIsUse(entity.getIsUse());
                }
            }
            this.reportBaseChartDao.saveAll(list);
        }
    }

    public void copyReportBase(Long id) throws IllegalAccessException, InvocationTargetException {
        ReportBase entity = (ReportBase)this.reportbaseDao.findById(id).get();
        ReportBase newreport = new ReportBase();
        ConvertUtils.register((Converter)new DateConverter(null), Date.class);
        org.springframework.beans.BeanUtils.copyProperties((Object)entity, (Object)newreport);
        newreport.setId(null);
        newreport.setReportCode(newreport.getReportCode() + "clone" + System.currentTimeMillis());
        newreport.setReportName(newreport.getReportName() + "\u526f\u672c");
        this.reportbaseDao.save(newreport);
        List<ReportBaseColumn> list = this.reportBaseColumnDao.findByReportIdAndIsUseOrderByOrderBy(id, "Y");
        ArrayList<ReportBaseColumn> nlist = new ArrayList<ReportBaseColumn>(list.size());
        for (ReportBaseColumn col : list) {
            ReportBaseColumn nColumn = new ReportBaseColumn();
            org.springframework.beans.BeanUtils.copyProperties((Object)col, (Object)nColumn);
            nColumn.setId(null);
            nColumn.setReportId(newreport.getId());
            nlist.add(nColumn);
        }
        this.reportBaseColumnDao.saveAll(nlist);
        List<ReportBaseDs> listds = this.reportBaseDsDao.findByReportIdAndIsUse(id, "Y");
        ArrayList<ReportBaseDs> nlistds = new ArrayList<ReportBaseDs>(listds.size());
        for (ReportBaseDs ds : listds) {
            ReportBaseDs nds = new ReportBaseDs();
            org.springframework.beans.BeanUtils.copyProperties((Object)ds, (Object)nds);
            nds.setId(null);
            nds.setReportId(newreport.getId());
            nlistds.add(nds);
        }
        this.reportBaseDsDao.saveAll(nlistds);
        List<ReportBaseChart> listchart = this.reportBaseChartDao.findByReportIdAndIsUse(id, "Y");
        ArrayList<ReportBaseChart> nlistchart = new ArrayList<ReportBaseChart>(listchart.size());
        for (ReportBaseChart chart : listchart) {
            ReportBaseChart nchart = new ReportBaseChart();
            org.springframework.beans.BeanUtils.copyProperties((Object)chart, (Object)nchart);
            nchart.setId(null);
            nchart.setReportId(newreport.getId());
            nlistchart.add(nchart);
        }
        this.reportBaseChartDao.saveAll(nlistchart);
    }

    public void delReportBase(Long id) {
        ReportBase entity = (ReportBase)this.reportbaseDao.findById(id).get();
        entity.setIsUse("N");
        this.reportbaseDao.save(entity);
    }

    public PageObject PageAll(String search, int page, int rows, String sort, String order) {
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select t.*,getaccountname(t.CREATE_BY) CREATE_BY_TEXT_  ");
        sql.append(" from REPORT_BASE t  ");
        sql.append(" where t.is_use=:isUse ");
        params.put("isUse", "Y");
        if (!StringUtils.isEmpty((String)search)) {
            sql.append(" and  (");
            sql.append(" upper(t.REPORT_NAME) like :search ");
            sql.append(" or upper(t.REPORT_CODE) like :search ");
            sql.append(") ");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by t.ID");
        if (StrKit.notBlank(sort)) {
            String exesql = "select * from (" + sql.toString() + ") temp  " + SysUtils.genOrderBy(sort, order);
            pageobject = this.sqlHelper.pagerNativeSQL(exesql, params, (Integer)page, (Integer)rows);
        } else {
            pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        }
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("REPORT_TYPE", "reportType");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public PageObject queryReport(String search, int page, int rows, String sort, String order, Long id, LoginUser user, HttpServletRequest request) {
        PageObject pageobject = new PageObject();
        ReportBase report = (ReportBase)this.reportbaseDao.findById(id).get();
        List<ReportBaseColumn> columns = this.reportBaseColumnDao.findByReportIdAndIsUseOrderByOrderBy(report.getId(), "Y");
        Map<String, Map<String, Object>> sqlcolumns = this.dataSourceutil.getColunms(report.getSqlScript());
        HashMap<String, Object> freemarkmap = new HashMap<String, Object>();
        Enumeration enu = request.getParameterNames();
        while (enu.hasMoreElements()) {
            String paraName = (String)enu.nextElement();
            freemarkmap.put(paraName, request.getParameter(paraName));
        }
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        freemarkmap.put("loginuser", user);
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        sql.append("select * from(select *   \n");
        for (ReportBaseColumn column : columns) {
            if (!sqlcolumns.containsKey(column.getColumnCode()) && !sqlcolumns.containsKey(column.getColumnCode().toLowerCase()) || !StringUtils.isNotBlank((String)column.getDicCode())) continue;
            sql.append(",getdicname('" + column.getDicCode() + "'," + column.getColumnCode() + ") " + column.getColumnCode() + "_TEXT_\n");
            dicmapper.put(column.getColumnCode(), column.getDicCode());
        }
        sql.append("from (\n");
        sql.append(report.getSqlScript());
        sql.append(" )t)t where 1=1 \n");
        HashMap<String, Object> sumColumns = new HashMap<String, Object>();
        Map<String, BigDecimal> sumAllColumns = new HashMap();
        for (ReportBaseColumn column : columns) {
            if ("Y".equals(column.getIsSum())) {
                sumColumns.put(column.getColumnCode(), new BigDecimal(0));
            }
            freemarkmap.put(column.getColumnCode(), request.getParameter(column.getColumnCode()));
            if (StringUtils.isNotBlank((String)request.getParameter(column.getColumnCode()))) {
                if (sqlcolumns.containsKey(column.getColumnCode()) || sqlcolumns.containsKey(column.getColumnCode().toLowerCase())) {
                    Object colName = "";
                    String comparstr = "=";
                    if (StringUtils.isNotBlank((String)column.getDicCode()) && "textbox".equals(column.getColumnType())) {
                        colName = "_TEXT_";
                    }
                    if ("textbox".equals(column.getColumnType()) || Objects.toString(sqlcolumns.get(column.getColumnCode()).get("type")).equals("-1")) {
                        comparstr = "like";
                    }
                    sql.append(" and t." + column.getColumnCode() + (String)colName + " " + comparstr + ":" + column.getColumnCode() + " \n");
                }
                if (!sqlcolumns.containsKey(column.getColumnCode()) && !sqlcolumns.containsKey(column.getColumnCode().toLowerCase()) && !report.getSqlScript().contains(":" + column.getColumnCode())) continue;
                if ("textbox".equals(column.getColumnType()) || Objects.toString(sqlcolumns.get(column.getColumnCode()).get("type")).equals("-1")) {
                    params.put(column.getColumnCode(), "%" + request.getParameter(column.getColumnCode()) + "%");
                    continue;
                }
                params.put(column.getColumnCode(), request.getParameter(column.getColumnCode()));
                continue;
            }
            sql = new StringBuilder(sql.toString().replaceAll("(=|<|>|<=|>=|)\\s*:" + column.getColumnCode() + "\\b", " is not null"));
        }
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
            sql.append(" and  ( 1=2 ");
            for (ReportBaseColumn column : columns) {
                if (!sqlcolumns.containsKey(column.getColumnCode()) && !sqlcolumns.containsKey(column.getColumnCode().toLowerCase())) continue;
                sql.append(" or upper(cast(t." + column.getColumnCode() + " as char)) like :search ");
                if (!StringUtils.isNotBlank((String)column.getDicCode())) continue;
                sql.append(" or upper(cast(t." + column.getColumnCode() + "_TEXT_ as char)) like :search ");
            }
            sql.append(") ");
        }
        String sqlstr = FreeMarkerUtil.instance().genString(sql.toString(), freemarkmap);
        try {
            if (StrKit.notBlank(sort)) {
                String exesql = "select t.* from (" + sqlstr + ") t " + SysUtils.genOrderBy("t." + sort, order);
                logger.info((Object)("\n\u6267\u884csql: \n" + exesql));
                logger.info((Object)("\n\u53c2\u6570: " + JSON.toJSONString(params)));
                pageobject = this.sqlHelper.pagerNativeSQL(exesql, params, (Integer)page, (Integer)rows);
            } else {
                logger.info((Object)("\n\u6267\u884csql: \n" + sqlstr));
                logger.info((Object)("\n\u53c2\u6570: " + JSON.toJSONString(params)));
                pageobject = this.sqlHelper.pagerNativeSQL(sqlstr, params, (Integer)page, (Integer)rows);
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u62a5\u8868\u67e5\u8be2\u51fa\u9519:" + e.getMessage()));
        }
        if (!sumColumns.isEmpty()) {
            String sumsql = "select ";
            for (String columnCode : sumColumns.keySet()) {
                sumsql = sumsql + " sum(ifnull(x." + columnCode + ",0)) " + columnCode + ",";
            }
            sumsql = sumsql.substring(0, sumsql.length() - 1);
            sumsql = sumsql + " from (" + sqlstr + ") x";
            sumAllColumns = (Map)this.sqlHelper.queryByNativeSQL(sumsql, params, new int[0]).get(0);
            Pattern pattern = Pattern.compile("^[-\\+]?[\\d|\\.]*$");
            ArrayList<Map<String, Object>> footer = new ArrayList<Map<String, Object>>(1);
            for (Object obj : pageobject.getRows()) {
                Map map = (Map)obj;
                for (String columnCode : sumColumns.keySet()) {
                    if (map.get(columnCode) == null || !pattern.matcher(map.get(columnCode).toString()).matches()) continue;
                    sumColumns.put(columnCode, ((BigDecimal)sumColumns.get(columnCode)).add(new BigDecimal(map.get(columnCode).toString())));
                }
            }
            for (String key : sumAllColumns.keySet()) {
                Object value = sumAllColumns.get(key);
                if (value == null) continue;
                sumAllColumns.put(key, new BigDecimal(value.toString()));
            }
            for (ReportBaseColumn column : columns) {
                if ("Y".equals(column.getIsHidden())) continue;
                sumColumns.put("isFooter", true);
                sumAllColumns.put("isFooter", (BigDecimal)((Object)Boolean.valueOf(true)));
                sumColumns.put(column.getColumnCode(), "\u672c\u9875\u5408\u8ba1");
                sumAllColumns.put(column.getColumnCode(), (BigDecimal)((Object)"\u5408\u8ba1"));
                footer.add(sumColumns);
                footer.add(sumAllColumns);
                pageobject.setFooter(footer);
                break;
            }
        }
        return pageobject;
    }

    public Object pageReportBas(String search, int page, int rows) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!org.springframework.util.StringUtils.isEmpty((Object)search)) {
            params.put("search", "%" + search + "%");
        }
        return this.bSqlHelper.serachPage("report.reportBase.pageReportBas", params, PageRequest.of((int)page, (int)rows));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportReportBasXml(String ids, HttpServletResponse response) {
        ArrayList<ReportBasVirtual> list = new ArrayList<ReportBasVirtual>();
        String title = "";
        String[] idList = ids.split(";");
        int num = idList.length;
        String str = "\u81ea\u5b9a\u4e49\u62a5\u8868";
        if (num > 3) {
            num = 3;
            str = "\u7b49\u81ea\u5b9a\u4e49\u62a5\u8868";
        }
        for (int i = 0; i < idList.length; ++i) {
            ReportBasVirtual reportBasVirtual = this.getReportBasAllInfo(idList[i]);
            list.add(reportBasVirtual);
            if (i < num - 1) {
                title = title + reportBasVirtual.getReportName() + "\u3001";
            }
            if (i != num - 1) continue;
            title = title + reportBasVirtual.getReportName() + str;
        }
        JSONArray json = JSONUtil.parseArray(list);
        ServletOutputStream out = null;
        try {
            response.setContentType("text/plain");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String((title + ".json").getBytes("utf-8"), "iso-8859-1"));
            out = response.getOutputStream();
            out.write(json.toJSONString(1).getBytes());
        }
        catch (Exception var20) {
            String msg = var20.getCause().getMessage();
            if (msg == null || !msg.contains("\u8f6f\u4ef6\u4e2d\u6b62")) {
                logger.error((Object)("\u81ea\u5b9a\u4e49\u62a5\u8868ID\uff1a" + ids + "   \u5bfc\u51fa\u5931\u8d25\uff01"));
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException var19) {
                    logger.error((Object)var19);
                }
            }
        }
    }

    private ReportBasVirtual getReportBasAllInfo(String id) {
        ReportBasVirtual reportBasVirtual = new ReportBasVirtual();
        ReportBase reportBase = this.reportBaseService.findReportBase(Long.parseLong(id));
        org.springframework.beans.BeanUtils.copyProperties((Object)reportBase, (Object)reportBasVirtual);
        if ("1".equals(reportBasVirtual.getReportType())) {
            List<ReportBaseColumn> reportBaseColumns = this.queryColumnList(Long.parseLong(id));
            reportBasVirtual.setReportBaseColumnList(reportBaseColumns);
        }
        if ("2".equals(reportBasVirtual.getReportType())) {
            List<ReportBaseChart> reportBaseCharts = this.queryChartList(Long.parseLong(id));
            reportBasVirtual.setReportBaseChartList(reportBaseCharts);
            List<ReportBaseDs> reportBaseDs = this.queryDsList(Long.parseLong(id));
            reportBasVirtual.setReportBaseDsList(reportBaseDs);
        }
        return reportBasVirtual;
    }

    private List<ReportBaseChart> queryChartList(Long id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (id != null) {
            params.put("id", id);
        }
        return this.bSqlHelper.getList("report.reportBase.queryChartList", params, ReportBaseChart.class);
    }

    private List<ReportBaseColumn> queryColumnList(Long id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (id != null) {
            params.put("id", id);
        }
        return this.bSqlHelper.getList("report.reportBase.queryColumnList", params, ReportBaseColumn.class);
    }

    private List<ReportBaseDs> queryDsList(Long id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (id != null) {
            params.put("id", id);
        }
        return this.bSqlHelper.getList("report.reportBase.queryDsList", params, ReportBaseDs.class);
    }

    public JsonMsg importReportBas(String jsonString) {
        JsonMsg msg = new JsonMsg();
        List list = JSONObject.parseArray((String)jsonString, ReportBasVirtual.class);
        int falseNum = 0;
        ArrayList<String> namelist = new ArrayList<String>();
        for (ReportBasVirtual importReportBas : list) {
            if (org.apache.commons.lang3.StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{importReportBas.getId().toString(), importReportBas.getReportName()})) {
                ++falseNum;
                namelist.add(importReportBas.getReportName());
                continue;
            }
            try {
                ReportBase reportBase = new ReportBase();
                org.springframework.beans.BeanUtils.copyProperties((Object)importReportBas, (Object)reportBase);
                reportBase.setId(null);
                this.reportbaseDao.save(reportBase);
                if ("1".equals(reportBase.getReportType())) {
                    List<ReportBaseColumn> reportBaseColumnList = importReportBas.getReportBaseColumnList();
                    for (ReportBaseColumn r : reportBaseColumnList) {
                        r.setId(null);
                        r.setReportId(reportBase.getId());
                        this.reportBaseColumnService.saveReportBaseColumn(r);
                    }
                }
                if (!"2".equals(reportBase.getReportType())) continue;
                List<ReportBaseDs> reportBaseDsList = importReportBas.getReportBaseDsList();
                List<ReportBaseChart> reportBaseChartList = importReportBas.getReportBaseChartList();
                for (ReportBaseDs r : reportBaseDsList) {
                    Long reportId = r.getReportId();
                    r.setReportId(reportBase.getId());
                    r.setId(null);
                    this.reportBaseDsService.saveReportBaseDs(r);
                    for (ReportBaseChart c : reportBaseChartList) {
                        if (reportId.compareTo(c.getReportId()) != 0) continue;
                        c.setDsId(r.getId());
                        c.setId(null);
                        c.setReportId(reportBase.getId());
                        this.reportBaseChartService.saveReportBaseChart(c);
                    }
                }
            }
            catch (Exception var11) {
                ++falseNum;
                namelist.add(importReportBas.getReportName());
            }
        }
        if (falseNum == 0) {
            int successNum = list.size();
            msg.setMsg(successNum + "\u4e2a\u81ea\u5b9a\u4e49\u62a5\u8868\u5bfc\u5165\u6210\u529f");
        } else {
            msg.setSuccess(false);
            int successNum = list.size() - falseNum;
            String name = org.apache.commons.lang3.StringUtils.join(namelist, (String)",");
            msg.setMsg(successNum + "\u4e2a\u81ea\u5b9a\u4e49\u62a5\u8868\u5bfc\u5165\u6210\u529f\uff0c" + falseNum + "\u4e2a\u81ea\u5b9a\u4e49\u62a5\u8868\u5bfc\u5165\u5931\u8d25\uff0c" + name + "\u5bfc\u5165\u5931\u8d25");
        }
        return msg;
    }
}

