/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.pub.service;

import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.common.util.StrKit;
import com.guochuang.imp.base.common.util.SysContent;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import com.guochuang.imp.pub.dao.PubFlowRelateDao;
import com.guochuang.imp.pub.entity.PubFlowRelate;
import com.guochuang.imp.sys.util.ListUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Component
@Transactional
public class PubFlowRelateService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private PubFlowRelateDao pubflowrelateDao;

    public PubFlowRelate findPubFlowRelate(Long id) {
        PubFlowRelate entity = (PubFlowRelate)this.pubflowrelateDao.findById(id).get();
        return entity;
    }

    public List<PubFlowRelate> findByRelateBizIdAndRelateFormCode(Long relateBizId, String formCode) {
        return this.pubflowrelateDao.findByRelateBizIdAndRelateFormCodeAndIsUse(relateBizId, formCode, "Y");
    }

    public List<Map<String, Object>> findByRelateBizId(Long relateBizId, String relateFormCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("relateBizId", relateBizId);
        params.put("relateFormCode", relateFormCode);
        return this.bSqlHelper.getMapList("pub.PubFlowRelate.select", params);
    }

    public void savePubFlowRelate(PubFlowRelate entity) {
        this.pubflowrelateDao.save(entity);
    }

    public void savePubFlowRelateList(List<PubFlowRelate> entities, Long relateBizId, String relateFormCode) {
        if (entities != null) {
            for (PubFlowRelate pfr : entities) {
                if (!StrKit.notNull(relateBizId, relateFormCode, pfr.getMsgId())) continue;
                pfr.setRelateBizId(relateBizId);
                pfr.setRelateFormCode(relateFormCode);
                if (StringUtils.isEmpty((Object)pfr.getIsUse())) {
                    pfr.setIsUse("Y");
                }
                this.pubflowrelateDao.save(pfr);
            }
        }
    }

    public void delPubFlowRelate(Long id) {
        PubFlowRelate entity = (PubFlowRelate)this.pubflowrelateDao.findById(id).get();
        entity.setIsUse("N");
        this.pubflowrelateDao.save(entity);
    }

    public void delByBizId(Long relateBizId, String relateFormCode) {
        if (!StrKit.notNull(relateBizId, relateFormCode)) {
            return;
        }
        List<PubFlowRelate> entities = this.findByRelateBizIdAndRelateFormCode(relateBizId, relateFormCode);
        for (PubFlowRelate entity : entities) {
            entity.setIsUse("N");
        }
        this.pubflowrelateDao.saveAll(entities);
    }

    public PageObject pagePubFlowRelateWin(String filterflowid, String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("msgType", SysContent.MSG_ALERT);
        if (StrKit.notNull(filterflowid)) {
            params.put("filterflowid", ListUtils.stringToListWithLong(filterflowid));
        }
        if (!StringUtils.isEmpty((Object)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((Object)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((Object)order)) {
            params.put("order", order);
        }
        return this.bSqlHelper.serachPage("base.BasMessage.selectWin", params, PageRequest.of((int)page, (int)rows));
    }

    public PageObject pageCheckFlowRelateWin(String filterflowid, String conId, String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("msgType", SysContent.MSG_BASE);
        if (StrKit.notNull(filterflowid)) {
            params.put("filterflowid", ListUtils.stringToListWithLong(filterflowid));
        }
        if (!StringUtils.isEmpty((Object)conId)) {
            params.put("conId", conId);
        }
        if (!StringUtils.isEmpty((Object)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((Object)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((Object)order)) {
            params.put("order", order);
        }
        return this.bSqlHelper.serachPage("base.BasMessage.selectCheckFlowWin", params, PageRequest.of((int)page, (int)rows));
    }

    public PageObject pagConnectFlow(String formCode, String busiMainId, String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("msgType", SysContent.MSG_ALERT);
        if (!StringUtils.isEmpty((Object)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((Object)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((Object)order)) {
            params.put("order", order);
        }
        if (StrKit.notNull(formCode)) {
            params.put("formCode", formCode);
        }
        if (StrKit.notNull(busiMainId)) {
            params.put("busiMainId", busiMainId);
        }
        return this.bSqlHelper.serachPage("base.BasMessage.FindConnectFlow", params, PageRequest.of((int)page, (int)rows));
    }
}

