/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.pub.service;

import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.base.service.BasMessageService;
import com.guochuang.imp.doc.entity.FormFileBean;
import com.guochuang.imp.doc.service.DocFormFileService;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import com.guochuang.imp.pub.dao.PubContactOrgScoreDao;
import com.guochuang.imp.pub.entity.PubContactOrgScore;
import com.guochuang.imp.workflow.service.FlowUtilService;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class PubContactOrgScoreService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasMessageService msgService;
    @Autowired
    private PubContactOrgScoreDao pubcontactorgscoreDao;
    @Autowired
    private DocFormFileService docFormFileService;
    @Autowired
    private FlowUtilService flowUtilService;

    public PubContactOrgScore findPubContactOrgScore(Long id) {
        PubContactOrgScore entity = (PubContactOrgScore)this.pubcontactorgscoreDao.findById(id).get();
        return entity;
    }

    public void savePubContactOrgScore(PubContactOrgScore entity) {
        this.pubcontactorgscoreDao.save(entity);
    }

    public void savePubContactOrgScore(PubContactOrgScore entity, FormFileBean formfile) {
        this.pubcontactorgscoreDao.save(entity);
        if (formfile != null) {
            formfile.setPrimaryKey(entity.getContactOrgScoreId());
            formfile.setAccountid(entity.getModifyAccount());
            this.docFormFileService.SaveFormFileBean(formfile);
        }
    }

    public void delPubContactOrgScore(Long id) {
        PubContactOrgScore entity = (PubContactOrgScore)this.pubcontactorgscoreDao.findById(id).get();
        entity.setIsUse("N");
        entity.setModifyTime(new Date());
        this.pubcontactorgscoreDao.save(entity);
        this.msgService.delMydealByProcessinstid(entity.getProcessinstid(), id.toString());
    }

    public PageObject PageAll(Long flowDone, String search, int page, int rows, String sort, String order, String type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        if (!StringUtils.isEmpty((String)type)) {
            params.put("type", type);
        }
        if (flowDone != null) {
            params.put("flowsql", "and " + SysUtils.genFlowDoneStatusSQL("t.workflow_status", flowDone) + "\n");
        }
        return this.bSqlHelper.serachPage("pub.PubContactOrgScore.select", params, PageRequest.of((int)page, (int)rows));
    }
}

