/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.pub.controller;

import com.alibaba.fastjson.JSON;
import com.gexin.rp.sdk.base.uitls.StringUtils;
import com.guochuang.imp.base.common.util.ComBoxTreeNode;
import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.controller.BaseController;
import com.guochuang.imp.pub.entity.PubAssetsAttr;
import com.guochuang.imp.pub.entity.PubAssetsCategory;
import com.guochuang.imp.pub.service.PubAssetsCategoryService;
import com.guochuang.imp.util.StringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/PubAssetsCategory"})
public class PubAssetsCategoryController
extends BaseController {
    @Autowired
    private PubAssetsCategoryService pubAssetsCategoryService;

    @RequestMapping(value={"/pagePubAssetsCategory"})
    @ResponseBody
    public Object pagePubAssetsCategory(@RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows) {
        return this.pubAssetsCategoryService.PageAll(search, page, rows);
    }

    @RequestMapping(value={"/findPubAssetsCategory"})
    @ResponseBody
    public Object findPubAssetsCategory(Long id) {
        return this.pubAssetsCategoryService.findPubAssetsCategory(id);
    }

    @RequestMapping(value={"/savePubAssetsCategory"})
    @ResponseBody
    public Object savePubAssetsCategory(PubAssetsCategory entity, HttpServletRequest request) {
        JsonMsg msg = new JsonMsg();
        String attrs = request.getParameter("attrsStr");
        if (StringUtils.isNotBlank((CharSequence)attrs)) {
            entity.setAttrs(JSON.parseArray((String)attrs, PubAssetsAttr.class));
        }
        entity.setModifyAccount(this.getLoginUser(request).getAccountid());
        entity.setModifyTime(new Date());
        entity.setIsUse("Y");
        this.pubAssetsCategoryService.savePubAssetsCategory(entity);
        msg.setO(entity);
        return msg;
    }

    @RequestMapping(value={"/delPubAssetsCategory"})
    @ResponseBody
    public Object delPubAssetsCategory(Long id) {
        this.pubAssetsCategoryService.delPubAssetsCategory(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/treePubAssetsCategoryWithRoot"})
    @ResponseBody
    public Object treePubAssetsCategoryWithRoot(@RequestParam(value="pid", defaultValue="0") Long pid, String detailId, String bizType, String isCard) {
        List<ComBoxTreeNode> treelist = this.pubAssetsCategoryService.treePubAssetsCategory(pid, bizType, isCard);
        ComBoxTreeNode root = new ComBoxTreeNode();
        if (StringUtils.isNotBlank((CharSequence)detailId) && !"null".equals(detailId)) {
            String name = this.pubAssetsCategoryService.getCategoryTextById(Long.parseLong(detailId));
            root.setId(detailId.toString());
            root.setText(name);
            root.setChecked(true);
            treelist.add(root);
            return treelist;
        }
        root.setId("0");
        root.setText("\u6839\u8282\u70b9");
        root.setChecked(false);
        root.setChildren(treelist);
        ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
        list.add(root);
        return list;
    }

    @RequestMapping(value={"/treePubAssetsCategory"})
    @ResponseBody
    public Object treePubAssetsCategory(@RequestParam(value="pid", defaultValue="0") Long pid, Long detailId, String bizType, String isCard) {
        ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
        ComBoxTreeNode root = new ComBoxTreeNode();
        if (detailId != null) {
            PubAssetsCategory category = this.pubAssetsCategoryService.findPubAssetsCategory(detailId);
            root.setId(detailId.toString());
            root.setText(category.getCategoryName());
            root.setChecked(true);
            list.add(root);
        }
        return this.pubAssetsCategoryService.treePubAssetsCategory(pid, bizType, isCard);
    }

    @RequestMapping(value={"/delPubAssetsCategoryAndChild"})
    @ResponseBody
    public Object delPubAssetsCategoryAndChild(Long id) {
        this.pubAssetsCategoryService.delPubAssetsCategoryAndChild(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/treePubAssetsCategoryMul"})
    @ResponseBody
    public Object treePubAssetsCategoryMul(@RequestParam(value="pid", defaultValue="0") Long pid, String detailId, String bizType, String isCard) {
        ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
        ComBoxTreeNode root = new ComBoxTreeNode();
        if (StringUtil.isNotEmpty(detailId)) {
            String categoryName = this.pubAssetsCategoryService.findPubAssetsCategoryByIds(detailId);
            root.setId(detailId.toString());
            root.setText(categoryName);
            root.setChecked(true);
            list.add(root);
            return list;
        }
        return this.pubAssetsCategoryService.treePubAssetsCategory(pid, bizType, isCard);
    }
}

