/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.gen.util;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;

public class FreeMarkerUtil {
    private static final Logger logger = Logger.getLogger(FreeMarkerUtil.class);
    private static FreeMarkerUtil instance;
    private Configuration config;

    public static FreeMarkerUtil instance() {
        if (instance == null) {
            instance = new FreeMarkerUtil();
        }
        return instance;
    }

    private void configInstance() {
        if (this.config == null) {
            this.config = new Configuration(Configuration.VERSION_2_3_23);
            this.config.setDefaultEncoding("UTF-8");
            try {
                this.config.setClassForTemplateLoading(this.getClass(), "/");
            }
            catch (Exception e) {
                logger.error((Object)"freeMarker\u8bbe\u7f6e\u6a21\u677f\u76ee\u5f55\u5931\u8d25 \uff01", (Throwable)e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String genString(String templateStr, Map propMap) {
        if (StringUtils.isEmpty((Object)templateStr)) {
            return templateStr;
        }
        Configuration localCfg = new Configuration(Configuration.VERSION_2_3_23);
        localCfg.setDefaultEncoding("UTF-8");
        localCfg.setNumberFormat("#");
        StringTemplateLoader stringLoader = new StringTemplateLoader();
        stringLoader.putTemplate("myTemplate", templateStr);
        localCfg.setTemplateLoader((TemplateLoader)stringLoader);
        try {
            Template template = localCfg.getTemplate("myTemplate", "utf-8");
            try (StringWriter writer = new StringWriter();){
                template.process((Object)propMap, (Writer)writer);
                String string = writer.toString();
                return string;
            }
            catch (TemplateException e) {
                logger.error((Object)"freeMarker\u751f\u6210\u5b57\u7b26\u4e32\u5931\u8d25 \uff01", (Throwable)e);
                return null;
            }
        }
        catch (IOException e) {
            logger.error((Object)"freeMarker\u751f\u6210\u5b57\u7b26\u4e32\u5931\u8d25 \uff01", (Throwable)e);
        }
        return null;
    }

    public String geneFileStr(String templateFileName, Map propMap) {
        this.configInstance();
        StringWriter out = new StringWriter();
        try {
            Template tmp = this.config.getTemplate(templateFileName);
            tmp.setEncoding("UTF-8");
            tmp.process((Object)propMap, (Writer)out);
        }
        catch (IOException e) {
            logger.error((Object)"I/O \u9519\u8bef!", (Throwable)e);
        }
        catch (TemplateException e) {
            logger.error((Object)"\u6a21\u677f\u9519\u8bef!", (Throwable)e);
        }
        return out.getBuffer().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean geneHtmlFile(String templateFileName, Map propMap, String htmlFilePath, String htmlFileName) {
        this.configInstance();
        FileOutputStream fileout = null;
        try {
            Template tmp = this.config.getTemplate(templateFileName);
            tmp.setEncoding("UTF-8");
            File afile = new File(htmlFilePath + "/" + htmlFileName);
            if (!afile.exists()) {
                afile.getParentFile().mkdirs();
                afile.createNewFile();
            }
            fileout = new FileOutputStream(afile);
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)fileout, "UTF-8"));
            tmp.process((Object)propMap, (Writer)out);
            ((Writer)out).flush();
            ((Writer)out).close();
        }
        catch (TemplateException e) {
            logger.error((Object)"\u6a21\u677f\u9519\u8bef!", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            logger.error((Object)"I/O \u9519\u8bef!", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileout != null) {
                try {
                    fileout.close();
                }
                catch (IOException e) {
                    logger.error((Object)"I/O \u9519\u8bef!", (Throwable)e);
                }
            }
        }
        return true;
    }

    public void generFile(HttpServletRequest request, HttpServletResponse response, String templateFileName, String wordFileName, Map propMap) {
        this.configInstance();
        ServletOutputStream outStream = null;
        OutputStreamWriter outWriter = null;
        try {
            response.setHeader("Content-Disposition", "attachment;filename=".concat(new String(wordFileName.getBytes("gbk"), "iso-8859-1")));
            response.setHeader("Connection", "close");
            response.setContentType("text/html; charset=GBK");
            if (propMap != null & "xls".equals(propMap.get("fileType"))) {
                response.setContentType("application/vnd.ms-excel");
            } else {
                response.setContentType("application/msword");
            }
            outStream = response.getOutputStream();
            outWriter = new OutputStreamWriter((OutputStream)outStream, "UTF-8");
            Template tmp = this.config.getTemplate(templateFileName);
            tmp.setEncoding("UTF-8");
            tmp.process((Object)propMap, (Writer)outWriter);
            outWriter.flush();
        }
        catch (IOException e) {
            logger.error((Object)"I/O \u9519\u8bef!", (Throwable)e);
        }
        catch (TemplateException e) {
            logger.error((Object)"\u6a21\u677f\u9519\u8bef!", (Throwable)e);
        }
    }

    public boolean creatDirs(String aParentDir, String aSubDir) {
        File aFile = new File(aParentDir);
        if (aFile.exists()) {
            File aSubFile = new File(aParentDir + aSubDir);
            if (!aSubFile.exists()) {
                return aSubFile.mkdirs();
            }
            return true;
        }
        return false;
    }

    public void geneWordFile(Map<String, Object> dataMap, OutputStream outStream, String templateFileName) {
        try {
            this.configInstance();
            Template t = this.config.getTemplate(templateFileName);
            OutputStreamWriter outWriter = new OutputStreamWriter(outStream, "UTF-8");
            t.process(dataMap, (Writer)outWriter);
            outWriter.flush();
            outWriter.close();
        }
        catch (TemplateException e) {
            logger.error((Object)"\u6a21\u677f\u9519\u8bef!", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"I/O \u9519\u8bef!", (Throwable)e);
        }
    }

    public static void main(String[] args) {
        FreeMarkerUtil.instance();
    }
}

