/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.gen.service;

import cn.hutool.core.map.MapUtil;
import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.DateUtils;
import com.guochuang.imp.base.common.util.NativeSqlHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.common.util.StrKit;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.base.service.CommonService;
import com.guochuang.imp.gen.entity.DBColumn;
import com.guochuang.imp.gen.entity.DBTable;
import com.guochuang.imp.gen.entity.GenForm;
import com.guochuang.imp.gen.service.GenFormService;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import com.guochuang.imp.gen.util.FreeMarkerUtil;
import com.guochuang.imp.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class GeneratorService {
    @Value(value="${tableSchema}")
    private String tableSchema;
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private GenFormService genformService;

    public DBTable buildTable(String tablename) {
        ArrayList<DBColumn> list = new ArrayList<DBColumn>();
        String sql = " SELECT  \n  t.TABLE_NAME,\n t.COLUMN_NAME,\n t.DATA_TYPE,\n t.CHARACTER_MAXIMUM_LENGTH DATA_LENGTH,\n t.NUMERIC_PRECISION DATA_PRECISION,\n t.NUMERIC_SCALE DATA_SCALE,\n t.is_NULLABLE NULLABLE,\n t.COLUMN_COMMENT comments\n FROM INFORMATION_SCHEMA.`COLUMNS` t \n where  t.TABLE_SCHEMA=schema()\nand t.TABLE_NAME=?1 order by t.ORDINAL_POSITION";
        List collist = this.sqlHelper.queryByNativeSQL(sql, new Object[]{tablename.toUpperCase()}, new int[0]);
        String pk = this.getPK(tablename.toUpperCase());
        for (Object object : collist) {
            Map row = (Map)object;
            DBColumn col = new DBColumn();
            col.setFieldDbName(row.get("COLUMN_NAME").toString());
            col.setDataLength(Objects.toString(row.get("DATA_LENGTH"), "20"));
            col.setPrecision(row.get("DATA_PRECISION") == null ? "" : row.get("DATA_PRECISION").toString());
            col.setScale(row.get("DATA_SCALE") == null ? "" : row.get("DATA_SCALE").toString());
            col.setFieldName(DBPropertyUtil.columnToProperty2(row.get("COLUMN_NAME").toString().toLowerCase()));
            col.setFieldType(DBPropertyUtil.sqlType2JavaType(row.get("DATA_TYPE").toString(), StringUtil.str2Int(col.getPrecision()), StringUtil.str2Int(col.getScale())));
            col.setNullable("YES".equals(row.get("NULLABLE").toString()) ? "Y" : "N");
            col.setFieldTitle(row.get("COMMENTS") == null ? col.getFieldName() : row.get("COMMENTS").toString());
            if (pk.equals(col.getFieldDbName()) || "PROCESSINSTID".equals(col.getFieldDbName()) || "IS_USE".equals(col.getFieldDbName()) || "MODIFY_ACCOUNT".equals(col.getFieldDbName()) || "MODIFY_TIME".equals(col.getFieldDbName())) {
                col.setGridColHidden(1);
            }
            if ("WORKFLOW_STATUS".equals(col.getFieldDbName())) {
                col.setFieldDic("WORKFLOW_STATUS");
            }
            list.add(col);
        }
        DBTable table = new DBTable();
        table.setTablename(tablename.toUpperCase());
        table.setEntityName(DBPropertyUtil.tblToEntity(tablename.toLowerCase()));
        table.setColumns(list);
        table.setDescription("\u4ee3\u7801\u751f\u6210\u5de5\u5177\u81ea\u52a8\u751f\u6210");
        table.setDate(DateUtils.dateToStr(new Date()));
        table.setPk(pk);
        table.setPkHump(DBPropertyUtil.columnToProperty2(pk.toLowerCase()));
        return table;
    }

    public String getFormKey(String formCode) {
        GenForm form = this.genformService.findGenFormByCode(formCode);
        return DBPropertyUtil.columnToProperty2(this.getPK(form.getBusiTable()).toLowerCase());
    }

    public Map<String, Object> getProcessinstidByFormCode(HttpServletRequest request, String formCode) {
        GenForm form = this.genformService.findGenFormByCode(formCode);
        String pkfield = DBPropertyUtil.columnToProperty2(this.getPK(form.getBusiTable()).toLowerCase());
        String pk = request.getParameter(pkfield);
        String sql = "select processinstid from " + form.getBusiTable() + " where " + this.getPK(form.getBusiTable().toUpperCase()) + "=" + pk;
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("id", pk);
        map.put("processinstid", this.sqlHelper.getSingal(sql));
        return map;
    }

    public String getPK(String tablename) {
        return this.bSqlHelper.getStringValue("gen.db.getPk", MapUtil.of((Object)"tableName", (Object)tablename));
    }

    public List allTable() {
        String sql = " SELECT underlineToCamel(t.TABLE_NAME) hump_name, t.TABLE_NAME  ,t.TABLE_COMMENT COMMENTS FROM INFORMATION_SCHEMA.`TABLES` t \n where t.TABLE_SCHEMA<>'mysql'\nand   t.TABLE_SCHEMA=SCHEMA()\norder by t.TABLE_NAME";
        List list = this.sqlHelper.queryByNativeSQL(sql, new int[0]);
        return list;
    }

    public List allTableAndView(String tableName) {
        String sql = " SELECT underlineToCamel(t.TABLE_NAME) hump_name, t.TABLE_NAME  ,t.TABLE_COMMENT COMMENTS,t.table_type FROM INFORMATION_SCHEMA.`TABLES` t where t.TABLE_SCHEMA = SCHEMA()\n";
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)tableName)) {
            params.put("search", "%" + tableName.toUpperCase() + "%");
            sql = sql + " and upper(t.TABLE_NAME) like :search or upper(t.TABLE_COMMENT) like :search";
        }
        sql = sql + " order by t.table_type,t.TABLE_NAME";
        List list = this.sqlHelper.queryByNativeSQL(sql, params, new int[0]);
        return list;
    }

    public DBTable bulidwithColumnInfo(DBTable table, List rows) {
        ArrayList<DBColumn> gridCols = new ArrayList<DBColumn>();
        ArrayList<DBColumn> queryConditions = new ArrayList<DBColumn>();
        ArrayList<DBColumn> fuzzyQueryConditions = new ArrayList<DBColumn>();
        for (DBColumn column : table.columns) {
            for (Object o : rows) {
                Map row = (Map)o;
                if (column.getFieldDbName().equals(row.get("fieldDbName").toString())) {
                    if (StrKit.notNull(row.get("fieldTitle"))) {
                        column.setFieldTitle(row.get("fieldTitle").toString());
                    }
                    if (StrKit.notNull(row.get("fieldDic")) && StrKit.notBlank(row.get("fieldDic").toString())) {
                        column.setFieldDic(row.get("fieldDic").toString());
                    }
                }
                if (column.getFieldDbName().equals(row.get("fieldDbName").toString()) && "1".equals(row.get("gridColHidden"))) {
                    column.setGridColHidden(1);
                }
                if (column.getFieldDbName().equals(row.get("fieldDbName").toString()) && "1".equals(row.get("isGridCol"))) {
                    gridCols.add(column);
                }
                if (!column.getFieldDbName().equals(row.get("fieldDbName").toString()) || StringUtil.isEmpty(row.get("queryCondition"))) continue;
                DBColumn queryCol = new DBColumn();
                BeanUtils.copyProperties((Object)column, (Object)queryCol);
                queryCol.setQueryCondition(row.get("queryCondition").toString());
                if ("0".equals(queryCol.getQueryCondition())) {
                    fuzzyQueryConditions.add(queryCol);
                    continue;
                }
                queryConditions.add(queryCol);
            }
        }
        gridCols.sort(new Comparator<DBColumn>(){

            @Override
            public int compare(DBColumn o1, DBColumn o2) {
                return o2.getGridColHidden() - o1.getGridColHidden();
            }
        });
        table.setGridCols(gridCols);
        table.setQueryConditions(queryConditions);
        table.setFuzzyQueryConditions(fuzzyQueryConditions);
        return table;
    }

    public void buildPage(DBTable table, String type, String gensrc, String genobjs) {
        String templateName;
        String templateName2;
        String srcpath = gensrc + "\\src\\main\\";
        String javapath = srcpath + "java\\";
        String webpath = srcpath + "webapp\\";
        String sqlpath = srcpath + "resources\\beetlsql\\";
        List<String> objs = Arrays.asList(genobjs.split(","));
        HashMap<String, DBTable> propMap = new HashMap<String, DBTable>();
        propMap.put("table", table);
        if (objs.contains("entity")) {
            FreeMarkerUtil.instance().geneHtmlFile("/com/guochuang/imp/gen/ftl/entityTemplate.ftl", propMap, javapath + table.getBaspackEntity().replace(".", "\\"), table.getEntityName() + ".java");
        }
        if (objs.contains("dao")) {
            FreeMarkerUtil.instance().geneHtmlFile("/com/guochuang/imp/gen/ftl/daoTemplate.ftl", propMap, javapath + table.getBaspackDao().replace(".", "\\"), table.getEntityName() + "Dao.java");
        }
        if (objs.contains("beetsql")) {
            templateName2 = "";
            templateName2 = "editFrom".equals(type) ? "beetlSqlEdit" : ("process".equals(type) ? "beetlSqlWithProcess" : "beetlSql");
            FreeMarkerUtil.instance().geneHtmlFile("/com/guochuang/imp/gen/ftl/" + table.getTemplatePath() + "/" + templateName2 + ".ftl", propMap, sqlpath + table.getBizpack().replace("com.guochuang.imp.", "").replace(".", "\\"), table.getEntityName() + ".md");
        }
        if (objs.contains("controller")) {
            templateName2 = "";
            templateName2 = "editFrom".equals(type) ? "controllerTemplateEditFrom" : ("process".equals(type) ? "controllerTemplateWithProcess" : "controllerTemplate");
            FreeMarkerUtil.instance().geneHtmlFile("/com/guochuang/imp/gen/ftl/" + table.getTemplatePath() + "/" + templateName2 + ".ftl", propMap, javapath + table.getBaspackController().replace(".", "\\"), table.getEntityName() + "Controller.java");
        }
        if (objs.contains("service")) {
            templateName2 = "";
            templateName2 = "editFrom".equals(type) ? "servicelTemplateEditFrom" : ("process".equals(type) ? "servicelTemplateWithProcess" : "servicelTemplate");
            FreeMarkerUtil.instance().geneHtmlFile("/com/guochuang/imp/gen/ftl/" + table.getTemplatePath() + "/" + templateName2 + ".ftl", propMap, javapath + table.getBaspackService().replace(".", "\\"), table.getEntityName() + "Service.java");
        }
        String pageName = table.getEntityName();
        pageName = pageName.substring(0, 1).toLowerCase() + pageName.substring(1);
        if (objs.contains("jsp")) {
            templateName = "";
            templateName = "editFrom".equals(type) ? "jspTemplateEditFrom" : ("process".equals(type) ? "jspTemplateWithProcess" : "jspTemplate");
            FreeMarkerUtil.instance().geneHtmlFile("/com/guochuang/imp/gen/ftl/" + table.getTemplatePath() + "/" + templateName + ".ftl", propMap, webpath + "\\WEB-INF\\view\\" + table.getViewpath().replace("/", "\\"), pageName + ".html");
        }
        if (objs.contains("js")) {
            templateName = "";
            templateName = "editFrom".equals(type) ? "" : ("process".equals(type) ? "jsTemplateWithProcess" : "jsTemplate");
            if (!StringUtil.isEmpty(templateName)) {
                FreeMarkerUtil.instance().geneHtmlFile("/com/guochuang/imp/gen/ftl/" + table.getTemplatePath() + "/" + templateName + ".ftl", propMap, webpath + "\\WEB-INF\\js\\" + table.getViewpath().replace("/", "\\"), pageName + ".js");
            }
            if (!"editFrom".equals(type) && !table.getTemplatePath().contains("tree")) {
                FreeMarkerUtil.instance().geneHtmlFile("/com/guochuang/imp/gen/ftl/" + table.getTemplatePath() + "/extraJsTemplate.ftl", propMap, webpath + "\\WEB-INF\\js\\" + table.getViewpath().replace("/", "\\"), pageName + "Extra.js");
            }
        }
    }

    public PageObject findHibernateSequences(Integer page, Integer rows, String search) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        sql.append("select t.sequence_name,20*t.sequence_next_hi_value as sequence_next_hi_value from hibernate_sequences t where   lower(t.sequence_name) !='doc_file_version' ");
        if (StringUtils.isNotBlank((String)search)) {
            sql.append(" and lower(t.sequence_name) like :search ");
            params.put("search", "%" + search.toLowerCase() + "%");
        }
        sql.append("order by  t.sequence_name asc");
        int start = (page - 1) * rows;
        PageObject pageobject = new PageObject();
        String sqlCount = "select count(1)  from (" + sql + ") a";
        int count = Integer.parseInt(this.sqlHelper.getSingal(sqlCount, params).toString());
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), params, start, rows);
        this.appengMaxIdColumn(list);
        int totalPage = count % rows == 0 ? count / rows : count / rows + 1;
        pageobject.setTotal(count);
        pageobject.setPageNumber(totalPage);
        pageobject.setCurrpage(page);
        pageobject.setRows(list);
        return pageobject;
    }

    public Integer updateAllHibernateSequences() {
        StringBuilder sql = new StringBuilder();
        sql.append("select t.sequence_name,20*t.sequence_next_hi_value as sequence_next_hi_value from hibernate_sequences t where   lower(t.sequence_name) !='doc_file_version' ");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]);
        this.appengMaxIdColumn(list);
        int i = 0;
        for (Object o : list) {
            Map row = (Map)o;
            if (!"true".equals(Objects.toString(row.get("FLAG")))) continue;
            this.updateHibernateSequences(row.get("SEQUENCE_NAME").toString(), Integer.parseInt(row.get("MAX_ID").toString()));
            ++i;
        }
        return i;
    }

    public void appengMaxIdColumn(List list) {
        for (Object o : list) {
            Map row = (Map)o;
            String tableName = row.get("SEQUENCE_NAME").toString();
            Integer value = Integer.parseInt(row.get("SEQUENCE_NEXT_HI_VALUE").toString());
            String pk = this.commonService.getPK(tableName);
            if (!StringUtils.isEmpty((String)pk)) {
                StringBuilder sql = new StringBuilder();
                sql.append("select max(" + pk + ") from " + tableName + " t ");
                int maxId = 0;
                if (this.sqlHelper.getSingal(sql.toString()) != null) {
                    try {
                        maxId = Integer.parseInt(this.sqlHelper.getSingal(sql.toString()).toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                row.put("MAX_ID", maxId);
                if (maxId > value) {
                    row.put("FLAG", true);
                    continue;
                }
                row.put("FLAG", false);
                continue;
            }
            row.put("MAX_ID", 0);
            row.put("FLAG", false);
        }
    }

    public PageObject exesql(String sql, int page, int rows, String sort, String order) {
        if (StrKit.notBlank(sort)) {
            sql = "select t.* from (" + sql.toString() + ") t " + SysUtils.genOrderBy("t." + sort, order);
        }
        return this.sqlHelper.pagerNativeSQL(sql.toString(), page, rows);
    }

    public void updateHibernateSequences(String tableName, int maxId) {
        if (StringUtils.isBlank((String)tableName)) {
            this.updateAllHibernateSequences();
            return;
        }
        Integer value = maxId / 20 + 1;
        StringBuilder sql = new StringBuilder();
        sql.append("update hibernate_sequences t set t.sequence_next_hi_value =?1 where t.sequence_name=?2 ");
        this.sqlHelper.exeNativeSQL(sql.toString(), new Object[]{value, tableName});
    }
}

