/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.gen.service;

import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.NativeSqlHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.service.CommonService;
import com.guochuang.imp.gen.dao.GenFormDao;
import com.guochuang.imp.gen.dao.GenFormPanelDao;
import com.guochuang.imp.gen.entity.GenForm;
import com.guochuang.imp.gen.entity.GenFormPanel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class GenFormPanelService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private GenFormPanelDao genformpanelDao;
    @Autowired
    private GenFormDao genformDao;
    @Autowired
    private BeetlSQLHelper bSqlHelper;

    public GenFormPanel findGenFormPanel(String id) {
        Optional opt = this.genformpanelDao.findById(id);
        if (opt.isPresent()) {
            return (GenFormPanel)opt.get();
        }
        return null;
    }

    @CacheEvict(cacheNames={"FormCache"}, allEntries=true)
    public void saveGenFormPanel(GenFormPanel entity) {
        this.genformpanelDao.save(entity);
    }

    @CacheEvict(cacheNames={"FormCache"}, allEntries=true)
    public void delGenFormPanel(String id) {
        this.genformpanelDao.deleteById(id);
    }

    public GenForm findGenFormByPanelId(String panelId) {
        GenFormPanel panel = this.findGenFormPanel(panelId);
        return (GenForm)this.genformDao.findById(panel.getFormId()).get();
    }

    public PageObject PageAll(String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        String sql = "select * from GEN_FORM_PANEL t  order by t.PANEL_ID";
        if (!StringUtils.isEmpty((String)search)) {
            sql = "select * from GEN_FORM_PANEL t where   upper(t.DISPLAY_NO) like ?1  or upper(t.PANEL_ID) like ?1  or upper(t.FORM_ID) like ?1  or upper(t.PANEL_TITLE) like ?1  or upper(t.PANEL_TYPE) like ?1  or upper(t.PANEL_URL) like ?1  or upper(t.FORM_COLNUM) like ?1  order by t.PANEL_ID";
            pageobject = this.sqlHelper.pagerNativeSQL(sql, new Object[]{"%" + search.toUpperCase() + "%"}, page, rows);
        } else {
            pageobject = this.sqlHelper.pagerNativeSQL(sql, page, rows);
        }
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("PANEL_TYPE", "PANEL_TYPE");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public PageObject PageAllByFormID(String formid, int page, int rows) {
        PageObject pageobject = new PageObject();
        String sql = "select * from GEN_FORM_PANEL t where t.FORM_ID=?1 and t.IS_USE='Y' order by t.DISPLAY_NO";
        pageobject = this.sqlHelper.pagerNativeSQL(sql, new Object[]{formid}, page, rows);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("PANEL_TYPE", "PANEL_TYPE");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public List<GenFormPanel> findByFormID(String formid) {
        return this.genformpanelDao.findByFormIdAndIsUseOrderByDisplayNo(formid, "Y");
    }

    public List<Map<String, Object>> findGenFormPanelByFormIdAndPanelTypeAndIsUse(String formId) {
        String sql = "select\nt.*\nfrom GEN_FORM_PANEL t\nwhere t.is_use = 'Y'and t.PANEL_TYPE='0'\n@if(!isEmpty(formId)){\n    and t.FORM_ID= #formId#\n@}";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("formId", formId);
        return this.bSqlHelper.serachBySql(sql, params);
    }

    public List<Map<String, Object>> getPanelCombox(String formId) {
        String sql = "select\nt.*\nfrom GEN_FORM_PANEL t\nwhere t.is_use = 'Y'and t.PANEL_TYPE<>'0'\n@if(!isEmpty(formId)){\n    and t.FORM_ID= #formId#\n@}";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("formId", formId);
        return this.bSqlHelper.serachBySql(sql, params);
    }
}

