/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.doc.service;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.unit.DataSizeUtil;
import com.guochuang.imp.base.common.exception.InvoiceDuplicatedException;
import com.guochuang.imp.base.common.support.FileType;
import com.guochuang.imp.base.common.support.LockByKey;
import com.guochuang.imp.base.common.support.SimultaneousEntriesLockByKey;
import com.guochuang.imp.base.common.support.SysConfigEnum;
import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.ComBoxTreeNode;
import com.guochuang.imp.base.common.util.CommTreeUtils;
import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.common.util.MemCache;
import com.guochuang.imp.base.common.util.NativeSqlHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.common.util.StrKit;
import com.guochuang.imp.base.common.util.SysContent;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.base.service.CommonService;
import com.guochuang.imp.doc.common.ocr.AipOcrCilentUtils;
import com.guochuang.imp.doc.dao.DocFileVersionDao;
import com.guochuang.imp.doc.dao.DocFormFileDao;
import com.guochuang.imp.doc.entity.DocFileVersion;
import com.guochuang.imp.doc.entity.DocFormFile;
import com.guochuang.imp.doc.entity.FormFileBean;
import com.guochuang.imp.gen.entity.GenForm;
import com.guochuang.imp.gen.entity.GenFormApplys;
import com.guochuang.imp.gen.service.GenFormApplysService;
import com.guochuang.imp.gen.service.GenFormService;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import com.guochuang.imp.sys.util.ListUtils;
import com.guochuang.imp.util.StringUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.persistence.Table;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class DocFormFileService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private DocFormFileDao docformfileDao;
    @Autowired
    private DocFileVersionDao docfileversionDao;
    @Autowired
    private GenFormService genFormService;
    @Autowired
    private AipOcrCilentUtils aipOcrCilentUtils;
    @Autowired
    private GenFormApplysService genformapplysService;
    private final int maxThreadEachKey = 1;
    private final LockByKey<String> lockByKey = new SimultaneousEntriesLockByKey<String>(1);
    private static Logger loger = LoggerFactory.getLogger(DocFormFileService.class);

    public DocFormFile findDocFormFile(Long id) {
        DocFormFile entity = (DocFormFile)this.docformfileDao.findById(id).get();
        return entity;
    }

    public void saveDocFormFile(DocFormFile entity) {
        this.docformfileDao.save(entity);
    }

    public void delDocFormFile(Long id) {
        this.docformfileDao.deleteById(id);
    }

    public void delDocFormFile(String ids) {
        ListUtils.stringToListWithLong(ids).forEach(id -> {
            DocFormFile entity = (DocFormFile)this.docformfileDao.findById(id).get();
            entity.setIsUse("N");
            this.docformfileDao.save(entity);
        });
    }

    public PageObject PageAll(String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        String sql = "select * from DOC_FORM_FILE t  order by t.FORM_FILE_ID";
        if (!StringUtils.isEmpty((CharSequence)search)) {
            sql = "select * from DOC_FORM_FILE t where   upper(t.FORM_FILE_ID) like ?1  or upper(t.FORM_ID) like ?1  or upper(t.FILE_TYPE_ID) like ?1  or upper(t.FILE_VERSION_ID) like ?1  or upper(t.PRIMARY_KEY) like ?1  or upper(t.DISPLAY_NO) like ?1  or upper(t.IS_USE) like ?1  or upper(t.PROJECT_ID) like ?1  or upper(t.FILE_NO) like ?1  or upper(t.FILE_NAME) like ?1  or upper(t.MEMO) like ?1  order by t.FORM_FILE_ID";
            pageobject = this.sqlHelper.pagerNativeSQL(sql, new Object[]{"%" + search.toUpperCase() + "%"}, page, rows);
        } else {
            pageobject = this.sqlHelper.pagerNativeSQL(sql, page, rows);
        }
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public PageObject PageAllDocFormFile(Long archivesTypeId, String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select t.archive_file_id,b.file_name,e.account_name as ARCHIVES_ACCOUNT_TEXT_, \t\t(select listagg(x.position_name,'/') within GROUP (order by level desc) from B_ARCHIVES_POSITION x \n\t\t         start with x.POSITION_ID = a.archives_room \n\t\t        CONNECT BY PRIOR x.POSITION_PID = x.POSITION_ID  ) as ARCHIVES_ROOM_TEXT_, \n\t\t(select listagg(x.archives_type_name,'/') within GROUP (order by level desc) from B_ARCHIVES_TYPE x \n\t\t         start with x.archives_type_id = a.archives_type \n\t\t        CONNECT BY PRIOR x.archives_type_pid = x.archives_type_id  ) as ARCHIVES_TYPE_TEXT_, \n a.*\n            from b_archive_file t\n            left join doc_file_version a\n              on t.file_version_id = a.version_id\n              left join doc_form_file b\n              on t.form_file_id=b.form_file_id \n");
        sql.append(" LEFT JOIN BAS_EMP_ACCOUNT e on e.account_id=a.ARCHIVES_ACCOUNT \n");
        sql.append("    WHERE t.is_use = :isUse and a.IS_ARCHIVES = :isArchives and a.ARCHIVES_TYPE is not null \n");
        params.put("isUse", Character.valueOf('Y'));
        params.put("isArchives", SysContent.PASS_STATUS);
        if (archivesTypeId != null && archivesTypeId != 0L) {
            sql.append(" and a.ARCHIVES_TYPE in (select ARCHIVES_TYPE_ID from B_ARCHIVES_TYPE start with ARCHIVES_TYPE_ID=:archivesTypeId\tconnect  by ARCHIVES_TYPE_PID= prior ARCHIVES_TYPE_ID) ");
            params.put("archivesTypeId", archivesTypeId);
        }
        if (!StringUtils.isEmpty((CharSequence)search)) {
            sql.append(" and  (");
            sql.append(" upper(a.ARCHIVES_ROOM) like :search ");
            sql.append(" or upper(a.BOX_NO) like :search ");
            sql.append(" or upper(a.ARCHIVES_TYPE) like :search ");
            sql.append(" or upper(a.SAVETERM) like :search ");
            sql.append(" or upper(a.ARCHIVES_NO) like :search ");
            sql.append(" or upper(a.IS_ARCHIVES) like :search ");
            sql.append(" or upper(a.ARCHIVES_ACCOUNT) like :search ");
            sql.append(" or upper(a.ARCHIVES_TIME) like :search ");
            sql.append(" or upper(a.ARCHIVES_TYPE_NAME) like :search ");
            sql.append(")");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by a.ARCHIVES_TIME DESC");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("IS_PAPER", "IS_PAPER");
        dicmapper.put("SAVETERM", "SAVE_TERM");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public PageObject PageAllDocFormFileEdit(Long accountId, Long archivesTypeId, String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select a.file_name,\nreplace(n.theme_name,'\u7684\u5f52\u6863\u7533\u8bf7','') as theme_name,\n       e.account_name as ARCHIVES_ACCOUNT_TEXT_,\n       (select listagg\n\n               (x.position_name, '/') within GROUP(order by level desc)\n          from B_ARCHIVES_POSITION x\n         start with x.POSITION_ID = t.archives_room\n        CONNECT BY PRIOR x.POSITION_PID = x.POSITION_ID) as ARCHIVES_ROOM_TEXT_,\n       (select listagg(x.archives_type_name, '/') within GROUP(order by level desc)\n          from B_ARCHIVES_TYPE x\n         start with x.archives_type_id=t.archives_type\n        CONNECT BY PRIOR x.archives_type_pid = x.archives_type_id) as ARCHIVES_TYPE_TEXT_,t.*\n  from doc_file_version t\n  left join doc_file a\n    on a.file_id = t.file_id\n LEFT JOIN b_archive_file m on t.version_id=m.file_version_id and m.is_use='Y' \n   LEFT JOIN B_ARCHIVE N on m.archive_id=n.archive_id and n.is_use='Y' \n   LEFT JOIN BAS_EMP_ACCOUNT e\n    on e.account_id = t.ARCHIVES_ACCOUNT");
        sql.append("    WHERE a.is_use = :isUse and t.IS_ARCHIVES = :isArchives and t.ARCHIVES_TYPE is not null \n");
        params.put("isUse", Character.valueOf('Y'));
        params.put("isArchives", SysContent.PASS_STATUS);
        sql.append(" and t.ARCHIVES_TYPE in\n       (select tp.ARCHIVES_TYPE_ID\n          from B_ARCHIVES_TYPE tp\n          left join B_ARCHIVES_TYPE_ACCOUNT a\n            on tp.archives_type_id = a.archives_type_id\n         where a.account_id = :accountId\n");
        params.put("accountId", accountId);
        if (archivesTypeId != null && archivesTypeId != 0L) {
            sql.append("         start with tp.ARCHIVES_TYPE_ID = :archivesTypeId\n        connect by tp.ARCHIVES_TYPE_PID = prior tp.ARCHIVES_TYPE_ID \n");
            params.put("archivesTypeId", archivesTypeId);
        }
        sql.append(") \n");
        if (!StringUtils.isEmpty((CharSequence)search)) {
            sql.append(" and  (");
            sql.append(" upper(t.ARCHIVES_ROOM) like :search ");
            sql.append(" or upper(t.BOX_NO) like :search ");
            sql.append(" or upper(t.ARCHIVES_TYPE) like :search ");
            sql.append(" or upper(t.SAVETERM) like :search ");
            sql.append(" or upper(t.ARCHIVES_NO) like :search ");
            sql.append(" or upper(n.theme_name) like :search ");
            sql.append(" or upper(t.IS_ARCHIVES) like :search ");
            sql.append(" or upper(t.ARCHIVES_ACCOUNT) like :search ");
            sql.append(" or upper(t.ARCHIVES_TIME) like :search ");
            sql.append(" or upper(t.ARCHIVES_TYPE_NAME) like :search ");
            sql.append(")");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by t.ARCHIVES_TIME DESC");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("IS_PAPER", "IS_PAPER");
        dicmapper.put("SAVETERM", "SAVE_TERM");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SaveFormFileBean(FormFileBean bean) {
        Long index = 1L;
        ArrayList<String> billNos = new ArrayList<String>();
        if (bean.getPanelfilelist() != null && !bean.getPanelfilelist().isEmpty()) {
            this.lockByKey.lock(bean.getPanelfilelist().get(0).getFormId() + "##" + bean.getPrimaryKey());
            loger.info("saveFormFileBean  lockByKey.lock(" + bean.getPanelfilelist().get(0).getFormId() + "##" + bean.getPrimaryKey() + ")");
        }
        try {
            Long l;
            Long l2;
            List<Map<String, Object>> dupList;
            ArrayList<String> bills = new ArrayList<String>(bean.getPanelfilelist().size() + 1);
            for (DocFormFile formfile : bean.getPanelfilelist()) {
                if (!StringUtils.isNotBlank((CharSequence)formfile.getBillType()) || !StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{formfile.getBillNo()}) || "N".equals(formfile.getIsUse())) continue;
                bills.add(formfile.getBillNo() + "-" + (formfile.getBillCode() == null ? "" : formfile.getBillCode()));
            }
            if (!bills.isEmpty() && (dupList = this.getRepatMsg(bills, bean.getPanelfilelist().get(0).getFormId() + "-" + bean.getPrimaryKey())) != null && !dupList.isEmpty()) {
                String msg = "";
                for (Map<String, Object> map : dupList) {
                    if (StringUtils.isNotBlank((CharSequence)msg)) {
                        msg = msg + "|||";
                    }
                    msg = msg + StringUtil.null2String(map.get("msg"));
                }
                throw new InvoiceDuplicatedException(msg);
            }
            for (DocFormFile formfile : bean.getPanelfilelist()) {
                if (formfile == null || StrKit.isBlank(formfile.getFileNo()) && StrKit.isBlank(formfile.getFileName()) && formfile.getFileVersionId() == null) continue;
                formfile.setPrimaryKey(String.valueOf(bean.getPrimaryKey()));
                if (StringUtils.isNotBlank((CharSequence)formfile.getBillType()) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{formfile.getBillNo()})) {
                    boolean repeatNo = false;
                    repeatNo = !StringUtils.isEmpty((CharSequence)formfile.getBillCode()) ? billNos.contains(formfile.getBillNo() + "-" + formfile.getBillCode()) : billNos.contains(formfile.getBillNo());
                    if (repeatNo) {
                        throw new InvoiceDuplicatedException("\u53d1\u7968[" + formfile.getBillNo() + ", " + formfile.getBillCode() + "]\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u4e0a\u4f20");
                    }
                    if ("N".equals(formfile.getIsUse())) {
                        formfile.setIsUse("Y");
                        formfile.setFormId("");
                        formfile.setPrimaryKey(null);
                    }
                }
                if (formfile.getFormFileId() != null && formfile.getBillNo() != null && formfile.getCheckCode() != null && formfile.getBillMoney() != null && formfile.getBillDate() != null && ("1".equals(formfile.getBillType()) || "2".equals(formfile.getBillType()))) {
                    DocFormFile oldformfile = this.findDocFormFile(formfile.getFormFileId());
                    if (!formfile.getBillCode().equals(oldformfile.getBillCode()) || !formfile.getBillNo().equals(oldformfile.getBillNo()) || StringUtils.compare((String)formfile.getCheckCode(), (String)oldformfile.getCheckCode()) != 0 || oldformfile.getBillMoney() == null || formfile.getBillMoney().compareTo(oldformfile.getBillMoney()) != 0 || ((BigDecimal)ObjectUtils.defaultIfNull((Object)formfile.getBillTaxMoney(), (Object)new BigDecimal(0))).compareTo((BigDecimal)ObjectUtils.defaultIfNull((Object)oldformfile.getBillTaxMoney(), (Object)new BigDecimal(0))) != 0 || oldformfile.getBillDate() == null || formfile.getBillDate().compareTo(oldformfile.getBillDate()) != 0) {
                        formfile.setVerifyResult("");
                    } else {
                        formfile.setVerifyResult(oldformfile.getVerifyResult());
                    }
                }
                if (formfile.getBillDate() != null) {
                    DocFormFile oldformfile = null;
                    if (formfile.getFormFileId() != null) {
                        oldformfile = this.findDocFormFile(formfile.getFormFileId());
                    }
                    if ((oldformfile == null || StringUtils.isBlank((CharSequence)oldformfile.getVerifyResult())) && DateUtil.betweenYear((Date)formfile.getBillDate(), (Date)new Date(), (boolean)false) >= 5L) {
                        formfile.setVerifyResult("overtime");
                    }
                }
                formfile.setProjectId(bean.getProjectId());
                formfile.setDisplayNo(index);
                formfile.setModifyAccount(bean.getAccountid());
                formfile.setModifyTime(new Date());
                if (formfile.getFormFileId() == null && bean.getWorkitemid() != null && formfile.getWorkitemid() == null) {
                    formfile.setWorkitemid(bean.getWorkitemid());
                }
                this.docformfileDao.save(formfile);
                l2 = index;
                l = index = Long.valueOf(index + 1L);
                if (!StringUtils.isEmpty((CharSequence)formfile.getBillCode())) {
                    billNos.add(formfile.getBillNo() + "-" + formfile.getBillCode());
                    continue;
                }
                billNos.add(formfile.getBillNo());
            }
            index = 1L;
            if (bean.getApplys() != null) {
                for (GenFormApplys apply : bean.getApplys()) {
                    apply.setMainId(bean.getPrimaryKey());
                    apply.setDisplayNo(index);
                    this.genformapplysService.saveGenFormApplys(apply);
                    l2 = index;
                    l = index = Long.valueOf(index + 1L);
                }
            }
        }
        finally {
            if (bean.getPanelfilelist() != null && !bean.getPanelfilelist().isEmpty()) {
                this.lockByKey.unlock(bean.getPanelfilelist().get(0).getFormId() + "##" + bean.getPrimaryKey());
                loger.info("saveFormFileBean  lockByKey.unlock(" + bean.getPanelfilelist().get(0).getFormId() + "##" + bean.getPrimaryKey() + ")");
            }
        }
    }

    public List<DocFormFile> listFormFileByPK(String formid, String fileTypeId, List<String> PKS, Boolean isArchive) {
        List<DocFormFile> list = this.docformfileDao.findByFormIdAndFileTypeIdAndPrimaryKeyInAndIsUseOrderByDisplayNo(formid, fileTypeId, PKS, "Y");
        ArrayList<DocFormFile> returnlist = new ArrayList<DocFormFile>();
        Map<String, String> dicmap = this.commonService.getDicMap("INVOICE_TYPEA_ALL");
        Map<String, String> dicmap1 = this.commonService.getDicMap("BILL_CATEGORY");
        Map<String, String> dicmap2 = this.commonService.getDicMap("PROJECT_BILL_CATEGORY");
        dicmap1.putAll(dicmap2);
        List<String> types = Arrays.asList("about", "add", "del", "del1", "add1", "password", "xls", "file", "yonghutouxiang", "gerenxinxi", "7z", "flv", "ppt", "txt", "jpg", "set", "gif", "doc", "bmp", "avi", "mov", "mp4", "pdf", "pr", "psd", "rar", "mp3", "tif", "cdr", "svg", "zip", "Addprofile");
        for (DocFormFile file : list) {
            if (StringUtils.isNotBlank((CharSequence)file.getBillType())) {
                file.setBillTypeName(dicmap.get(file.getBillType()));
            }
            if (StringUtils.isNotBlank((CharSequence)file.getBillCategory())) {
                file.setBillCategoryName(dicmap1.get(file.getBillCategory()));
            }
            if (file.getFileVersionId() == null) continue;
            DocFileVersion version = (DocFileVersion)this.docfileversionDao.findById(file.getFileVersionId()).get();
            if (version != null) {
                if (version.getFileSize() != null && version.getFileSize().longValue() > 0L) {
                    file.setFileSize(DataSizeUtil.format((long)version.getFileSize().longValue()));
                    String fileType = FilenameUtils.getExtension((String)version.getOriginalName());
                    if ("xlsx".equalsIgnoreCase(fileType) || "docx".equalsIgnoreCase(fileType) || "pptx".equalsIgnoreCase(fileType)) {
                        fileType = fileType.substring(0, fileType.length() - 1);
                    }
                    file.setFileType(types.indexOf(fileType) != -1 ? fileType : "file");
                }
                file.setOriginalName(version == null ? "" : version.getOriginalName());
                file.setIsArchives(version.getIsArchives());
                if (isArchive == null) {
                    returnlist.add(file);
                } else if (isArchive.booleanValue() && SysContent.PASS_STATUS.toString().equals(version.getIsArchives())) {
                    returnlist.add(file);
                } else if (!isArchive.booleanValue() && ("0".equals(version.getIsArchives()) || "31".equals(version.getIsArchives()))) {
                    returnlist.add(file);
                }
                if (!"Y".equals(MemCache.getConfigValue(SysConfigEnum.FILE_VIEW_ZIP_CLOSE.getCode())) || !FileType.COMPRESS.equals((Object)FileType.typeFromFileName(version.getOriginalName()))) continue;
                file.setPrevewClose("Y");
                continue;
            }
            returnlist.add(file);
        }
        return returnlist;
    }

    public boolean checkInvoiceRepeat(String billNo, String billCode, Long id) {
        HashMap<String, Object> params = new HashMap<String, Object>(6);
        params.put("billNo", billNo);
        if (!StringUtils.isEmpty((CharSequence)billCode)) {
            params.put("billNo", billNo + billCode);
        }
        params.put("id", id);
        return this.bSqlHelper.getIntValue("doc.DocFormFile.findFileByInviceInfo", params) > 0;
    }

    public List<Map<String, Object>> getRepatMsg(List<String> bills, String formIdMainId) {
        HashMap<String, Object> params = new HashMap<String, Object>(6);
        params.put("formIdMainId", formIdMainId);
        params.put("bills", bills);
        return this.bSqlHelper.getMapList("doc.DocFormFile.getRepatMsg", params);
    }

    public List<DocFormFile> listFormFileByPK(String formid, String fileTypeId, String PK) {
        return this.listFormFileByPK(formid, fileTypeId, Arrays.asList(PK), null);
    }

    public List<DocFormFile> getProjectFileList(String fileTypeId, Long projectId) {
        List<DocFormFile> list = this.docformfileDao.findByFileTypeIdAndProjectIdAndIsUseOrderByDisplayNo(fileTypeId, (long)projectId, "Y");
        ArrayList<DocFormFile> returnlist = new ArrayList<DocFormFile>();
        Map<String, String> dicmap = this.commonService.getDicMap("INVOICE_TYPEA_ALL");
        Map<String, String> dicmap1 = this.commonService.getDicMap("BILL_CATEGORY");
        Map<String, String> dicmap2 = this.commonService.getDicMap("PROJECT_BILL_CATEGORY");
        dicmap1.putAll(dicmap2);
        for (DocFormFile file : list) {
            if (StringUtils.isNotBlank((CharSequence)file.getBillType())) {
                file.setBillTypeName(dicmap.get(file.getBillType()));
            }
            if (StringUtils.isNotBlank((CharSequence)file.getBillCategory())) {
                file.setBillCategoryName(dicmap1.get(file.getBillCategory()));
            }
            if (file.getFileVersionId() == null) continue;
            DocFileVersion version = (DocFileVersion)this.docfileversionDao.findById(file.getFileVersionId()).get();
            if (version != null) {
                file.setOriginalName(version == null ? "" : version.getOriginalName());
                file.setIsArchives(version.getIsArchives());
                returnlist.add(file);
                continue;
            }
            returnlist.add(file);
        }
        return returnlist;
    }

    public List<DocFormFile> listFormFileByPK(String formid, String fileTypeId, List<String> PKS) {
        return this.listFormFileByPK(formid, fileTypeId, PKS, null);
    }

    public List<DocFormFile> findByFormCodeAndPrimaryKey(String formcode, String primaryKey) {
        GenForm form = this.genFormService.findGenFormByCode(formcode);
        if (form != null) {
            return this.docformfileDao.findByFormIdAndPrimaryKeyAndIsUseOrderByDisplayNo(form.getId(), primaryKey, "Y");
        }
        return null;
    }

    public List<DocFormFile> findByFileVersionIdAndIsUse(Long fileVersionId, String isUse) {
        return this.docformfileDao.findByFileVersionIdAndIsUse(fileVersionId, isUse);
    }

    public List findArchiveByFormFileIds(String formfileids) {
        StringBuffer sb = new StringBuffer();
        sb.append("select T.*,b.FILE_TYPE_NAME \n  from doc_form_file t\n  LEFT JOIN DOC_FILE_VERSION A ON T.FILE_VERSION_ID=A.VERSION_ID\n                LEFT JOIN DOC_FILE_TYPE B ON T.FILE_TYPE_ID=B.FILE_TYPE_ID where  t.is_use = ?1 \n   and t.form_file_id in (?2) \n   AND (A.IS_ARCHIVES in ('0','31') ) ORDER BY T.DISPLAY_NO");
        List list = this.sqlHelper.queryByNativeSQL(sb.toString(), new Object[]{"Y", ListUtils.stringToListWithLong(formfileids)}, new int[0]);
        return list;
    }

    public List findArchiveByFormFileIds1(String formfileids) {
        StringBuffer sql = new StringBuffer();
        HashMap<String, Object> params = new HashMap<String, Object>();
        formfileids = "(" + formfileids + ")";
        params.put("formfileids", formfileids);
        sql.append("select T.*,b.FILE_TYPE_NAME\n       from doc_form_file t\n       LEFT JOIN DOC_FILE_VERSION a ON t.FILE_VERSION_ID=a.VERSION_ID\n       LEFT JOIN DOC_FILE_TYPE b ON t.FILE_TYPE_ID=b.FILE_TYPE_ID\n       where  t.is_use ='Y'\n       and (A.IS_ARCHIVES in ('0','31') )\n       @if(!isEmpty(formfileids)){\n        and t.form_file_id in #text(formfileids)#\n       @}\n       ORDER BY T.DISPLAY_NO");
        List<Map<String, Object>> formFileList = this.bSqlHelper.serachBySql(sql.toString(), params);
        return formFileList;
    }

    public PageObject pageAllArchiveByFormCodeAndPrimaryKey(Long flag, String formcode, Long primaryKey, String search, int page, int rows, String sort, String order) {
        GenForm form = this.genFormService.findGenFormByCode(formcode);
        PageObject pageobject = new PageObject();
        if (form != null) {
            StringBuffer sb = new StringBuffer();
            HashMap<String, Object> params = new HashMap<String, Object>();
            sb.append("select T.FORM_FILE_ID,B.FILE_TYPE_NAME,T.FILE_NAME,E.ACCOUNT_NAME as ARCHIVES_ACCOUNT_TEXT_,A.*\n                from doc_form_file t\n                LEFT JOIN DOC_FILE_VERSION A ON T.FILE_VERSION_ID=A.VERSION_ID\n                LEFT JOIN DOC_FILE_TYPE B ON T.FILE_TYPE_ID=B.FILE_TYPE_ID \t\t\t\t\tLEFT JOIN BAS_EMP_ACCOUNT e on e.account_id=a.ARCHIVES_ACCOUNT \n where 1=1 ");
            if (formcode.equals("BPmProjectDoc_form")) {
                sb.append("and t.form_id in (1360,1361,1362,1363,1364,1365,1366,1367,1368)\n   and t.project_id = :pk \n");
                params.put("pk", primaryKey);
            } else {
                sb.append("and t.form_id =:formid\n   and t.primary_key = :pk \n");
                params.put("formid", form.getId());
                params.put("pk", primaryKey);
            }
            sb.append("   and t.is_use = :isuse \n");
            if (flag != null) {
                if (flag == 1L) {
                    sb.append("   AND a.IS_ARCHIVES=:workflowStatus ");
                    params.put("workflowStatus", SysContent.PASS_STATUS.toString());
                } else if (flag == 0L) {
                    sb.append("   AND (A.IS_ARCHIVES in('0','31')) ");
                }
            }
            if (!StringUtils.isEmpty((CharSequence)search)) {
                sb.append("and  (");
                sb.append(" upper(t.FILE_NAME) like :search ");
                sb.append(" upper(a.ARCHIVES_ROOM) like :search ");
                sb.append(" or upper(a.BOX_NO) like :search ");
                sb.append(" or upper(a.ARCHIVES_TYPE) like :search ");
                sb.append(" or upper(a.SAVETERM) like :search ");
                sb.append(" or upper(a.ARCHIVES_NO) like :search ");
                sb.append(" or upper(a.IS_ARCHIVES) like :search ");
                sb.append(" or upper(a.ARCHIVES_ACCOUNT) like :search ");
                sb.append(" or upper(a.ARCHIVES_TIME) like :search ");
                sb.append(" or upper(a.ARCHIVES_TYPE_NAME) like :search ");
                sb.append(") ");
                params.put("search", "%" + search.toUpperCase() + "%");
            }
            sb.append("    ORDER BY A.IS_ARCHIVES ");
            params.put("isuse", "Y");
            if (StrKit.notBlank(sort)) {
                String exesql = "select * from (" + sb.toString() + ") " + SysUtils.genOrderBy(sort, order);
                pageobject = this.sqlHelper.pagerNativeSQL(exesql, params, (Integer)page, (Integer)rows);
            } else {
                pageobject = this.sqlHelper.pagerNativeSQL(sb.toString(), params, (Integer)page, (Integer)rows);
            }
            HashMap<String, String> dicmapper = new HashMap<String, String>();
            dicmapper.put("IS_PAPER", "IS_PAPER");
            dicmapper.put("ARCHIVES_ROOM", "ARCHIVES_ROOM");
            dicmapper.put("SAVETERM", "SAVE_TERM");
            dicmapper.put("IS_ARCHIVES", "ARCHIVE_STATUS");
            this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        }
        return pageobject;
    }

    public DocFormFile findByFormIdAndPrimaryKeyAndFileVersionId(String formcode, String primaryKey, Long fileVersionId) {
        GenForm form = this.genFormService.findGenFormByCode(formcode);
        if (form != null) {
            List<DocFormFile> list = this.docformfileDao.findByFormIdAndPrimaryKeyAndFileVersionIdAndIsUseOrderByDisplayNo(form.getId(), primaryKey, fileVersionId, "Y");
            if (!list.isEmpty()) {
                return list.get(0);
            }
            return null;
        }
        return null;
    }

    public List<Object> findFormFileByFileVersionId(Long versionid) {
        String sql = "select t.*, a.form_code, a.form_name, b.file_type_name, c.account_name\n  from doc_form_file t\n  left join gen_form a\n    on t.form_id = a.id\n  left join doc_file_type b\n    on t.form_file_id = b.file_type_id\n  left join bas_emp_account c\n    on t.modify_account = c.account_id\n where t.file_version_id = ?1\n   and t.is_use = ?2 order by t.modify_time desc";
        return this.sqlHelper.queryByNativeSQL(sql, new Object[]{versionid, "Y"}, new int[0]);
    }

    public Boolean checkFileByFileTypeId(FormFileBean formfile, Long fileTypeId) {
        Boolean haveFile = false;
        if (fileTypeId == null || formfile == null) {
            return haveFile;
        }
        for (DocFormFile formFile : formfile.getPanelfilelist()) {
            if (!fileTypeId.equals(formFile.getFileTypeId()) || !"Y".equals(formFile.getIsUse())) continue;
            haveFile = true;
            break;
        }
        return haveFile;
    }

    public List<Map<String, Object>> getFileInfo(Long bizMainId, String formCode) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        sql.append("select a.*,v.is_archives\n  from doc_form_file a\n  left join DOC_FILE_VERSION v\n    on a.file_version_id = v.version_id\n  left join gen_form g\n    on g.id = a.form_id\n where a.primary_key = :bizMainId\n   and g.form_code = :formCode\n   and a.is_use = :isUse \n");
        params.put("bizMainId", bizMainId);
        params.put("formCode", formCode);
        params.put("isUse", "Y");
        List map = this.sqlHelper.queryByNativeSQL(sql.toString(), params, new int[0]);
        return map;
    }

    public List<Map<String, Object>> getFileInfoForPmPmcon(Long bizMainId, String formCode, String search, String status) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("bizMainId", bizMainId);
        params.put("formCode", formCode);
        if (StringUtils.isNotBlank((CharSequence)search)) {
            params.put("search", "%" + search + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)status)) {
            params.put("status", status);
        }
        sql.append(" select  a.file_name archive_file_name,\n a.form_file_id,\n a.file_version_id,\n f.workflow_status,\n(case\n when f.WORKFLOW_STATUS is null then 1\n when f.WORKFLOW_STATUS=3 then 3\n else 2\n end) file_status,\n GETDICNAME('FILE_STATUS', (case\n when f.WORKFLOW_STATUS is null then 1\n when f.WORKFLOW_STATUS=3 then 3\n else 2\n end)) file_status_text\n from doc_form_file a\n left join DOC_FILE_VERSION v\n on a.FILE_VERSION_ID = v.VERSION_ID\n left join gen_form g\n on g.id = a.form_id\n left join ARCHIVES_ARCHIVE_FILE f\n on v.VERSION_ID=f.VERSION_ID\n where a.is_use ='Y'\n @if(!isEmpty(bizMainId)){\n     and a.primary_key=#bizMainId#\n @}\n @if(!isEmpty(formCode)){\n     and g.form_code=#formCode#\n @}\n @if(!isEmpty(search)){\n     and a.file_name like #search#\n @}\n @if(!isEmpty(status)){\n@if(status=='1'){\n     and f.WORKFLOW_STATUS =3\n@}\n@if(status=='0'){\n     and (f.WORKFLOW_STATUS <>3 or f.workflow_status is null)\n@}\n@}");
        List<Map<String, Object>> map = this.bSqlHelper.serachBySql(sql.toString(), params);
        return map;
    }

    public void delFormFileByPK(String formCode, String pk) {
        List<DocFormFile> list = this.findByFormCodeAndPrimaryKey(formCode, pk);
        if (list != null && !list.isEmpty()) {
            for (DocFormFile file : list) {
                file.setIsUse("N");
            }
            this.docformfileDao.saveAll(list);
        }
    }

    public PageObject PageAll(String fileNature, String reimbursed, String search, String startDate, String endDate, String applyPerson, String invoceType, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((CharSequence)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((CharSequence)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((CharSequence)order)) {
            params.put("order", order);
        }
        if (!StringUtils.isEmpty((CharSequence)startDate)) {
            params.put("startDate", startDate);
        }
        if (!StringUtils.isEmpty((CharSequence)endDate)) {
            params.put("endDate", endDate);
        }
        if (!StringUtils.isEmpty((CharSequence)applyPerson)) {
            params.put("applyPerson", "%" + applyPerson.toUpperCase().replace("%", "/%") + "%");
        }
        if (!StringUtils.isEmpty((CharSequence)invoceType)) {
            params.put("invoceType", invoceType);
        }
        if (!StringUtils.isEmpty((CharSequence)fileNature)) {
            params.put("fileNature", fileNature);
        }
        if (!StringUtils.isEmpty((CharSequence)reimbursed)) {
            params.put("reimbursed", reimbursed);
        }
        return this.bSqlHelper.serachPage("doc.DocFormFile.select", params, PageRequest.of((int)page, (int)rows));
    }

    public List<DocFormFile> findByFormCodeAndPrimaryKeyAndBillType(String formcode, String primaryKey) {
        GenForm form = this.genFormService.findGenFormByCode(formcode);
        if (form != null) {
            return this.docformfileDao.findByFormIdAndPrimaryKeyAndIsUseAndBillTypeInOrderByDisplayNo(form.getId(), primaryKey, "Y", Arrays.asList("1", "2"));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonMsg checkBillInfo(String formCode, String primaryKey, String ... strs) {
        List<DocFormFile> files = this.findByFormCodeAndPrimaryKeyAndBillType(formCode, primaryKey);
        if (files == null || files.isEmpty()) {
            return new JsonMsg();
        }
        if (files != null && !files.isEmpty()) {
            this.lockByKey.lock(files.get(0).getFormId() + "##" + primaryKey);
            loger.info("checkBillInfo  lockByKey.lock(" + files.get(0).getFormId() + "##" + primaryKey + ")");
        }
        JsonMsg jsonmsg = new JsonMsg(true, "");
        try {
            HashMap<String, Object> params;
            this.aipOcrCilentUtils.getClient();
            ArrayList<String> bills = new ArrayList<String>(files.size() + 1);
            String validateMgs = "";
            for (DocFormFile formfile : files) {
                JsonMsg msg;
                if ("on".equals(this.aipOcrCilentUtils.getVERIFICATION_SWITCH()) && formfile.getFormFileId() != null && formfile.getBillDate() != null) {
                    if (!"pass".equals(formfile.getVerifyResult()) && DateUtil.betweenYear((Date)formfile.getBillDate(), (Date)new Date(), (boolean)false) >= 5L) {
                        formfile.setVerifyResult("overtime");
                        continue;
                    }
                    if (!"pass".equals(formfile.getVerifyResult()) && formfile.getBillDate().compareTo(new Date()) > 0) {
                        if (validateMgs.length() > 0) {
                            validateMgs = validateMgs + "\n";
                        }
                        validateMgs = validateMgs + formfile.getBillCode() + "-" + formfile.getBillNo() + "\u5f00\u7968\u65e5\u671f\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5";
                        continue;
                    }
                    if (!"pass".equals(formfile.getVerifyResult()) && DateUtils.isSameDay((Date)formfile.getBillDate(), (Date)new Date())) {
                        if (validateMgs.length() > 0) {
                            validateMgs = validateMgs + "\n";
                        }
                        validateMgs = validateMgs + formfile.getBillCode() + "-" + formfile.getBillNo() + "\u4e3a\u5f53\u5929\u7684\u53d1\u7968\u4e0d\u80fd\u6821\u9a8c\uff0c\u8bf7\u660e\u5929\u91cd\u8bd5\u4e0b";
                        continue;
                    }
                    if ("pass".equals(formfile.getVerifyResult())) continue;
                    if ("fail".equals(formfile.getVerifyResult())) {
                        if (validateMgs.length() > 0) {
                            validateMgs = validateMgs + "\n";
                        }
                        validateMgs = validateMgs + formfile.getBillCode() + "-" + formfile.getBillNo() + "\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u6838\u5bf9\u6570\u636e";
                        continue;
                    }
                    if ("on".equals(this.aipOcrCilentUtils.getVERIFICATION_SWITCH())) {
                        params = new HashMap(4);
                        params.put("billCode", "%" + formfile.getBillCode() + "%");
                        params.put("billNo", "%" + formfile.getBillNo() + "%");
                        int count = this.bSqlHelper.getIntValue("base.BasInterfaceLog.getInvoiceCallCount", params);
                        if (count >= 5) {
                            if (validateMgs.length() > 0) {
                                validateMgs = validateMgs + "\n";
                            }
                            validateMgs = validateMgs + formfile.getBillCode() + "-" + formfile.getBillNo() + "\u4eca\u5929\u6838\u9a8c\u6b21\u6570\u8d85\u8fc75\u6b21\uff0c\u8bf7\u660e\u5929\u518d\u8bd5";
                            continue;
                        }
                    }
                }
                bills.add(formfile.getBillNo() + "-" + formfile.getBillCode());
                try {
                    msg = "on".equals(this.aipOcrCilentUtils.getVERIFICATION_SWITCH()) ? this.aipOcrCilentUtils.verification(formfile) : new JsonMsg();
                }
                catch (JSONException e) {
                    msg = new JsonMsg();
                    msg.setSuccess(false);
                    msg.setMsg("\u9a8c\u771f\u63a5\u53e3\u8c03\u7528\u5931\u8d25" + e.getMessage());
                }
                if (!msg.isSuccess()) {
                    if (validateMgs.length() > 0) {
                        validateMgs = validateMgs + "\n";
                    }
                    validateMgs = validateMgs + formfile.getBillCode() + "-" + formfile.getBillNo() + "\u6821\u9a8c\u5931\u8d25,\u539f\u56e0\uff1a" + msg.getMsg();
                    if (this.aipOcrCilentUtils.getVERIFICATION_SWITCH() == null || !"on".equals(this.aipOcrCilentUtils.getVERIFICATION_SWITCH())) continue;
                    if ("1005".equals(msg.getCode()) || "1009".equals(msg.getCode()) || "1006".equals(msg.getCode()) || "0009".equals(msg.getCode()) || "0006".equals(msg.getCode()) || "0005".equals(msg.getCode())) {
                        formfile.setVerifyResult("fail");
                        continue;
                    }
                    if (!"9999".equals(msg.getCode()) && !"1004".equals(msg.getCode()) && !"1020".equals(msg.getCode()) && !"1021".equals(msg.getCode())) continue;
                    validateMgs = validateMgs + ",\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406";
                    continue;
                }
                if (this.aipOcrCilentUtils.getVERIFICATION_SWITCH() == null || !"on".equals(this.aipOcrCilentUtils.getVERIFICATION_SWITCH())) continue;
                formfile.setVerifyResult("pass");
            }
            this.docformfileDao.saveAll(files);
            if (validateMgs.length() > 1) {
                jsonmsg.setMsg("\u53d1\u7968\u6821\u9a8c\u5931\u8d25:\n" + validateMgs);
                jsonmsg.setSuccess(false);
            }
            if (!bills.isEmpty()) {
                GenForm form = this.genFormService.findGenFormByCode(formCode);
                String checksql = "select concat('\u53d1\u7968' , t.bill_code ,'-' ,t.bill_no , '\u5df2\u88ab' ,\n       getaccountname(v.create_account) , '\u4e8e' ,\n       date_format(v.create_time, '%Y-%m-%d %T') , '\u7528\u4e8e' ,f.form_name) msg\n  from DOC_FORM_FILE t\n  left join doc_file_version v on v.version_id=t.file_version_id\n  left join gen_form f\n    on f.id = t.form_id\n where concat(t.bill_no,'-',t.bill_code) in (#join(bills)#)\n   AND T.IS_USE = 'Y' and concat(t.form_Id,'-',t.Primary_Key)<>#formIdMainId# ";
                params = new HashMap<String, Object>();
                params.put("formIdMainId", form.getId() + "-" + primaryKey);
                params.put("bills", bills);
                List<Map<String, Object>> dupList = this.bSqlHelper.serachBySql(checksql, params);
                if (!dupList.isEmpty()) {
                    jsonmsg.setSuccess(false);
                    for (Map<String, Object> map : dupList) {
                        jsonmsg.setMsg(jsonmsg.getMsg() + "\n" + map.get("msg"));
                    }
                }
            }
        }
        finally {
            if (files != null && !files.isEmpty()) {
                this.lockByKey.unlock(files.get(0).getFormId() + "##" + primaryKey);
                loger.info("checkBillInfo  lockByKey.unlock(" + files.get(0).getFormId() + "##" + primaryKey + ")");
            }
        }
        return jsonmsg;
    }

    public List<ComBoxTreeNode> treeFileTypeForFile(String formId, String id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("formId", formId);
        params.put("id", id);
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("doc.DocFormFile.treeFileTypeForFile", params);
        List<String> types = Arrays.asList("about", "add", "del", "del1", "add1", "password", "xls", "xlsx", "file", "yonghutouxiang", "gerenxinxi", "7z", "flv", "ppt", "pptx", "txt", "jpg", "set", "gif", "doc", "docx", "bmp", "avi", "mov", "mp4", "pdf", "pr", "psd", "rar", "mp3", "tif", "cdr", "svg", "zip", "Addprofile");
        list.forEach(map -> {
            if (map.get("fileSize") != null) {
                map.put("fileSize", DataSizeUtil.format((long)Long.parseLong(map.get("fileSize").toString())));
            }
            map.put("iconCls", types.indexOf(FilenameUtils.getExtension((String)Objects.toString(map.get("text")))) != -1 ? FilenameUtils.getExtension((String)Objects.toString(map.get("text"))) : "file");
        });
        return CommTreeUtils.buildTreeNode(list);
    }

    public void delFormFileByPrimaryKey(Long pkId, Class clazz) {
        String tableName;
        Table tableInfo;
        if (pkId != null && clazz != null && (tableInfo = clazz.getAnnotation(Table.class)) != null && (tableName = tableInfo.name()) != null && !"".equals(tableName.trim())) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("pkId", pkId.toString());
            params.put("tableName", tableName);
            String sql = "UPDATE doc_form_file t \nSET t.IS_USE = 'N' \nWHERE\n   t.IS_USE = 'Y' \n   AND t.PRIMARY_KEY = #pkId# \n   AND t.FORM_ID IN ( SELECT f.ID FROM gen_form f WHERE f.IS_USE = 'Y' AND UPPER( f.BUSI_TABLE ) = #tableName# )";
            this.bSqlHelper.updateBysql(sql, params);
        }
    }
}

