/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.doc.service;

import com.guochuang.imp.base.common.util.NativeSqlHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.common.util.StrKit;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.base.service.CommonService;
import com.guochuang.imp.doc.common.FileService;
import com.guochuang.imp.doc.common.util.FileStoreException;
import com.guochuang.imp.doc.dao.DocFileDao;
import com.guochuang.imp.doc.entity.DocFile;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class DocFileService {
    public static Logger loger = Logger.getLogger(DocFileService.class);
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private FileService fileService;
    @Autowired
    private DocFileDao docfileDao;

    public DocFile findDocFile(Long id) {
        DocFile entity = (DocFile)this.docfileDao.findById(id).get();
        return entity;
    }

    public Object findDocFileObject(Long id) {
        String sql = "select t.file_id,t.base_version_id,t.catalog_id,t.create_account,t.create_time,\nt.file_name,a.account_name as create_account_name,b.version_no as base_version_no,\nc.catalog_name\n from DOC_FILE t left join bas_emp_account a on t.create_account=a.account_id\nleft join doc_file_version b on t.base_version_id=b.version_id\nleft join doc_catalog c on t.catalog_id=c.catalog_id\nwhere t.file_id=?1";
        Object o = this.sqlHelper.getSingalMap(sql, new Object[]{id});
        return o;
    }

    public void saveDocFile(DocFile entity) {
        this.docfileDao.save(entity);
    }

    public void delDocFile(Long id) {
        this.docfileDao.deleteById(id);
    }

    public DocFile findByProjectIdAndStandardFileId(Long projectId, Long standardFileId) {
        List<DocFile> list = this.docfileDao.findByProjectIdAndStandardFileIdAndIsUse(projectId, standardFileId, "Y");
        if (list.size() > 1) {
            loger.error((Object)("\u7cfb\u7edf\u63d0\u793a:\u6839\u636eprojectId=" + projectId + "\u548cstandardFileId" + standardFileId + "\u627e\u5230\u591a\u4e2adocfile,\u8bf7\u68c0\u67e5\u6570\u636e"));
            return list.get(0);
        }
        if (list.size() > 0) {
            return list.get(0);
        }
        loger.error((Object)("\u7cfb\u7edf\u63d0\u793a:\u6839\u636eprojectId=" + projectId + "\u548cstandardFileId" + standardFileId + "\u627e\u5230\u591a\u4e2adocfile,\u8bf7\u68c0\u67e5\u6570\u636e"));
        return null;
    }

    public PageObject PageAll(String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        String sql = "select * from DOC_FILE t  order by t.FILE_ID";
        if (!StringUtils.isEmpty((String)search)) {
            sql = "select * from DOC_FILE t where   upper(t.FILE_ID) like ?1  or upper(t.FILE_CODE) like ?1  or upper(t.FILE_NAME) like ?1  or upper(t.CATALOG_ID) like ?1  or upper(t.STANDARD_FILE_ID) like ?1  or upper(t.PROJECT_ID) like ?1  or upper(t.FILE_TYPE) like ?1  or upper(t.CREATE_ACCOUNT) like ?1  or upper(t.CREATE_TIME) like ?1  or upper(t.BASE_VERSION_ID) like ?1  or upper(t.IS_USE) like ?1  order by t.FILE_ID";
            pageobject = this.sqlHelper.pagerNativeSQL(sql, new Object[]{"%" + search.toUpperCase() + "%"}, page, rows);
        } else {
            pageobject = this.sqlHelper.pagerNativeSQL(sql, page, rows);
        }
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("FILE_TYPE", "FILE_TYPE");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public PageObject pageChoosefile(Long catalogid, String search, String filtersql, int page, int rows, String sort, String order) throws FileStoreException {
        PageObject pageobject = new PageObject();
        StringBuffer sql = new StringBuffer();
        HashMap<String, Object> params = new HashMap<String, Object>();
        sql.append("select f.form_name,\n               e.file_type_name,\n               t.file_no,\n               t.file_name,\n               c.project_name,\n               t.memo,\n               a.version_id,\n               a.original_name,\n               b.account_name,\n               DATE_FORMAT(a.create_time,'%Y-%m-%d %H:%i:%s') as create_time\n          from doc_form_file t\n          left join doc_file_version a on t.file_version_id = a.version_id\n          left join BAS_EMP_ACCOUNT b on a.create_account = b.account_id\n          left join doc_file_type e on t.file_type_id = e.file_type_id\n          left join gen_form f on t.form_id = f.id\n          left join B_PM_PROJECT C on t.project_id = c.project_id  where t.file_type_id in ( select m.file_type_id from doc_file_type m   where  t.IS_USE='Y' and a.uuid is not null ");
        if (catalogid != 0L) {
            sql.append(" and m.catalog_id in         (SELECT t.CATALOG_ID FROM DOC_CATALOG T           WHERE T. IS_USE = 'Y' and t.CATALOG_TYPE = 1           START WITH T.CATALOG_ID = :catalog_id         CONNECT BY PRIOR T.CATALOG_ID = T.PCATALOG_ID) ");
            params.put("catalog_id", catalogid);
        }
        sql.append(")");
        if (StrKit.notBlank(filtersql)) {
            sql.append("  and t.form_file_id in (" + filtersql + ") ");
        }
        sql.append(" and f.form_code not in ('pmContractAlt_Form') \n");
        if (!StringUtils.isEmpty((String)search)) {
            List<String> uuidlist = this.fileService.retrieve(search);
            sql.append("  and (  upper(f.form_name) like :searcher  or upper(e.file_type_name) like :searcher  or upper(t.file_name) like :searcher  or upper(a.original_name) like :searcher  or upper(c.project_name) like :searcher  or upper(b.account_name) like :searcher  or upper(t.memo) like :searcher  or a.uuid in (:uuidlist)  )");
            params.put("searcher", "%" + search.toUpperCase() + "%");
            params.put("uuidlist", StrKit.join(uuidlist.toArray()));
        }
        sql.append("  order by create_time desc");
        if (StrKit.notBlank(sort)) {
            String exesql = "select * from (" + sql.toString() + ") " + SysUtils.genOrderBy(sort, order);
            pageobject = this.sqlHelper.pagerNativeSQL(exesql, params, (Integer)page, (Integer)rows);
        } else {
            pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        }
        return pageobject;
    }

    public PageObject pageEdocfile(Long catalogid, String search, String filtersql, int page, int rows, String sort, String order) throws FileStoreException {
        PageObject pageobject = new PageObject();
        StringBuffer sql = new StringBuffer();
        HashMap<String, Object> params = new HashMap<String, Object>();
        sql.append("select d.* from (select D.SUBJECT,\n       D.CONTENT,\n       D.WORKFLOW_STATUS,\n       D.CREATE_TIME,\n       V.File_Id,\n       v.version_id,\n       v.original_name,\n       b.account_name,d.processinstid\n  from edoc_apply d\n   left join BAS_EMP_ACCOUNT b on d.create_account = b.account_id\n, EDOC_FILE_RELATE F, DOC_FILE_VERSION V\n where F.FILE_ID = D.CONTENT\n   and V.VERSION_ID = F.VERSION_ID\n   and d.is_use = 'Y' and d.doc_type = '2' \n\tunion all \nselect d.subject,\n       d.CONTENT,\n       D.WORKFLOW_STATUS,\n       D.CREATE_TIME,\n       V.File_Id,\n       v.version_id,\n       v.original_name,\n       getaccountname(d.create_account) account_name,d.processinstid\n  from DOC_FORM_FILE t\n  left join edoc_apply d\n    on d.id = t.primary_key\n  left join DOC_FILE_VERSION V\n    on v.version_id = t.file_version_id\n where t.file_type_id = 380\n   and d.doc_type <> '2'\n   and t.form_id = 1101580)d\n   where d.processinstid in (select m.processinstid\n          from bas_message m, bas_message_receive r\n         where  m.msg_id = r.msg_id\n           and r.account_id =:accountId \t union all select p.processinstid from wf_processinst p where p.creator =:accountId)");
        params.put("accountId", SysUtils.getLoginAccountId());
        if (catalogid != 0L) {
            sql.append(" and d.catalog_id in         (SELECT t.CATALOG_ID FROM DOC_CATALOG T           WHERE T. IS_USE = 'Y' and t.CATALOG_TYPE = 1           START WITH T.CATALOG_ID = :catalog_id         CONNECT BY PRIOR T.CATALOG_ID = T.PCATALOG_ID) ");
            params.put("catalog_id", catalogid);
        }
        if (StrKit.notBlank(filtersql)) {
            sql.append("   " + filtersql + " ");
        }
        if (!StringUtils.isEmpty((String)search)) {
            List<String> uuidlist = this.fileService.retrieve(search);
            sql.append("  and (   upper(v.original_name) like :searcher  or upper(d.subject) like :searcher  or upper(b.account_name) like :searcher  or v.uuid in (:uuidlist)  )");
            params.put("searcher", "%" + search.toUpperCase() + "%");
            params.put("uuidlist", StrKit.join(uuidlist.toArray()));
        }
        sql.append("  order by d.create_time desc");
        if (StrKit.notBlank(sort)) {
            String exesql = "select * from (" + sql.toString() + ") " + SysUtils.genOrderBy(sort, order);
            pageobject = this.sqlHelper.pagerNativeSQL(exesql, params, (Integer)page, (Integer)rows);
        } else {
            pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        }
        return pageobject;
    }
}

