/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.doc.service;

import com.guochuang.imp.base.common.util.ComBoxTreeNode;
import com.guochuang.imp.base.common.util.CommTreeUtils;
import com.guochuang.imp.base.common.util.NativeSqlHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.doc.dao.DocCatalogDao;
import com.guochuang.imp.doc.entity.DocCatalog;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class DocCatalogService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private DocCatalogDao doccatalogDao;

    public DocCatalog findDocCatalog(String id) {
        DocCatalog entity = (DocCatalog)this.doccatalogDao.findById(id).get();
        return entity;
    }

    public void saveDocCatalog(DocCatalog entity) {
        this.doccatalogDao.save(entity);
    }

    public void delDocCatalog(String id) {
        this.doccatalogDao.deleteById(id);
    }

    public PageObject PageAll(String search, int page, int rows) {
        String sql = "select * from DOC_CATALOG t  order by t.CATALOG_ID";
        if (!StringUtils.isEmpty((String)search)) {
            sql = "select * from DOC_CATALOG t where   upper(t.CATALOG_ID) like ?1  or upper(t.CATALOG_CODE) like ?1  or upper(t.CATALOG_NAME) like ?1  or upper(t.PCATALOG_ID) like ?1  or upper(t.CATALOG_TYPE) like ?1  or upper(t.ORG_ID) like ?1  or upper(t.DEPT_ID) like ?1  or upper(t.ACCOUNT_ID) like ?1  or upper(t.REMARK) like ?1  or upper(t.DISPLAY_NO) like ?1  order by t.CATALOG_ID";
            return this.sqlHelper.pagerNativeSQL(sql, new Object[]{"%" + search.toUpperCase() + "%"}, page, rows);
        }
        return this.sqlHelper.pagerNativeSQL(sql, page, rows);
    }

    public void delDocCatalogAndChild(String id) {
        StringBuilder sql = new StringBuilder();
        sql.append("\tUPDATE \tDOC_CATALOG T \n\tSET\t\tT.IS_USE='N' \n\tWHERE \tT.CATALOG_ID in ( \n\t\twith recursive tmp as \n\t\t(select o1.CATALOG_ID from DOC_CATALOG o1 where o1.CATALOG_ID =?1 \n\t\tUNION ALL  \n \tselect o2.CATALOG_ID id from DOC_CATALOG o2,tmp t  where t.CATALOG_ID = o2.PCATALOG_ID)  \n\t\tselect *  from tmp p) \n");
        this.sqlHelper.exeNativeSQL(sql.toString(), new Object[]{id});
    }

    public List<ComBoxTreeNode> treeDocCatalog(String pid) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT \tt.CATALOG_ID id, \n\t\t\tT.PCATALOG_ID PID, \n     \tt.CATALOG_NAME text \n FROM \tDOC_CATALOG T \n WHERE\tT. IS_USE='Y' \n START WITH T.PCATALOG_ID = ?1 \n CONNECT BY PRIOR T.CATALOG_ID = T.PCATALOG_ID  ORDER BY T.DISPLAY_NO ");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new Object[]{pid}, new int[0]);
        return CommTreeUtils.buildTreeNode(list);
    }

    public List<ComBoxTreeNode> treeStanderDocCatalog(String pid, String sysType) {
        StringBuilder sql = new StringBuilder();
        if (!StringUtils.isEmpty((String)sysType)) {
            sql.append("with recursive temp as(\n\t\t\t\t select a.* from DOC_CATALOG a where  a.PCATALOG_ID = ?1 and a.IS_USE = 'Y'  and a.CATALOG_TYPE=?2\n\t\t\t\t union all\n\t\t\t\t select a.* from DOC_CATALOG a,temp t where t.CATALOG_ID=a.PCATALOG_ID and a.IS_USE = 'Y' and a.CATALOG_TYPE=?2)\nSELECT\n\tt.CATALOG_ID id,\n\tT.PCATALOG_ID PID,\n\tt.CATALOG_NAME text \nFROM\n\ttemp t where  (SYSTEM_CATEGORY =?3 or SYSTEM_CATEGORY ='PUBLIC') ORDER BY T.DISPLAY_NO");
            List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new Object[]{pid, 1, sysType}, new int[0]);
            return CommTreeUtils.buildTreeNode(list);
        }
        sql.append("with recursive temp as(\n\t\t\t\t select a.* from DOC_CATALOG a where  a.PCATALOG_ID = ?1 and a.IS_USE = 'Y'  and a.CATALOG_TYPE=?2\n\t\t\t\t union all\n\t\t\t\t select a.* from DOC_CATALOG a,temp t where t.CATALOG_ID=a.PCATALOG_ID and a.IS_USE = 'Y' and a.CATALOG_TYPE=?2)\nSELECT\n\tt.CATALOG_ID id,\n\tT.PCATALOG_ID PID,\n\tt.CATALOG_NAME text \nFROM\n\ttemp t ORDER BY T.DISPLAY_NO");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new Object[]{pid, 1}, new int[0]);
        return CommTreeUtils.buildTreeNode(list);
    }

    public List<ComBoxTreeNode> treeProjectCatalogWithRoot(String pid) {
        StringBuilder sql = new StringBuilder();
        sql.append("with recursive  temp as(\n    SELECT\n\tt.CATALOG_ID ,\n\tT.PCATALOG_ID ,\n\tt.CATALOG_NAME \nFROM\n\tDOC_CATALOG T\nWHERE\n\tT.IS_USE = 'Y'\n   and t.CATALOG_TYPE = ?2\n and T.PCATALOG_ID = ?1\n        and t.catalog_code = ?3\n    union all \n      SELECT\n\tt.CATALOG_ID ,\n\tT.PCATALOG_ID ,\n\tt.CATALOG_NAME \nFROM\n\tDOC_CATALOG T,temp  \nWHERE\ntemp.CATALOG_ID = T.PCATALOG_ID\n   and t.catalog_code = ?3\nAND\tT.IS_USE = 'Y'\n\n\n)\nSELECT \t\n\tt.CATALOG_ID id,\n\tT.PCATALOG_ID PID,\n\tt.CATALOG_NAME text\n FROM \ttemp T ");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new Object[]{pid, 1, "PROJECT"}, new int[0]);
        return CommTreeUtils.buildTreeNode(list);
    }
}

