/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.doc.common.util;

import com.guochuang.imp.base.common.util.FileUtils;
import com.guochuang.imp.doc.common.util.FileStoreException;
import com.itextpdf.text.Image;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfGState;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.spire.doc.Document;
import com.spire.doc.FileFormat;
import com.spire.doc.HeaderFooter;
import com.spire.doc.Section;
import com.spire.doc.ShapeHorizontalAlignment;
import com.spire.doc.ShapeVerticalAlignment;
import com.spire.doc.documents.HorizontalOrigin;
import com.spire.doc.documents.Paragraph;
import com.spire.doc.documents.ShapeLineStyle;
import com.spire.doc.documents.ShapeType;
import com.spire.doc.documents.TextWrappingStyle;
import com.spire.doc.documents.VerticalOrigin;
import com.spire.doc.fields.DocPicture;
import com.spire.doc.fields.ShapeObject;
import com.spire.doc.interfaces.IDocument;
import com.spire.doc.interfaces.IDocumentObject;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FilenameUtils;

public class WaterMarkUtil {
    public static BufferedImage createWaterMark(String content) {
        int width = 250;
        int heigth = 160;
        BufferedImage image = new BufferedImage(width, heigth, 1);
        Graphics2D g2d = image.createGraphics();
        image = g2d.getDeviceConfiguration().createCompatibleImage(width, heigth, 3);
        g2d.dispose();
        g2d = image.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.rotate(-0.5, (double)image.getWidth() / 2.0, (double)image.getHeight() / 2.0);
        g2d.setColor(new Color(0, 0, 0, 20));
        Font font = new Font("\u5b8b\u4f53", 2, 20);
        g2d.setFont(font);
        float fontSize = font.getSize();
        float x = 0.5f * fontSize;
        float y = 0.5f * (float)heigth + x;
        g2d.drawString(content, x, y);
        g2d.dispose();
        return image;
    }

    public static void addPDFImageWaterMark(String srcPath, String destPath, String imagePath) throws Exception {
        PdfReader reader = new PdfReader(srcPath);
        PdfStamper stamper = new PdfStamper(reader, (OutputStream)new FileOutputStream(destPath));
        Image image = Image.getInstance((String)imagePath);
        PdfGState gs = new PdfGState();
        PdfContentByte content = null;
        int total = reader.getNumberOfPages();
        for (int i = 0; i < total; ++i) {
            float x = reader.getPageSize(i + 1).getWidth();
            float y = reader.getPageSize(i + 1).getHeight();
            content = stamper.getOverContent(i + 1);
            content.setGState(gs);
            content.beginText();
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 3; ++k) {
                    image.setAbsolutePosition(x / 2.0f * (float)j - 30.0f, y / 3.0f * (float)k - 20.0f);
                    content.addImage(image);
                }
            }
            content.endText();
        }
        stamper.close();
        reader.close();
    }

    public static void addPDFImageWaterMark(InputStream inputStream, String destPath, byte[] imageByte, float width, float height) throws Exception {
        System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
        PdfReader reader = new PdfReader(inputStream);
        PdfStamper stamper = new PdfStamper(reader, (OutputStream)new FileOutputStream(destPath));
        Image image = Image.getInstance((byte[])imageByte);
        PdfGState gs = new PdfGState();
        gs.setFillOpacity(0.5f);
        PdfContentByte content = null;
        int total = reader.getNumberOfPages();
        for (int i = 0; i < total; ++i) {
            float x = reader.getPageSize(i + 1).getWidth();
            float y = reader.getPageSize(i + 1).getHeight();
            content = stamper.getOverContent(i + 1);
            content.setGState(gs);
            content.beginText();
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 3; ++k) {
                    image.setAbsolutePosition(x / 1.4f * (float)j + 50.0f, y / 2.5f * (float)k + 10.0f);
                    image.scaleToFit(width, height);
                    content.addImage(image);
                }
            }
            content.endText();
        }
        stamper.close();
        reader.close();
    }

    public static void addPDFWaterMark(String srcPath, String destPath, String word) throws Exception {
        PdfReader reader = new PdfReader(srcPath);
        PdfStamper stamper = new PdfStamper(reader, (OutputStream)new FileOutputStream(destPath));
        String prefixFont = null;
        String os = System.getProperties().getProperty("os.name");
        prefixFont = os.startsWith("win") || os.startsWith("Win") ? "C:\\Windows\\Fonts\\SIMSUN.TTC,1" : "/usr/share/fonts/chinese/TrueType/uming.ttf";
        BaseFont base = BaseFont.createFont((String)prefixFont, (String)"Identity-H", (boolean)false);
        PdfGState gs = new PdfGState();
        gs.setFillOpacity(0.2f);
        PdfContentByte content = null;
        int total = reader.getNumberOfPages();
        for (int i = 0; i < total; ++i) {
            float x = reader.getPageSize(i + 1).getWidth();
            float y = reader.getPageSize(i + 1).getHeight();
            content = stamper.getOverContent(i + 1);
            content.setGState(gs);
            content.beginText();
            content.setFontAndSize(base, 20.0f);
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 3; ++k) {
                    content.showTextAligned(1, word, x / 2.0f * (float)j + 90.0f, y / 3.0f * (float)k, 25.0f);
                }
            }
            content.endText();
        }
        stamper.close();
        reader.close();
    }

    public static void addPDFWaterMark(InputStream inputStream, String destPath, String word) throws Exception {
        System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
        PdfReader reader = new PdfReader(inputStream);
        PdfStamper stamper = new PdfStamper(reader, (OutputStream)new FileOutputStream(destPath));
        String prefixFont = null;
        String os = System.getProperties().getProperty("os.name");
        prefixFont = os.startsWith("win") || os.startsWith("Win") ? "C:\\Windows\\Fonts\\SIMSUN.TTC,1" : "/usr/share/fonts/chinese/TrueType/uming.ttf";
        BaseFont base = BaseFont.createFont((String)prefixFont, (String)"Identity-H", (boolean)false);
        PdfGState gs = new PdfGState();
        gs.setFillOpacity(0.2f);
        PdfContentByte content = null;
        int total = reader.getNumberOfPages();
        for (int i = 0; i < total; ++i) {
            float x = reader.getPageSize(i + 1).getWidth();
            float y = reader.getPageSize(i + 1).getHeight();
            content = stamper.getOverContent(i + 1);
            content.setGState(gs);
            content.beginText();
            content.setFontAndSize(base, 20.0f);
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 3; ++k) {
                    content.showTextAligned(1, word, x / 2.0f * (float)j + 90.0f, y / 3.0f * (float)k, 25.0f);
                }
            }
            content.endText();
        }
        stamper.close();
        reader.close();
    }

    public static void addWordWaterMark(InputStream inputStream, String outFilePath, Color color, String waterMark) {
        Document doc = new Document();
        doc.loadFromStream(inputStream, FileFormat.Auto);
        ShapeObject shape = new ShapeObject((IDocument)doc, ShapeType.Text_Plain_Text);
        shape.setWidth((float)(waterMark.length() * 20));
        shape.setHeight(30.0f);
        shape.setRotation(335.0);
        shape.setLineStyle(ShapeLineStyle.Single);
        shape.getWordArt().setFontFamily("\u5b8b\u4f53");
        shape.getWordArt().setText(waterMark);
        if (color == null) {
            color = new Color(128, 128, 128);
        }
        shape.setFillColor(color);
        shape.setLineStyle(ShapeLineStyle.Single);
        shape.setStrokeColor(color);
        shape.setStrokeWeight(0.02);
        shape.setVerticalOrigin(VerticalOrigin.Margin);
        shape.setHorizontalOrigin(HorizontalOrigin.Margin);
        ShapeHorizontalAlignment[] widthPos = new ShapeHorizontalAlignment[]{ShapeHorizontalAlignment.Right, ShapeHorizontalAlignment.Center, ShapeHorizontalAlignment.Left};
        ShapeVerticalAlignment[] heightPos = new ShapeVerticalAlignment[]{ShapeVerticalAlignment.Top, ShapeVerticalAlignment.Center, ShapeVerticalAlignment.Bottom};
        for (int n = 0; n < doc.getSections().getCount(); ++n) {
            Section section = doc.getSections().get(n);
            HeaderFooter header = section.getHeadersFooters().getHeader();
            Paragraph paragraph = header.getParagraphs().getCount() > 0 ? header.getParagraphs().get(0) : header.addParagraph();
            for (int i = 0; i < 3; ++i) {
                shape = (ShapeObject)shape.deepClone();
                shape.setVerticalAlignment(heightPos[i]);
                shape.setHorizontalAlignment(widthPos[i]);
                paragraph.getChildObjects().add((IDocumentObject)shape);
            }
        }
        doc.saveToFile(outFilePath);
    }

    public static void addWordImgWaterMark(InputStream inputStream, String outFilePath, InputStream imgStream, float width, float height) {
        Document doc = new Document();
        doc.loadFromStream(inputStream, FileFormat.Auto);
        DocPicture picture = new DocPicture((IDocument)doc);
        picture.loadImage(imgStream);
        picture.setWidth(width);
        picture.setHeight(height);
        picture.setVerticalOrigin(VerticalOrigin.Margin);
        picture.setHorizontalOrigin(HorizontalOrigin.Margin);
        ShapeHorizontalAlignment[] widthPos = new ShapeHorizontalAlignment[]{ShapeHorizontalAlignment.Right, ShapeHorizontalAlignment.Center, ShapeHorizontalAlignment.Left};
        ShapeVerticalAlignment[] heightPos = new ShapeVerticalAlignment[]{ShapeVerticalAlignment.Top, ShapeVerticalAlignment.Center, ShapeVerticalAlignment.Bottom};
        picture.setTextWrappingStyle(TextWrappingStyle.Behind);
        for (int n = 0; n < doc.getSections().getCount(); ++n) {
            Section section = doc.getSections().get(n);
            HeaderFooter header = section.getHeadersFooters().getHeader();
            Paragraph paragraph = header.getParagraphs().getCount() > 0 ? header.getParagraphs().get(0) : header.addParagraph();
            for (int i = 0; i < 3; ++i) {
                picture = (DocPicture)picture.deepClone();
                picture.setVerticalAlignment(heightPos[i]);
                picture.setHorizontalAlignment(widthPos[i]);
                paragraph.getChildObjects().add((IDocumentObject)picture);
            }
        }
        doc.saveToFile(outFilePath);
    }

    public static void addTextWaterMark(InputStream inputStream, String fileName, String diskfilepath, String content) throws Exception {
        if (inputStream == null) {
            throw new FileStoreException("\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a!");
        }
        String extension = FilenameUtils.getExtension((String)fileName);
        if ("pdf".equals(extension)) {
            WaterMarkUtil.addPDFWaterMark(inputStream, diskfilepath, content);
        } else if ("doc".equals(extension) || "docx".equals(extension)) {
            WaterMarkUtil.addWordWaterMark(inputStream, diskfilepath, null, content);
        } else {
            throw new FileStoreException("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b!");
        }
    }

    public static void addImageWaterMark(InputStream inputStream, String fileName, String diskfilepath, InputStream imgStream) throws Exception {
        if (inputStream == null) {
            throw new FileStoreException("\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a!");
        }
        String extension = FilenameUtils.getExtension((String)fileName);
        if ("pdf".equals(extension)) {
            WaterMarkUtil.addPDFImageWaterMark(inputStream, diskfilepath, FileUtils.streamToByteArray(imgStream), 80.0f, 80.0f);
        } else if ("doc".equals(extension) || "docx".equals(extension)) {
            WaterMarkUtil.addWordImgWaterMark(inputStream, diskfilepath, imgStream, 80.0f, 80.0f);
        } else {
            throw new FileStoreException("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b!");
        }
    }
}

