/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.doc.common.ocr;

import com.alibaba.fastjson.JSON;
import com.baidu.aip.contentcensor.EImgType;
import com.baidu.aip.ocr.AipOcr;
import com.guochuang.imp.base.common.spring.ThirdPartyInterfaceLog;
import com.guochuang.imp.base.common.util.DateUtils;
import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.entity.BasInterfaceInfo;
import com.guochuang.imp.base.service.BasInterfaceInfoService;
import com.guochuang.imp.doc.common.ocr.AipOcrExtend;
import com.guochuang.imp.doc.common.ocr.InvoiceInfo;
import com.guochuang.imp.doc.entity.DocFormFile;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AipOcrCilentUtils {
    public static String SWITCH = "off";
    public static String VERIFICATION_SWITCH = "off";
    public static String APP_ID = "25430881";
    public static String API_KEY = "IMyIWOP4Pm7DVaqv18p0M5Nd";
    public static String SECRET_KEY = "zBrVGyAgTBqumSCUhx9TZZpcxtA7Hs7I";
    public static final String INTERFACE_CODE = "baidu_ai";
    private static AipOcr client = null;
    private static Logger loger = LoggerFactory.getLogger(AipOcrCilentUtils.class);
    @Autowired
    private BasInterfaceInfoService basInterfaceInfoService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AipOcr getClient() {
        try {
            BasInterfaceInfo info = this.basInterfaceInfoService.findBasInterfaceInfoByinterfaceCode(INTERFACE_CODE);
            if (info != null) {
                JSONObject json = new JSONObject(info.getInterfaceParams());
                SWITCH = json.getString("switch");
                VERIFICATION_SWITCH = json.getString("verificationSwitch");
                APP_ID = json.getString("appId");
                API_KEY = json.getString("apiKey");
                SECRET_KEY = json.getString("secretKey");
            }
        }
        catch (Exception e) {
            loger.error("\u83b7\u53d6\u63a5\u53e3\u53c2\u6570\u5931\u8d25", (Throwable)e);
        }
        if (client != null || !"on".equals(SWITCH) && !"on".equals(VERIFICATION_SWITCH)) return client;
        Class<AipOcrCilentUtils> clazz = AipOcrCilentUtils.class;
        synchronized (AipOcrCilentUtils.class) {
            if (client != null) return client;
            client = new AipOcrExtend(APP_ID, API_KEY, SECRET_KEY);
            client.setConnectionTimeoutInMillis(10000);
            client.setSocketTimeoutInMillis(60000);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return client;
        }
    }

    @ThirdPartyInterfaceLog(description="ocr\u667a\u80fd")
    public InvoiceInfo getMultipleInvoiceInfo(String path) {
        InvoiceInfo info = new InvoiceInfo();
        this.getClient();
        if (!"on".equals(SWITCH)) {
            return info;
        }
        String fileext = FilenameUtils.getExtension((String)path);
        List<String> types = Arrays.asList("pdf", "ofd", "png", "jpg", "jpeg", "bmp");
        if (!types.contains(fileext)) {
            return info;
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("recognize_granularity", "big");
        options.put("probability", "true");
        options.put("accuracy", "normal");
        options.put("detect_direction", "true");
        long t1 = System.currentTimeMillis();
        JSONObject res = "pdf".equals(fileext) ? client.multipleInvoicePdf(path, 1, options) : ("ofd".equals(fileext) ? ((AipOcrExtend)client).multipleInvoiceOfd(path, 1, options) : client.multipleInvoice(path, options));
        loger.info("ocr\u63a5\u53e3\u5171\u8017\u65f6\uff1a" + (System.currentTimeMillis() - t1) + "\u6beb\u79d2,\u8bc6\u522b\u7ed3\u679c\uff1a" + res.toString());
        try {
            res = res.getJSONArray("words_result").getJSONObject(0);
        }
        catch (Exception e2) {
            loger.error("ocr\u7ed3\u679c\u89e3\u6790\u5931\u8d25", (Throwable)e2);
        }
        JSONObject result = new JSONObject();
        try {
            result = res.getJSONObject("result");
        }
        catch (Exception e3) {
            loger.error("ocr\u7ed3\u679c\u89e3\u6790\u5931\u8d25", (Throwable)e3);
        }
        try {
            if ("vat_invoice".equals(res.getString("type"))) {
                if (result.getJSONArray("InvoiceType").getJSONObject(0).getString("word").contains("\u4e13\u7528")) {
                    info.setBillType("1");
                } else {
                    info.setBillType("2");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            info.setBillCode(result.getJSONArray("InvoiceCode").getJSONObject(0).getString("word"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            info.setBillNo(result.getJSONArray("InvoiceNum").getJSONObject(0).getString("word"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            info.setBillDate(DateUtils.strToDate(result.getJSONArray("InvoiceDate").getJSONObject(0).getString("word").replaceAll("\u5e74|\u6708|\u65e5", "-")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            info.setBillMoney(new BigDecimal(result.getJSONArray("AmountInFiguers").getJSONObject(0).getString("word")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            info.setBillMoneyNoTax(new BigDecimal(result.getJSONArray("TotalAmount").getJSONObject(0).getString("word")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (result.getJSONArray("TotalTax").getJSONObject(0).getString("word").contains("*")) {
                info.setBillTaxMoney(new BigDecimal(0));
            } else {
                info.setBillTaxMoney(new BigDecimal(result.getJSONArray("TotalTax").getJSONObject(0).getString("word")));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            info.setCheckCode(result.getJSONArray("CheckCode").getJSONObject(0).getString("word"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return info;
    }

    public JSONObject customFinance(String path, HashMap<String, String> options) {
        JSONObject res = null;
        String fileext = FilenameUtils.getExtension((String)path);
        List<String> types = Arrays.asList("pdf", "png", "jpg", "jpeg", "bmp");
        if (!types.contains(fileext.toLowerCase())) {
            return res;
        }
        this.getClient();
        HashMap options2 = (HashMap)options.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue()));
        long t1 = System.currentTimeMillis();
        res = "pdf".equals(fileext.toLowerCase()) ? client.financePdf(path, options2) : client.finance(path, options2);
        loger.info("ocr\u63a5\u53e3\u5171\u8017\u65f6\uff1a" + (System.currentTimeMillis() - t1) + "\u6beb\u79d2,\u8bc6\u522b\u7ed3\u679c\uff1a" + res.toString());
        return res;
    }

    @ThirdPartyInterfaceLog(description="ocr\u53d1\u7968")
    public InvoiceInfo getInvoiceInfo(String path) {
        InvoiceInfo info = new InvoiceInfo();
        this.getClient();
        if (!"on".equals(SWITCH)) {
            return info;
        }
        String fileext = FilenameUtils.getExtension((String)path);
        List<String> types = Arrays.asList("pdf", "ofd", "png", "jpg", "jpeg", "bmp");
        if (!types.contains(fileext.toLowerCase())) {
            return info;
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("recognize_granularity", "big");
        options.put("probability", "true");
        options.put("accuracy", "normal");
        options.put("detect_direction", "true");
        long t1 = System.currentTimeMillis();
        JSONObject res = "pdf".equals(fileext.toLowerCase()) ? client.vatInvoice(path, EImgType.PDF, options) : ("ofd".equals(fileext.toLowerCase()) ? ((AipOcrExtend)client).vatInvoiceOfd(path, options) : client.vatInvoice(path, options));
        loger.info("\u5171\u8017\u65f6\uff1a" + (System.currentTimeMillis() - t1) + "\u6beb\u79d2,ocr\u7ed3\u679c\uff1a" + res);
        try {
            res = res.getJSONObject("words_result");
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        try {
            info.setBillCode(res.get("InvoiceCode").toString());
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            info.setBillNo(res.getString("InvoiceNum"));
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            info.setBillDate(DateUtils.parseDate(res.getString("InvoiceDate")));
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            info.setBillMoney(new BigDecimal(res.getString("AmountInFiguers")));
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            info.setBillMoneyNoTax(new BigDecimal(res.getString("TotalAmount")));
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            if (res.getString("TotalTax").contains("*")) {
                info.setBillTaxMoney(new BigDecimal(0));
            } else {
                info.setBillTaxMoney(new BigDecimal(res.getString("TotalTax")));
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            if (res.getString("InvoiceType").contains("\u4e13\u7528")) {
                info.setBillType("1");
            } else {
                info.setBillType("2");
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            info.setCheckCode(res.getString("CheckCode"));
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            info.setSaleName(res.getString("SellerName"));
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            info.setServiceType(res.getJSONArray("CommodityName").getJSONObject(0).getString("word"));
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            info.setPurchaserName(res.getString("PurchaserName"));
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            info.setPurchaserRegisterNum(res.getString("PurchaserRegisterNum"));
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            info.setBillTaxRate(res.getJSONArray("CommodityTaxRate").getJSONObject(0).getString("word"));
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            String invoiceType = res.getString("InvoiceType");
            String buildinvoiceType = "normal_invoice";
            if (invoiceType.contains("\u7535\u5b50\u666e\u901a\u53d1\u7968")) {
                buildinvoiceType = "elec_normal_invoice";
            } else if (invoiceType.contains("\u7535\u5b50\u4e13\u7528\u53d1\u7968")) {
                buildinvoiceType = "elec_special_vat_invoice";
            } else if (invoiceType.contains("\u7535\u5b50\u53d1\u7968(\u4e13\u7528\u53d1\u7968)")) {
                buildinvoiceType = "elec_invoice_special";
            } else if (invoiceType.contains("\u7535\u5b50\u53d1\u7968(\u666e\u901a\u53d1\u7968)")) {
                buildinvoiceType = "elec_invoice_normal";
            } else if (invoiceType.contains("\u666e\u901a\u53d1\u7968")) {
                buildinvoiceType = "normal_invoice";
            } else if (invoiceType.contains("\u4e13\u7528\u53d1\u7968")) {
                buildinvoiceType = "special_vat_invoice";
            } else if (invoiceType.contains("\u901a\u884c\u8d39\u7535\u5b50\u666e\u7968")) {
                buildinvoiceType = "toll_elec_normal_invoice";
            } else if (invoiceType.contains("\u533a\u5757\u94fe\u53d1\u7968")) {
                buildinvoiceType = "blockchain_invoice";
            } else if (invoiceType.contains("\u901a\u7528\u673a\u6253\u7535\u5b50\u53d1\u7968")) {
                buildinvoiceType = "special_vat_invoice";
            } else if (invoiceType.contains("\u4e8c\u624b\u8f66")) {
                buildinvoiceType = "used_vehicle_invoice";
            }
            info.setInvoiceType(buildinvoiceType);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return info;
    }

    @ThirdPartyInterfaceLog(description="\u53d1\u7968\u9a8c\u771f")
    public JsonMsg verification(DocFormFile file) throws JSONException {
        JsonMsg msg = new JsonMsg();
        if (file != null && file.getBillTaxMoney() == null) {
            file.setBillTaxMoney(new BigDecimal(0));
        }
        this.getClient();
        if (!"on".equals(VERIFICATION_SWITCH)) {
            msg.setMsg("\u53d1\u7968\u9a8c\u771f\u5f00\u5173\u672a\u5f00\u542f");
            return msg;
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("invoice_code", file.getBillCode());
        options.put("invoice_num", file.getBillNo());
        options.put("invoice_date", DateUtils.dateToStr(file.getBillDate(), "yyyyMMdd"));
        if (StringUtils.isNotBlank((CharSequence)file.getBillNo()) && file.getBillNo().length() == 20) {
            if ("1".equals(file.getBillType())) {
                file.setInvoiceType("elec_invoice_special");
            } else {
                file.setInvoiceType("elec_invoice_normal");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)file.getInvoiceType())) {
            options.put("invoice_type", file.getInvoiceType());
        } else {
            if ("1".equals(file.getBillType())) {
                file.setInvoiceType("special_vat_invoice");
            } else {
                file.setInvoiceType("normal_invoice");
            }
            options.put("invoice_type", file.getInvoiceType());
        }
        options.put("check_code", StringUtils.trim((String)file.getCheckCode()));
        if (file.getInvoiceType().startsWith("elec_invoice") || "used_vehicle_invoice".equals(file.getInvoiceType())) {
            options.put("total_amount", file.getBillMoney().toString());
        } else {
            options.put("total_amount", file.getBillMoney().subtract(file.getBillTaxMoney()).toString());
        }
        long t1 = System.currentTimeMillis();
        JSONObject res = client.vatInvoiceVerification(StringUtils.trim((String)file.getBillCode()), file.getBillNo(), DateUtils.dateToStr(file.getBillDate(), "yyyyMMdd"), (String)options.get("invoice_type"), StringUtils.trim((String)file.getCheckCode()), (String)options.get("total_amount"));
        loger.info("\u5171\u8017\u65f6\uff1a" + (System.currentTimeMillis() - t1) + "\u6beb\u79d2,\u53d1\u7968\u9a8c\u771f\u7ed3\u679c\uff1a" + res + ",\u53d1\u7968\u4fe1\u606f\uff1a" + options.toString());
        if (res.has("VerifyResult") && "0001".equals(res.getString("VerifyResult"))) {
            msg.setSuccess(true);
        } else {
            msg.setSuccess(false);
        }
        try {
            msg.setO("\u5171\u8017\u65f6\uff1a" + (System.currentTimeMillis() - t1) + "\u6beb\u79d2,\u53d1\u7968\u9a8c\u771f\u7ed3\u679c\uff1a" + res.getString("VerifyResult") + ",\u53d1\u7968\u4fe1\u606f\uff1a" + options.toString());
            msg.setMsg(res.getString("VerifyMessage"));
            msg.setCode(res.getString("VerifyResult"));
            String invalidSign = res.getString("InvalidSign");
            if ("Y".equals(invalidSign)) {
                msg.setSuccess(false);
                msg.setMsg("\u53d1\u7968\u5df2\u4f5c\u5e9f");
            } else if ("H".equals(invalidSign) || "BH".equals(invalidSign) || "QH".equals(invalidSign)) {
                msg.setSuccess(false);
                msg.setMsg("\u53d1\u7968\u5df2\u7ea2\u51b2");
            }
            if ("1005".equals(res.getString("VerifyResult")) || "1009".equals(res.getString("VerifyResult")) || "1006".equals(res.getString("VerifyResult")) || "0009".equals(res.getString("VerifyResult")) || "0006".equals(res.getString("VerifyResult")) || "0005".equals(res.getString("VerifyResult"))) {
                msg.setMsg(msg.getMsg() + ",\u8bf7\u68c0\u67e5\u53d1\u7968\u53f7\u3001\u53d1\u7968\u4ee3\u7801\u3001\u5f00\u7968\u65e5\u671f\u3001\u5f00\u7968\u91d1\u989d\u3001\u7a0e\u989d\u3001\u6821\u9a8c\u7801\u7b49\u662f\u5426\u6b63\u786e");
            }
        }
        catch (Exception e) {
            if (res.has("error_msg")) {
                msg.setMsg(res.getString("error_msg"));
            }
            loger.error("\u83b7\u53d6\u9519\u8bef\u7801\u5931\u8d25", (Throwable)e);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AipOcr getClientOcrCustom() {
        try {
            BasInterfaceInfo info = this.basInterfaceInfoService.findBasInterfaceInfoByinterfaceCode(INTERFACE_CODE);
            if (info != null) {
                JSONObject json = new JSONObject(info.getInterfaceParams());
                SWITCH = json.getString("switch");
                VERIFICATION_SWITCH = json.getString("verificationSwitch");
                APP_ID = json.getString("appId");
                API_KEY = json.getString("apiKey");
                SECRET_KEY = json.getString("secretKey");
            }
        }
        catch (Exception e) {
            loger.error("\u83b7\u53d6\u63a5\u53e3\u53c2\u6570\u5931\u8d25", (Throwable)e);
        }
        Class<AipOcrCilentUtils> clazz = AipOcrCilentUtils.class;
        synchronized (AipOcrCilentUtils.class) {
            if (client == null) {
                client = new AipOcrExtend(APP_ID, API_KEY, SECRET_KEY);
                client.setConnectionTimeoutInMillis(10000);
                client.setSocketTimeoutInMillis(60000);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return client;
        }
    }

    public String getAPP_ID() {
        return APP_ID;
    }

    @Value(value="${ocr.appId}")
    public void setAPP_ID(String aPP_ID) {
        APP_ID = aPP_ID;
    }

    public String getVERIFICATION_SWITCH() {
        return VERIFICATION_SWITCH;
    }

    @Value(value="${ocr.verswitch:'off'}")
    public void setVERIFICATION_SWITCH(String vERIFICATION_SWITCH) {
        VERIFICATION_SWITCH = vERIFICATION_SWITCH;
    }

    public String getAPI_KEY() {
        return API_KEY;
    }

    @Value(value="${ocr.appKey}")
    public void setAPI_KEY(String aPI_KEY) {
        API_KEY = aPI_KEY;
    }

    public String getSECRET_KEY() {
        return SECRET_KEY;
    }

    @Value(value="${ocr.secretKey}")
    public void setSECRET_KEY(String sECRET_KEY) {
        SECRET_KEY = sECRET_KEY;
    }

    public String getSWITCH() {
        return SWITCH;
    }

    @Value(value="${ocr.switch}")
    public void setSWITCH(String sWITCH) {
        SWITCH = sWITCH;
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, String> options = new HashMap<String, String>(2);
        options.put("templateSign", "bank_receipt");
        JSONObject info = new AipOcrCilentUtils().customFinance("E:\\\u9879\u76ee\u6587\u6863\\\u7b2c\u4e09\u65b9\\\u767e\u5ea6ai\\\u94f6\u884c\u56de\u5355.pdf", options);
        System.out.println(JSON.toJSONString((Object)info));
    }
}

