/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.doc.common.convert;

import cn.afterturn.easypoi.excel.entity.ExcelToHtmlParams;
import com.guochuang.imp.doc.common.convert.MyExcelToHtmlConvert;
import com.guochuang.imp.doc.common.convert.OfficeToPDFInfo;
import com.guochuang.imp.gen.util.FreeMarkerUtil;
import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.ComThread;
import com.jacob.com.Dispatch;
import com.jacob.com.Variant;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Sides;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class WPSOfficeConverter {
    public static final String WORDSERVER_STRING = "KWPS.Application";
    public static final String PPTSERVER_STRING = "KWPP.Application";
    public static final String EXECLSERVER_STRING = "KET.Application";
    private static final int wdFormatPDF = 17;
    private static final int xlTypePDF = 0;
    private static final int ppSaveAsPDF = 32;
    private static final int wdFormatHTML = 9;

    public static int officeToPdf(String sourceFile, String destFile) {
        File inputFile = new File(sourceFile);
        if (!inputFile.exists()) {
            return -1;
        }
        try {
            File outputFile = new File(destFile);
            if (!outputFile.getParentFile().exists()) {
                outputFile.getParentFile().mkdirs();
            }
            String extentionName = FilenameUtils.getExtension((String)sourceFile);
            boolean result = true;
            if (extentionName.equalsIgnoreCase("ppsx") || extentionName.equalsIgnoreCase("ppt") || extentionName.equalsIgnoreCase("pptx") || extentionName.equalsIgnoreCase("wpt")) {
                result = WPSOfficeConverter.ppt2pdf(sourceFile, destFile);
            } else if (extentionName.equalsIgnoreCase("doc") || extentionName.equalsIgnoreCase("docx") || extentionName.equalsIgnoreCase("wps")) {
                result = WPSOfficeConverter.doc2pdf(sourceFile, destFile);
            } else if (extentionName.equalsIgnoreCase("xls") || extentionName.equalsIgnoreCase("xlsx") || extentionName.equalsIgnoreCase("et")) {
                result = WPSOfficeConverter.excel2Html(sourceFile, destFile);
            }
            if (result) {
                return 1;
            }
            return -2;
        }
        catch (Exception e) {
            return -2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean doc2pdf(String srcFilePath, String pdfFilePath) {
        ActiveXComponent pptActiveXComponent = null;
        ActiveXComponent workbook = null;
        try {
            ComThread.InitSTA();
            pptActiveXComponent = new ActiveXComponent(WORDSERVER_STRING);
            Variant[] openParams = new Variant[]{new Variant((Object)srcFilePath), new Variant(true), new Variant(true)};
            workbook = pptActiveXComponent.invokeGetComponent("Documents").invokeGetComponent("Open", openParams);
            workbook.invoke("SaveAs", new Variant[]{new Variant((Object)pdfFilePath), new Variant(17)});
            boolean bl = true;
            return bl;
        }
        finally {
            if (workbook != null) {
                workbook.invoke("Close");
                workbook.safeRelease();
            }
            if (pptActiveXComponent != null) {
                pptActiveXComponent.invoke("Quit");
                pptActiveXComponent.safeRelease();
            }
            ComThread.Release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean ppt2pdf(String srcFilePath, String pdfFilePath) {
        ActiveXComponent pptActiveXComponent = null;
        ActiveXComponent workbook = null;
        boolean readonly = true;
        try {
            ComThread.InitSTA();
            pptActiveXComponent = new ActiveXComponent(PPTSERVER_STRING);
            workbook = pptActiveXComponent.invokeGetComponent("Presentations").invokeGetComponent("Open", new Variant[]{new Variant((Object)srcFilePath), new Variant(readonly)});
            workbook.invoke("SaveAs", new Variant[]{new Variant((Object)pdfFilePath), new Variant(32)});
            boolean bl = true;
            return bl;
        }
        finally {
            if (workbook != null) {
                workbook.invoke("Close");
                workbook.safeRelease();
            }
            if (pptActiveXComponent != null) {
                pptActiveXComponent.invoke("Quit");
                pptActiveXComponent.safeRelease();
            }
            ComThread.Release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean excel2PDF(String srcFilePath, String pdfFilePath) {
        boolean bl;
        ActiveXComponent et;
        block5: {
            et = null;
            Dispatch workbooks = null;
            Dispatch workbook = null;
            ComThread.InitSTA();
            try {
                et = new ActiveXComponent(EXECLSERVER_STRING);
                et.setProperty("Visible", new Variant(false));
                workbooks = et.getProperty("Workbooks").toDispatch();
                workbook = Dispatch.invoke((Dispatch)workbooks, (String)"Open", (int)1, (Object[])new Object[]{srcFilePath, 0, true}, (int[])new int[1]).toDispatch();
                Dispatch.call((Dispatch)workbook, (String)"ExportAsFixedFormat", (Object[])new Object[]{0, pdfFilePath});
                bl = true;
                if (workbook == null) break block5;
            }
            catch (Throwable throwable) {
                if (workbook != null) {
                    Dispatch.call(workbook, (String)"Close");
                    workbook.safeRelease();
                }
                if (et != null) {
                    et.invoke("Quit");
                    et.safeRelease();
                }
                ComThread.Release();
                throw throwable;
            }
            Dispatch.call((Dispatch)workbook, (String)"Close");
            workbook.safeRelease();
        }
        if (et != null) {
            et.invoke("Quit");
            et.safeRelease();
        }
        ComThread.Release();
        return bl;
    }

    public static boolean excel2Html(String srcFilePath, String htmlFilePath) {
        try {
            String extend = FilenameUtils.getExtension((String)srcFilePath);
            File srcfile = new File(srcFilePath);
            Object wb = null;
            wb = "xls".equalsIgnoreCase(extend) ? new HSSFWorkbook((InputStream)new FileInputStream(srcfile)) : ("xlsx".equalsIgnoreCase(extend) ? new XSSFWorkbook((InputStream)new FileInputStream(srcfile)) : null);
            File htmlfile = new File(htmlFilePath);
            int sheetnum = wb.getNumberOfSheets();
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            for (int i = 0; i < sheetnum; ++i) {
                String sheetname = wb.getSheetName(i);
                MyExcelToHtmlConvert comvert = new MyExcelToHtmlConvert(new ExcelToHtmlParams((Workbook)wb, false, i, htmlfile.getParentFile().getAbsolutePath()));
                String html = comvert.printPage();
                map.put(sheetname, html);
            }
            LinkedHashMap<String, LinkedHashMap<String, String>> propMap = new LinkedHashMap<String, LinkedHashMap<String, String>>();
            propMap.put("sheetmap", map);
            FreeMarkerUtil.instance().geneHtmlFile("/com/guochuang/imp/doc/common/convert/ExceltoHtmlTemplate.ftl", propMap, htmlfile.getParentFile().getAbsolutePath(), FilenameUtils.getBaseName((String)htmlFilePath) + ".html");
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean printFile(String srcFilePath, String printerName) {
        String extentionName = FilenameUtils.getExtension((String)srcFilePath);
        String comcontent = "Documents";
        String COMNAME = WORDSERVER_STRING;
        if (extentionName.equalsIgnoreCase("ppsx") || extentionName.equalsIgnoreCase("ppt") || extentionName.equalsIgnoreCase("pptx") || extentionName.equalsIgnoreCase("wpt")) {
            COMNAME = PPTSERVER_STRING;
            comcontent = "Presentations";
        } else if (extentionName.equalsIgnoreCase("doc") || extentionName.equalsIgnoreCase("docx") || extentionName.equalsIgnoreCase("wps")) {
            COMNAME = WORDSERVER_STRING;
            comcontent = "Documents";
        } else if (extentionName.equalsIgnoreCase("xls") || extentionName.equalsIgnoreCase("xlsx") || extentionName.equalsIgnoreCase("et")) {
            COMNAME = EXECLSERVER_STRING;
            comcontent = "Workbooks";
        }
        ActiveXComponent app = null;
        try {
            ComThread.InitSTA();
            app = new ActiveXComponent(COMNAME);
            Dispatch document = app.getProperty(comcontent).toDispatch();
            Dispatch doc = Dispatch.invoke((Dispatch)document, (String)"Open", (int)1, (Object[])new Object[]{srcFilePath}, (int[])new int[1]).toDispatch();
            Dispatch.callN((Dispatch)doc, (String)"PrintOut", (Object[])new Object[0]);
            boolean bl = true;
            return bl;
        }
        finally {
            if (app != null) {
                app.invoke("Quit");
            }
            ComThread.Release();
        }
    }

    public static void main(String[] args) {
        PrintService[] services;
        OfficeToPDFInfo info = new OfficeToPDFInfo();
        info.setSourceUrl("D:\\BaiduYunDownload\\REL-3.1.2.8\\aaaa.xls");
        info.setDestUrl("D:\\BaiduYunDownload\\REL-3.1.2.8\\\u5de5\u65f6\u8bc4\u4f30.html");
        for (PrintService p : services = PrintServiceLookup.lookupPrintServices(null, null)) {
            System.out.println(p.getName());
        }
        boolean result2 = WPSOfficeConverter.printFile(info.getSourceUrl(), "Foxit Reader PDF Printer");
        System.out.println(result2);
        FileInputStream psStream = null;
        try {
            psStream = new FileInputStream("D:\\BaiduYunDownload\\REL-3.1.2.8\\\u5f71\u50cf\u7cfb\u7edf\u7528\u6237\u64cd\u4f5c\u624b\u518c_v3.1.2.7.docx");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        DocFlavor.INPUT_STREAM psInFormat = DocFlavor.INPUT_STREAM.POSTSCRIPT;
        SimpleDoc myDoc = new SimpleDoc(psStream, psInFormat, null);
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        aset.add(new Copies(5));
        aset.add(Sides.DUPLEX);
    }
}

