/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.doc.common;

import com.guochuang.imp.base.common.util.LoginUser;
import com.guochuang.imp.base.common.util.SysContent;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.doc.common.convert.OfficeConvertService;
import com.guochuang.imp.doc.common.persist.FileInfo;
import com.guochuang.imp.doc.common.persist.PersistInterface;
import com.guochuang.imp.doc.common.persist.PersistJackRabbit;
import com.guochuang.imp.doc.common.persist.PersistLocalFile;
import com.guochuang.imp.doc.common.util.FileHelper;
import com.guochuang.imp.doc.common.util.FileStoreException;
import com.guochuang.imp.doc.entity.Base64FileTypeEnum;
import com.guochuang.imp.doc.entity.DocFile;
import com.guochuang.imp.doc.entity.DocFileType;
import com.guochuang.imp.doc.entity.DocFileVersion;
import com.guochuang.imp.doc.entity.DocFormFile;
import com.guochuang.imp.doc.service.DocFileService;
import com.guochuang.imp.doc.service.DocFileTypeService;
import com.guochuang.imp.doc.service.DocFileVersionService;
import com.guochuang.imp.doc.service.DocFormFileService;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

@Transactional
@Component
public class FileService {
    @Autowired
    private FileHelper fileHelper;
    @Value(value="${fileserver.savetype}")
    private String savetype;
    @Value(value="${fileserver.localpath}")
    private String localpath;
    @Value(value="${fileserver.localvisualpath}")
    private String localvisualpath;
    @Value(value="${fileserver.jackConfigXml}")
    private String xmlPath;
    @Value(value="${fileserver.jackLocalRepository}")
    private String localstorePath;
    @Value(value="${fileserver.jackRemoteRepository}")
    private String remotestorePath;
    @Value(value="${fileserver.storageNodeName}")
    private String storageNodeName;
    @Value(value="${file.previewserver}")
    private String previewserver;
    @Value(value="${serverUrl:-}")
    private String serverUrl;
    @Autowired
    private DocFormFileService docFormFileService;
    @Autowired
    private DocFileTypeService docFileTypeService;
    public static String webOfficeServer;
    @Autowired
    private DocFileService docfileService;
    @Autowired
    private DocFileVersionService docfileversionService;
    @Autowired
    private OfficeConvertService officeConvertService;
    private PersistInterface persistInterface;
    private static final Logger logger;

    public String getWebOfficeServer() {
        return webOfficeServer;
    }

    @Value(value="${file.webOfficeServer}")
    public void setWebOfficeServer(String webOfficeServer) {
        FileService.webOfficeServer = webOfficeServer;
    }

    public PersistInterface getPersistInterface() {
        return this.persistInterface;
    }

    @PostConstruct
    public void loadFileInter() throws FileStoreException {
        logger.info((Object)"\u521d\u59cb\u5316\u5185\u5bb9\u4ed3\u5e93...");
        if ("0".equals(this.savetype)) {
            this.persistInterface = PersistLocalFile.getInstance(this.localpath, this.localvisualpath);
            logger.info((Object)"\u521d\u59cb\u5316\u5185\u5bb9\u4ed3\u5e93...\u5b8c\u6210!\u5b58\u50a8\u65b9\u5f0f:0-\u672c\u5730\u5b58\u50a8");
        } else if ("1".equals(this.savetype)) {
            this.persistInterface = PersistJackRabbit.getInstance(this.xmlPath, this.localstorePath, this.storageNodeName, this.localpath, this.localvisualpath);
            logger.info((Object)"\u521d\u59cb\u5316\u5185\u5bb9\u4ed3\u5e93...\u5b8c\u6210!\u5b58\u50a8\u65b9\u5f0f:1-\u672c\u5730jackrabbit\u5b58\u50a8");
        } else if ("2".equals(this.savetype)) {
            this.persistInterface = PersistJackRabbit.getInstance(null, this.remotestorePath, this.storageNodeName, this.localpath, this.localvisualpath);
            logger.info((Object)"\u521d\u59cb\u5316\u5185\u5bb9\u4ed3\u5e93...\u5b8c\u6210!\u5b58\u50a8\u65b9\u5f0f:2-\u8fdc\u7a0bjackrabbit\u5b58\u50a8");
        }
    }

    public PersistInterface getDownloadFileService(String saveType) throws FileStoreException {
        if ("0".equals(saveType)) {
            return PersistLocalFile.getInstance(this.localpath, this.localvisualpath);
        }
        if ("1".equals(this.savetype)) {
            return PersistJackRabbit.getInstance(this.xmlPath, this.localstorePath, this.storageNodeName, this.localpath, this.localvisualpath);
        }
        return PersistJackRabbit.getInstance(null, this.remotestorePath, this.storageNodeName, this.localpath, this.localvisualpath);
    }

    public FileInfo upLoadFile(MultipartFile file, FileInfo fileinfo) throws FileStoreException, IllegalStateException, IOException, InterruptedException, ExecutionException {
        List<DocFileVersion> versions;
        fileinfo.setFilesize(file.getSize());
        try (InputStream is = file.getInputStream();){
            String md5 = DigestUtils.md5Hex((InputStream)is);
            fileinfo.setMd5(md5);
        }
        is = file.getInputStream();
        var4_4 = null;
        try {
            String sha1 = DigestUtils.sha1Hex((InputStream)is);
            fileinfo.setSha1(sha1);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (is != null) {
                if (var4_4 != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    is.close();
                }
            }
        }
        String fileUUID = null;
        if (StringUtils.isNotBlank((CharSequence)fileinfo.getMd5()) && !(versions = this.docfileversionService.findByMd5(fileinfo.getMd5())).isEmpty()) {
            fileUUID = versions.get(0).getUUID();
        }
        if (StringUtils.isBlank(fileUUID)) {
            fileUUID = this.persistInterface.uploadFile(file, fileinfo);
        } else {
            String filename = new FileHelper().replaceBlank(file.getOriginalFilename());
            fileinfo.setFilename(filename);
        }
        fileinfo.setAppType(SysContent.APP_TYPE_IOP);
        fileinfo.setUUID(fileUUID);
        this.saveFileVersion(fileinfo);
        return fileinfo;
    }

    public FileInfo saveFileVersion(FileInfo fileinfo) {
        Long versionid = fileinfo.getVersionid();
        DocFile docfile = null;
        if (versionid != null && versionid != 0L) {
            docfile = this.docfileversionService.findFileByVersionId(versionid);
        } else if (fileinfo.getStanderfileid() != null && fileinfo.getStanderfileid() != 0L) {
            docfile = this.docfileService.findByProjectIdAndStandardFileId(fileinfo.getProjectid(), fileinfo.getStanderfileid());
        }
        if (docfile == null) {
            docfile = new DocFile();
            docfile.setCatalogId(fileinfo.getCatalogid());
            docfile.setFileName(fileinfo.getFilename());
            docfile.setIsUse("Y");
            docfile.setProjectId(fileinfo.getProjectid());
            docfile.setStandardFileId(fileinfo.getStanderfileid());
            docfile.setCreateAccount(SysUtils.getLoginAccountId());
            docfile.setCreateTime(new Date());
            docfile.setBaseVersionId(0L);
            this.docfileService.saveDocFile(docfile);
        }
        DocFileVersion version = new DocFileVersion();
        version.setFileId(docfile.getFileId());
        version.setIsUse("Y");
        version.setVersionNo("v." + System.currentTimeMillis());
        version.setCreateAccount(SysUtils.getLoginAccountId());
        version.setSaveType(StringUtils.isNotBlank((CharSequence)fileinfo.getSavetype()) ? fileinfo.getSavetype() : this.savetype);
        version.setCreateTime(new Date());
        version.setOriginalName(fileinfo.getFilename());
        version.setFileSize(new BigDecimal(fileinfo.getFilesize()));
        version.setMd5(fileinfo.getMd5());
        version.setSha1(fileinfo.getSha1());
        version.setUUID(fileinfo.getUUID());
        version.setAppType(fileinfo.getAppType() == null ? SysContent.APP_TYPE_IOP : fileinfo.getAppType());
        this.docfileversionService.saveDocFileVersion(version);
        docfile.setBaseVersionId(version.getVersionId());
        docfile.setFileName(fileinfo.getFilename());
        this.docfileService.saveDocFile(docfile);
        fileinfo.setVersionid(version.getVersionId());
        fileinfo.setSavetype(version.getSaveType());
        return fileinfo;
    }

    public void download(HttpServletResponse response, FileInfo fileinfo) throws FileStoreException {
        DocFileVersion version = fileinfo.isUsebase() ? this.docfileversionService.findBaseVersionByVersionid(fileinfo.getVersionid()) : this.docfileversionService.findDocFileVersion(fileinfo.getVersionid());
        if (fileinfo.getIs() == null) {
            fileinfo.setFilename(version.getOriginalName());
            fileinfo.setUUID(version.getUUID());
            fileinfo = this.getDownloadFileService(version.getSaveType()).downloadFile(fileinfo);
        }
        try {
            int len;
            response.setCharacterEncoding("utf-8");
            if (!"Y".equals(fileinfo.getIsView())) {
                response.setContentType("application/x-msdownload;charset=utf-8");
                response.setHeader("Content-Disposition", "attachment;filename=" + new String(URLEncoder.encode(fileinfo.getFilename(), "UTF-8").getBytes("UTF-8"), "iso-8859-1"));
            }
            response.addHeader("Content-Length", "" + fileinfo.getFilesize());
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buffer = new byte[1024];
            while ((len = fileinfo.getIs().read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
            out.flush();
            fileinfo.getIs().close();
        }
        catch (IOException e) {
            logger.error((Object)("\u6587\u4ef6ID\uff1a" + fileinfo.getVersionid() + "   \u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff01"), (Throwable)e);
            throw new FileStoreException("\u6587\u4ef6ID\uff1a" + fileinfo.getVersionid() + "   \u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff01");
        }
    }

    public void downloadFiles(HttpServletResponse response, List<Long> versionids) throws FileStoreException {
        response.setContentType("APPLICATION/OCTET-STREAM;");
        response.setHeader("Content-Disposition", "attachment; filename=zip" + System.currentTimeMillis() + ".zip");
        HashMap<String, Integer> sameFileCount = new HashMap<String, Integer>();
        try {
            ZipOutputStream zos = new ZipOutputStream((OutputStream)response.getOutputStream());
            for (Long versionid : versionids) {
                int len;
                DocFileVersion version = this.docfileversionService.findDocFileVersion(versionid);
                if (version == null) continue;
                FileInfo fileinfo = new FileInfo();
                String fileext = FilenameUtils.getExtension((String)version.getOriginalName());
                if (sameFileCount.containsKey(version.getOriginalName())) {
                    sameFileCount.put(version.getOriginalName(), (Integer)sameFileCount.get(version.getOriginalName()) + 1);
                    fileinfo.setFilename(version.getOriginalName().replace("." + fileext, sameFileCount.get(version.getOriginalName()) + "." + fileext));
                } else {
                    sameFileCount.put(version.getOriginalName(), 1);
                    fileinfo.setFilename(version.getOriginalName());
                }
                fileinfo.setUUID(version.getUUID());
                if (!this.getDownloadFileService(version.getSaveType()).exist(fileinfo)) continue;
                fileinfo = this.getDownloadFileService(version.getSaveType()).downloadFile(fileinfo);
                zos.putNextEntry(new ZipEntry(fileinfo.getFilename()));
                byte[] buffer = new byte[1024];
                while ((len = fileinfo.getIs().read(buffer)) != -1) {
                    zos.write(buffer, 0, len);
                }
                fileinfo.getIs().close();
            }
            zos.flush();
            zos.close();
        }
        catch (IOException e) {
            logger.error((Object)"\u6587\u4ef6\u6253\u5305\u4e0b\u8f7d\u5931\u8d25\uff1a", (Throwable)e);
            throw new FileStoreException("\u6587\u4ef6\u6253\u5305\u4e0b\u8f7d\u5931\u8d25");
        }
    }

    public FileInfo getFileInfoByVersionId(Long versionid) throws Exception {
        FileInfo fileinfo = new FileInfo();
        HashMap<String, Integer> sameFileCount = new HashMap<String, Integer>();
        DocFileVersion version = this.docfileversionService.findDocFileVersion(versionid);
        if (version != null) {
            String fileext = FilenameUtils.getExtension((String)version.getOriginalName());
            if (sameFileCount.containsKey(version.getOriginalName())) {
                sameFileCount.put(version.getOriginalName(), (Integer)sameFileCount.get(version.getOriginalName()) + 1);
                fileinfo.setFilename(version.getOriginalName().replace("." + fileext, sameFileCount.get(version.getOriginalName()) + "." + fileext));
            } else {
                sameFileCount.put(version.getOriginalName(), 1);
                fileinfo.setFilename(version.getOriginalName());
            }
            fileinfo.setUUID(version.getUUID());
            if (this.getDownloadFileService(version.getSaveType()).exist(fileinfo)) {
                fileinfo = this.getDownloadFileService(version.getSaveType()).downloadFile(fileinfo);
            }
        }
        return fileinfo;
    }

    public InputStream getFileIs(Long versionid) throws FileStoreException {
        HashMap<String, Integer> sameFileCount = new HashMap<String, Integer>();
        InputStream is = null;
        try {
            DocFileVersion version = this.docfileversionService.findDocFileVersion(versionid);
            if (version != null) {
                FileInfo fileinfo = new FileInfo();
                String fileext = FilenameUtils.getExtension((String)version.getOriginalName());
                if (sameFileCount.containsKey(version.getOriginalName())) {
                    sameFileCount.put(version.getOriginalName(), (Integer)sameFileCount.get(version.getOriginalName()) + 1);
                    fileinfo.setFilename(version.getOriginalName().replace("." + fileext, sameFileCount.get(version.getOriginalName()) + "." + fileext));
                } else {
                    sameFileCount.put(version.getOriginalName(), 1);
                    fileinfo.setFilename(version.getOriginalName());
                }
                fileinfo.setUUID(version.getUUID());
                if (this.getDownloadFileService(version.getSaveType()).exist(fileinfo)) {
                    fileinfo = this.getDownloadFileService(version.getSaveType()).downloadFile(fileinfo);
                    is = fileinfo.getIs();
                    fileinfo.getIs().close();
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)"\u6587\u4ef6\u6253\u5305\u4e0b\u8f7d\u5931\u8d25\uff1a", (Throwable)e);
            throw new FileStoreException("\u6587\u4ef6\u6253\u5305\u4e0b\u8f7d\u5931\u8d25");
        }
        return is;
    }

    public void downloadFilesByLocalPaths(HttpServletResponse response, List<String> localPaths) throws FileStoreException {
        response.setContentType("APPLICATION/OCTET-STREAM;");
        response.setHeader("Content-Disposition", "attachment; filename=zip" + System.currentTimeMillis() + ".zip");
        BufferedInputStream bis = null;
        FileInputStream fis = null;
        try {
            ZipOutputStream zos = new ZipOutputStream((OutputStream)response.getOutputStream());
            for (String localPath : localPaths) {
                int len;
                fis = new FileInputStream(localPath);
                bis = new BufferedInputStream(fis);
                File file = new File(localPath);
                zos.putNextEntry(new ZipEntry(file.getName()));
                byte[] buffer = new byte[1024];
                while ((len = bis.read(buffer)) != -1) {
                    zos.write(buffer, 0, len);
                }
                bis.close();
            }
            zos.flush();
            zos.close();
        }
        catch (IOException e) {
            logger.error((Object)"\u6587\u4ef6\u6253\u5305\u4e0b\u8f7d\u5931\u8d25\uff1a", (Throwable)e);
            throw new FileStoreException("\u6587\u4ef6\u6253\u5305\u4e0b\u8f7d\u5931\u8d25");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileInfo preview(FileInfo fileinfo) throws FileStoreException {
        DocFileVersion version = fileinfo.isUsebase() ? this.docfileversionService.findBaseVersionByVersionid(fileinfo.getVersionid()) : this.docfileversionService.findDocFileVersion(fileinfo.getVersionid());
        fileinfo.setAppType(version.getAppType() == null ? SysContent.APP_TYPE_IOP : version.getAppType());
        fileinfo.setUUID(version.getUUID());
        fileinfo.setFilename(version.getOriginalName());
        if (version.getAppType() == SysContent.APP_TYPE_IOP) {
            if (!this.getDownloadFileService(version.getSaveType()).exist(fileinfo)) {
                throw new FileStoreException("\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            if (this.fileHelper.isOffice(version.getOriginalName())) {
                fileinfo.setPreview(true);
                fileinfo.setPreviewfilename(this.fileHelper.changeExtPdf(version.getOriginalName()));
                File pdffile = new File(version.getPreviewPath() == null ? "" : version.getPreviewPath());
                if (pdffile != null && version.getConvertStatus() != null && version.getConvertStatus() == 1L && pdffile.exists()) {
                    fileinfo.setConverted(true);
                } else {
                    version.setConvertStatus(0L);
                    version.setPreviewPath("");
                    fileinfo.setConverted(false);
                    fileinfo = this.getDownloadFileService(version.getSaveType()).downloadFile(fileinfo);
                    SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMddHHmmss");
                    String currentTime = dateformat.format(new Date());
                    fileinfo.setTemppath(this.localpath + "/temp/temp/" + FilenameUtils.getBaseName((String)version.getOriginalName()) + "_" + currentTime + "." + FilenameUtils.getExtension((String)version.getOriginalName()));
                    fileinfo.setViewpath(this.localpath + "/temp/pdf/" + FilenameUtils.getBaseName((String)fileinfo.getPreviewfilename()) + "_" + currentTime + "." + FilenameUtils.getExtension((String)fileinfo.getPreviewfilename()));
                    pdffile = new File(fileinfo.getTemppath());
                    OutputStream os = null;
                    try {
                        FileUtils.forceMkdir((File)pdffile.getParentFile());
                        os = new FileOutputStream(pdffile);
                        int bytesRead = 0;
                        byte[] buffer = new byte[8192];
                        while ((bytesRead = fileinfo.getIs().read(buffer, 0, 8192)) != -1) {
                            os.write(buffer, 0, bytesRead);
                        }
                        os.close();
                        fileinfo.getIs().close();
                        fileinfo.setIs(null);
                        this.officeConvertService.addConvert(fileinfo);
                    }
                    catch (Exception e) {
                    }
                    finally {
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (IOException e) {
                                logger.error((Object)e);
                            }
                        }
                    }
                }
            } else if (this.fileHelper.canPreview(version.getOriginalName())) {
                fileinfo.setPreviewfilename(version.getOriginalName());
                fileinfo.setConverted(true);
                fileinfo.setPreview(true);
            } else {
                fileinfo.setPreview(false);
                fileinfo.setConverted(true);
            }
        } else if (version.getAppType() == SysContent.APP_TYPE_TIMS) {
            fileinfo.setConverted(true);
            if (this.fileHelper.canPreview(version.getOriginalName())) {
                fileinfo.setPreviewfilename(version.getOriginalName());
                fileinfo.setPreview(true);
            } else {
                fileinfo.setPreview(false);
            }
        } else if (version.getAppType() == SysContent.APP_TYPE_OA) {
            fileinfo.setConverted(true);
            fileinfo.setViewpath(version.getPreviewPath());
            fileinfo.setPreview(true);
        }
        return fileinfo;
    }

    public void viewfile(HttpServletResponse response, FileInfo fileinfo) throws FileStoreException, FileNotFoundException {
        DocFileVersion version = fileinfo.isUsebase() ? this.docfileversionService.findBaseVersionByVersionid(fileinfo.getVersionid()) : this.docfileversionService.findDocFileVersion(fileinfo.getVersionid());
        if (version != null) {
            fileinfo.setFilename(version.getOriginalName());
            fileinfo.setUUID(version.getUUID());
            if (fileinfo.getIs() == null) {
                if (this.fileHelper.isOffice(version.getOriginalName())) {
                    File file = new File(version.getPreviewPath());
                    fileinfo.setIs(new FileInputStream(file));
                    fileinfo.setFilesize(file.length());
                } else {
                    fileinfo = this.getDownloadFileService(version.getSaveType()).downloadFile(fileinfo);
                }
            }
        }
        try {
            int len;
            String fileext = FilenameUtils.getExtension((String)fileinfo.getPreviewfilename());
            if (!"pdf".equalsIgnoreCase(fileext)) {
                if ("html".equalsIgnoreCase(fileext)) {
                    response.setContentType("text/html; charset=utf-8");
                } else if ("jpg".equalsIgnoreCase(fileext) || "png".equalsIgnoreCase(fileext) || "gif".equalsIgnoreCase(fileext) || "jepg".equalsIgnoreCase(fileext) || "bmp".equalsIgnoreCase(fileext) || "ico".equalsIgnoreCase(fileext)) {
                    response.setContentType("image/*");
                } else {
                    response.setContentType("text/html; charset=GBK");
                }
            }
            response.addHeader("Content-Length", "" + fileinfo.getFilesize());
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buffer = new byte[1024];
            while ((len = fileinfo.getIs().read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
            out.flush();
            fileinfo.getIs().close();
        }
        catch (IOException e) {
            logger.error((Object)("\u6587\u4ef6ID\uff1a" + fileinfo.getVersionid() + "   \u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff01"));
            throw new FileStoreException("\u6587\u4ef6ID\uff1a" + fileinfo.getVersionid() + "   \u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff01");
        }
    }

    public void viewPic(HttpServletResponse response, FileInfo fileinfo) throws FileStoreException, FileNotFoundException {
        DocFileVersion version = fileinfo.isUsebase() ? this.docfileversionService.findBaseVersionByVersionid(fileinfo.getVersionid()) : this.docfileversionService.findDocFileVersion(fileinfo.getVersionid());
        fileinfo.setFilename(version.getOriginalName());
        fileinfo.setUUID(version.getUUID());
        if (this.fileHelper.isOffice(version.getOriginalName())) {
            File file = new File(version.getPreviewPath());
            fileinfo.setIs(new FileInputStream(file));
            fileinfo.setFilesize(file.length());
        } else {
            fileinfo = this.getDownloadFileService(version.getSaveType()).downloadFile(fileinfo);
        }
        try {
            int len;
            response.setContentType("image/*");
            response.addHeader("Content-Length", "" + fileinfo.getFilesize());
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buffer = new byte[1024];
            while ((len = fileinfo.getIs().read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
            out.flush();
            fileinfo.getIs().close();
        }
        catch (IOException e) {
            logger.error((Object)("\u6587\u4ef6ID\uff1a" + fileinfo.getVersionid() + "   \u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff01"));
            throw new FileStoreException("\u6587\u4ef6ID\uff1a" + fileinfo.getVersionid() + "   \u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff01");
        }
    }

    public List<String> retrieve(String keyword) throws FileStoreException {
        FileInfo info = new FileInfo();
        info.setKeyword(keyword);
        return this.persistInterface.searchFile(info);
    }

    public Map<String, String> retrieveWithExcerpt(String catalogid, String keyword) throws FileStoreException {
        FileInfo info = new FileInfo();
        info.setKeyword(keyword);
        info.setCatalogid(catalogid);
        return this.persistInterface.searchFileWithExcerpt(info);
    }

    public Map<String, String> retrieveWithExcerpt(String keyword) throws FileStoreException {
        FileInfo info = new FileInfo();
        info.setKeyword(keyword);
        return this.persistInterface.searchFileWithExcerpt(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadhelpfile(String filename, HttpServletResponse response) throws FileStoreException {
        block14: {
            PersistLocalFile localPersist = PersistLocalFile.getInstance(this.localpath, this.localvisualpath);
            FileInputStream filein = null;
            try {
                int len;
                File file = localPersist.downloadhelpFile(filename);
                filein = new FileInputStream(file);
                response.setContentType("text/html; charset=GBK");
                response.setContentType("application/x-msdownload");
                response.setHeader("Content-Disposition", "attachment;filename=" + new String(file.getName().getBytes("gbk"), "iso-8859-1"));
                BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
                byte[] buffer = new byte[1024];
                while ((len = filein.read(buffer)) != -1) {
                    out.write(buffer, 0, len);
                }
                out.flush();
            }
            catch (IOException e) {
                String msg = e.getCause().getMessage();
                if (msg != null && msg.contains("\u8f6f\u4ef6\u4e2d\u6b62")) {
                    break block14;
                }
                logger.error((Object)("\u6587\u4ef6ID\uff1a" + filename + "   \u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff01"));
                throw new FileStoreException("\u6587\u4ef6ID\uff1a" + filename + "   \u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff01");
            }
            finally {
                if (filein != null) {
                    try {
                        filein.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)e);
                    }
                }
            }
        }
    }

    public FileInfo getFileInfo(FileInfo fileinfo) throws FileStoreException {
        return this.getDownloadFileService(fileinfo.getSavetype()).downloadFile(fileinfo);
    }

    public String getLocalpath() {
        return this.localpath;
    }

    public void setLocalpath(String localpath) {
        this.localpath = localpath;
    }

    public String getPreviewserver() {
        return this.previewserver;
    }

    public void setPreviewserver(String previewserver) {
        this.previewserver = previewserver;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File base64ToFile(String base64, String fileName) {
        File file = null;
        String filePath = this.getClass().getClassLoader().getResource("").getPath();
        File dir = new File(filePath);
        if (!dir.exists() && !dir.isDirectory()) {
            dir.mkdirs();
        }
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        try {
            String fileType = Base64FileTypeEnum.getFileType(base64.substring(0, base64.indexOf(",")));
            String s = base64.substring(base64.indexOf(",") + 1);
            byte[] bytes = new BASE64Decoder().decodeBuffer(s);
            file = new File(filePath + "/" + fileName + fileType);
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return file;
    }

    public MultipartFile getMultipartFile(File file) {
        FileItem item = new DiskFileItemFactory().createItem("file", "multipart/form-data", true, file.getName());
        try (FileInputStream input = new FileInputStream(file);
             OutputStream os = item.getOutputStream();){
            IOUtils.copy((InputStream)input, (OutputStream)os);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid file: " + e, e);
        }
        return new CommonsMultipartFile(item);
    }

    public boolean canDownLoadsource(Long versionId) {
        DocFileVersion version = this.docfileversionService.findBaseVersionByVersionid(versionId);
        LoginUser user = SysUtils.getLoginUser();
        Long accountId = user.getAccountid();
        Subject currentUser = SecurityUtils.getSubject();
        if (version.getCreateAccount().equals(accountId) || currentUser.isPermitted("admin:managexxx") || currentUser.isPermitted("canDownLoadsource")) {
            return true;
        }
        DocFile file = this.docfileService.findDocFile(version.getFileId());
        if (file != null && file.getCatalogId() != null && (file.getCatalogId().equals(88888888L) || file.getCatalogId().equals(1000881L))) {
            return true;
        }
        List<DocFormFile> list = this.docFormFileService.findByFileVersionIdAndIsUse(versionId, "Y");
        for (DocFormFile fv : list) {
            DocFileType type;
            if (fv.getFileTypeId() != null && (type = this.docFileTypeService.findDocFileType(fv.getFileTypeId())) != null && "N".equals(type.getDownloadSource())) {
                return false;
            }
            if (fv.getFormId() == null || !fv.getFormId().equals(0L)) continue;
            return true;
        }
        return true;
    }

    public void imgThum(FileInfo fileinfo, HttpServletRequest request, HttpServletResponse response) throws FileStoreException, IOException {
        File file;
        if (fileinfo.getThumWidth() == null || fileinfo.getThumWidth() > 2000L || fileinfo.getThumWidth() < 10L) {
            return;
        }
        DocFileVersion version = fileinfo.isUsebase() ? this.docfileversionService.findBaseVersionByVersionid(fileinfo.getVersionid()) : this.docfileversionService.findDocFileVersion(fileinfo.getVersionid());
        fileinfo.setFilename(version.getOriginalName());
        fileinfo.setUUID(version.getUUID());
        fileinfo = this.getDownloadFileService(version.getSaveType()).downloadFile(fileinfo);
        String fileName = version.getOriginalName();
        String fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
        if (!new File(this.localpath + File.separator + "thum").exists()) {
            new File(this.localpath + File.separator + "thum").mkdir();
        }
        if (!(file = new File(this.localpath + File.separator + "thum" + File.separator + fileinfo.getVersionid() + "_" + fileinfo.getThumWidth() + "." + fileType)).exists()) {
            Thumbnails.of((InputStream[])new InputStream[]{fileinfo.getIs()}).width(fileinfo.getThumWidth().intValue()).toFile(file);
        }
        try (FileInputStream in = new FileInputStream(file);){
            int len;
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buffer = new byte[1024];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
            out.flush();
        }
        catch (IOException e) {
            logger.error((Object)("\u6587\u4ef6ID\uff1a" + fileinfo.getVersionid() + "   \u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff01"));
            throw new FileStoreException("\u6587\u4ef6ID\uff1a" + fileinfo.getVersionid() + "   \u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff01");
        }
        finally {
            try {
                fileinfo.getIs().close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String getFileBase64(Long versionId) throws FileStoreException, IOException {
        DocFileVersion version = this.docfileversionService.findDocFileVersion(versionId);
        if (version != null) {
            FileInfo fileinfo = new FileInfo();
            fileinfo.setFilename(version.getOriginalName());
            fileinfo.setUUID(version.getUUID());
            if (this.getDownloadFileService(version.getSaveType()).exist(fileinfo)) {
                fileinfo = this.getDownloadFileService(version.getSaveType()).downloadFile(fileinfo);
                InputStream inputStream = null;
                byte[] data = null;
                try {
                    inputStream = fileinfo.getIs();
                    data = new byte[inputStream.available()];
                    inputStream.read(data);
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                BASE64Encoder encoder = new BASE64Encoder();
                return "data:image/png;base64," + encoder.encode(data);
            }
        }
        return "";
    }

    static {
        logger = Logger.getLogger(FileService.class);
    }
}

