/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.config;

import cn.hutool.core.io.FileUtil;
import com.guochuang.imp.config.LoginConfigProperties;
import java.io.File;
import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Component;

@Component
@EnableConfigurationProperties(value={LoginConfigProperties.class})
public class LoginImgsConfig
implements ApplicationRunner {
    public void run(ApplicationArguments args) throws Exception {
        Resource[] resources;
        String loginBgPath = LoginConfigProperties.baseDir + LoginConfigProperties.LOGIN_BG;
        if (FileUtil.exist((String)loginBgPath) && FileUtil.isNotEmpty((File)new File(loginBgPath))) {
            return;
        }
        String matchPattern = "classpath:static/loginImgs/*/*.*";
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        for (Resource resource : resources = resourcePatternResolver.getResources(matchPattern)) {
            String path = resource.getURL().getPath();
            String relativePath = StringUtils.substringAfter((String)path, (String)"static/loginImgs");
            FileUtil.writeFromStream((InputStream)resource.getInputStream(), (String)(LoginConfigProperties.baseDir + relativePath));
        }
    }
}

