/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.MemCache;
import com.guochuang.imp.base.common.util.ValueText;
import com.guochuang.imp.base.dao.BasDeptDao;
import com.guochuang.imp.base.dao.BasDicDao;
import com.guochuang.imp.base.dao.BasEmpAccountDao;
import com.guochuang.imp.base.dao.BasOrgDao;
import com.guochuang.imp.base.entity.BasDept;
import com.guochuang.imp.base.entity.BasDic;
import com.guochuang.imp.base.entity.BasEmpAccount;
import com.guochuang.imp.base.entity.BasOrg;
import com.guochuang.imp.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="MemCacheService")
public class MemCacheService {
    @Autowired
    private BasDicDao dicDao;
    @Autowired
    private BasOrgDao basOrgDao;
    @Autowired
    private BasDeptDao basDeptDao;
    @Autowired
    private BasEmpAccountDao basEmpAccountDao;
    @Autowired
    private BeetlSQLHelper beetlSQLHelper;

    public void setDicCache() {
        this.beetlSQLHelper.serachBySql("select 1 from bas_dic limit 1", null);
        List<BasDic> list = this.dicDao.findAllByOrderByDicCodeAscDicValueAsc();
        HashMap<String, List<ValueText>> map = new HashMap<String, List<ValueText>>();
        String dicCode = "";
        for (BasDic basDic : list) {
            dicCode = basDic.getDicCode();
            ArrayList<ValueText> tmpList = (ArrayList<ValueText>)map.get(dicCode);
            if (tmpList == null) {
                tmpList = new ArrayList<ValueText>();
            }
            tmpList.add(new ValueText(basDic.getDicValue(), basDic.getDicText()));
            map.put(dicCode, tmpList);
        }
        MemCache.dicMap = map;
    }

    public void setOrgCache() {
        HashMap<Long, String> orgMap = new HashMap<Long, String>();
        HashMap<Long, String> orgAbbrMap = new HashMap<Long, String>();
        List list = this.basOrgDao.findAll();
        for (BasOrg entity : list) {
            orgMap.put(entity.getOrgId(), entity.getOrgName());
            orgAbbrMap.put(entity.getOrgId(), entity.getAbbr());
        }
        MemCache.orgMap = orgMap;
        MemCache.orgAbbrMap = orgAbbrMap;
    }

    public void setDeptCache() {
        HashMap<Long, String> deptMap = new HashMap<Long, String>();
        HashMap<Long, String> deptAbbrMap = new HashMap<Long, String>();
        List list = this.basDeptDao.findAll();
        for (BasDept entity : list) {
            deptMap.put(entity.getDeptId(), entity.getDeptName());
            deptAbbrMap.put(entity.getDeptId(), entity.getAbbr());
        }
        MemCache.deptMap = deptMap;
        MemCache.deptAbbrMap = deptAbbrMap;
    }

    public void setEmpAccountCache() {
        HashMap<Long, String> empAccountMap = new HashMap<Long, String>();
        List list = this.basEmpAccountDao.findAll();
        for (BasEmpAccount entity : list) {
            empAccountMap.put(entity.getAccountId(), entity.getAccountName());
        }
        MemCache.empAccountMap = empAccountMap;
    }

    public void setHrEmpCache() {
        HashMap<Long, String> hrEmpMap = new HashMap<Long, String>();
        List<Map<String, Object>> list = this.beetlSQLHelper.serachBySql("SELECT t.HR_EMP_ID,t.EMP_NAME from hr_emp t where t.is_use = 'Y'", null);
        for (Map<String, Object> map : list) {
            hrEmpMap.put(StringUtil.strToLong(map.get("hrEmpId")), StringUtil.null2String(map.get("empName")));
        }
        MemCache.hrEmpMap = hrEmpMap;
    }

    public synchronized void setSysConfigCache() {
        MemCache.SysConfigMap = new HashMap<String, String>();
        List<Map<String, Object>> list = this.beetlSQLHelper.serachBySql("SELECT t.CONFIG_CODE,t.CONFIG_CONTENT from bas_system_config t where t.is_use = 'Y'", null);
        list.forEach(map -> MemCache.SysConfigMap.put(StringUtil.null2String(map.get("configCode")), StringUtil.null2String(map.get("configContent"))));
    }
}

