/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.LoginUser;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.base.dao.GmInfoCommentDao;
import com.guochuang.imp.base.entity.GmInfoComment;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class GmInfoCommentService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private GmInfoCommentDao gminfocommentDao;

    public GmInfoComment findGmInfoComment(Long id) {
        GmInfoComment entity = (GmInfoComment)this.gminfocommentDao.findById(id).get();
        return entity;
    }

    public void saveGmInfoComment(GmInfoComment entity) {
        this.gminfocommentDao.save(entity);
    }

    public void delGmInfoComment(Long id) {
        GmInfoComment entity = (GmInfoComment)this.gminfocommentDao.findById(id).get();
        entity.setIsUse("N");
        this.gminfocommentDao.save(entity);
    }

    public PageObject PageAll(String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        return this.bSqlHelper.serachPage("base.GmInfoComment.select", params, PageRequest.of((int)page, (int)rows));
    }

    public List<Map<String, Object>> findCommentDataByInfoId(Long infoId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        LoginUser user = SysUtils.getLoginUser();
        params.put("accountId", user.getAccountid());
        if (infoId != null) {
            params.put("infoId", infoId);
        }
        return this.bSqlHelper.getMapList("base.GmInfoComment.select", params);
    }

    public int findCommentCount(Long id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("infoId", id);
        return this.bSqlHelper.getIntValue("base.GmInfoComment.findCommentCount", params);
    }
}

