/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.ComBoxTreeNode;
import com.guochuang.imp.base.common.util.ComboxNode;
import com.guochuang.imp.base.common.util.ComboxUtils;
import com.guochuang.imp.base.common.util.CommTreeUtils;
import com.guochuang.imp.base.common.util.LoginUser;
import com.guochuang.imp.base.common.util.MemCache;
import com.guochuang.imp.base.common.util.NativeSqlHelper;
import com.guochuang.imp.base.common.util.StrKit;
import com.guochuang.imp.base.common.util.SysContent;
import com.guochuang.imp.base.dao.BasDicDao;
import com.guochuang.imp.base.dao.BasDicTypeDao;
import com.guochuang.imp.base.dao.BasOrgDao;
import com.guochuang.imp.base.dao.BasSysLoginlogDao;
import com.guochuang.imp.base.entity.BasDept;
import com.guochuang.imp.base.entity.BasDic;
import com.guochuang.imp.base.entity.BasDicType;
import com.guochuang.imp.base.entity.BasEmp;
import com.guochuang.imp.base.entity.BasEmpAccount;
import com.guochuang.imp.base.entity.BasOrg;
import com.guochuang.imp.base.entity.BasSysLoginlog;
import com.guochuang.imp.base.service.BasDeptService;
import com.guochuang.imp.base.service.BasEmpAccountService;
import com.guochuang.imp.base.service.BasOrgService;
import com.guochuang.imp.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.shiro.session.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Component(value="CommonService")
public class CommonService {
    Logger loger = Logger.getLogger(CommonService.class);
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasDicDao basDicDao;
    @Autowired
    private BasDicTypeDao basDicTypeDao;
    @Autowired
    private BasOrgService basOrgService;
    @Autowired
    private BasDeptService basDeptService;
    @Autowired
    private BasSysLoginlogDao basSysLoginlogDao;
    @Autowired
    private BasEmpAccountService basEmpAccountService;
    public static boolean initPassword = false;
    public static boolean showSign = true;
    @Autowired
    private BasOrgDao basOrgDao;
    @Value(value="${WebIMServer}")
    private String WebIMServer;
    private static ConcurrentHashMap<Long, LoginUser> onlineMaps = new ConcurrentHashMap();
    private static HashMap mymap = new HashMap();

    public static synchronized void AddSession(HttpSession session) {
        if (session != null) {
            mymap.put(session.getId(), session);
        }
    }

    public String getWebIMServer() {
        return this.WebIMServer;
    }

    @Value(value="${initPassword}")
    public void setInitPassword(boolean initPassword) {
        CommonService.initPassword = initPassword;
    }

    @Value(value="${showSign}")
    public void setShowSign(boolean showSign) {
        CommonService.showSign = showSign;
    }

    public static synchronized void DelSession(HttpSession session) {
        if (session != null) {
            mymap.remove(session.getId());
        }
    }

    public static synchronized void AddSession(Session session) {
        if (session != null) {
            mymap.put(session.getId(), session);
        }
    }

    public static synchronized void DelSession(Session session) {
        if (session != null) {
            mymap.remove(session.getId());
        }
    }

    public static synchronized Session getSession(String session_id) {
        if (session_id == null) {
            return null;
        }
        return (Session)mymap.get(session_id);
    }

    @PostConstruct
    public void init() {
        JSON.DEFFAULT_DATE_FORMAT = "yyyy-MM-dd";
        Locale.setDefault(Locale.SIMPLIFIED_CHINESE);
    }

    public List<Object> fmtListWithDic(List<Object> list, Map<String, String> dicmapper) {
        for (Object o : list) {
            Map row = (Map)o;
            for (String column : dicmapper.keySet()) {
                if (!row.containsKey(column)) continue;
                String value = row.get(column) == null ? null : row.get(column).toString();
                String dicCode = dicmapper.get(column);
                String text = this.getDicText(dicCode, value);
                row.put(column + "_TEXT_", text);
            }
        }
        return list;
    }

    public Object fmtListWithDic(Object o, Map<String, String> dicmapper) {
        Map row = (Map)o;
        for (String column : dicmapper.keySet()) {
            if (!row.containsKey(column)) continue;
            String value = row.get(column) == null ? null : row.get(column).toString();
            String dicCode = dicmapper.get(column);
            String text = this.getDicText(dicCode, value);
            row.put(column + "_TEXT_", text);
        }
        return o;
    }

    public List<Map<String, Object>> formatListWithDic(List<Map<String, Object>> list, Map<String, String> dicmapper) {
        for (Map<String, Object> row : list) {
            for (String column : dicmapper.keySet()) {
                if (!row.containsKey(column)) continue;
                String value = row.get(column) == null ? null : row.get(column).toString();
                String dicCode = dicmapper.get(column);
                String text = MemCache.getDicText(dicCode, value);
                row.put(column + "Text", text);
            }
        }
        return list;
    }

    public Map<String, String> getDicMap(String diccode) {
        LinkedHashMap<String, String> dicMap = new LinkedHashMap<String, String>();
        List<BasDic> diclist = this.basDicDao.findByDicCodeOrderByDisplayNoAscDicCodeAscDicValueAsc(diccode);
        for (BasDic dic : diclist) {
            dicMap.put(dic.getDicValue(), dic.getDicText());
        }
        return dicMap;
    }

    public String getDicText(String diccode, String value) {
        List<BasDic> diclist = this.basDicDao.findByDicCodeOrderByDisplayNoAscDicCodeAscDicValueAsc(diccode);
        if (diclist == null || diclist.size() < 1) {
            return value;
        }
        if (StrKit.notBlank(value)) {
            String[] valArr = value.split(",");
            Object[] textArr = new String[valArr.length];
            for (int i = 0; i < valArr.length; ++i) {
                String thisdictext = valArr[i];
                for (BasDic dic : diclist) {
                    if (!dic.getDicValue().equals(valArr[i])) continue;
                    thisdictext = dic.getDicText();
                    break;
                }
                textArr[i] = thisdictext;
            }
            return StringUtils.join((Object[])textArr, (String)",");
        }
        return value;
    }

    public List<ComboxNode> getAllDicCode() {
        List<BasDicType> alldiclist = this.basDicTypeDao.findByIsUseOrderByOrdByAscDicCodeAsc("Y");
        ArrayList<ComboxNode> list = new ArrayList<ComboxNode>();
        for (BasDicType type : alldiclist) {
            ComboxNode node = new ComboxNode();
            node.setText(type.getDicCode() + "(" + type.getDicName() + ")");
            node.setValue(type.getDicCode());
            list.add(node);
        }
        return list;
    }

    public List<ComboxNode> getDicCombo(String dicCode) {
        return ComboxUtils.dictoCombo(this.basDicDao.findByDicCodeAndIsEnableOrderByDisplayNoAscDicCodeAscDicValueAsc(dicCode, "1"));
    }

    public List<ComBoxTreeNode> getDicComboTree(String dicCode) {
        List<BasDic> list = this.basDicDao.findByDicCodeAndIsEnableOrderByDisplayNoAscDicCodeAscDicValueAsc(dicCode, "1");
        Map<String, String> valueMap = list.stream().collect(Collectors.toMap(p -> p.getDicId().toString(), p -> p.getDicValue()));
        List mapList = list.stream().map(this::dicMap).collect(Collectors.toList());
        mapList.stream().forEach(map -> {
            if (map.get("pid") != null) {
                map.put("pid", map.get("pid").toString());
                map.put("pid", valueMap.get(map.get("pid").toString()));
            }
        });
        List<ComBoxTreeNode> treeList = CommTreeUtils.buildTreeNode(mapList);
        return treeList;
    }

    public Map<String, Object> dicMap(BasDic dic) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", dic.getDicValue());
        map.put("dicId", dic.getDicId());
        map.put("pid", dic.getPdicId());
        map.put("text", dic.getDicText());
        return map;
    }

    public List<ComBoxTreeNode> getDicComboTreeWithId(String dicCode) {
        List<BasDic> list = this.basDicDao.findByDicCodeAndIsEnableOrderByDisplayNoAscDicCodeAscDicValueAsc(dicCode, "1");
        List mapList = list.stream().map(this::dicMapWithId).collect(Collectors.toList());
        List<ComBoxTreeNode> treeList = CommTreeUtils.buildTreeNode(mapList);
        return treeList;
    }

    public Map<String, Object> dicMapWithId(BasDic dic) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", dic.getDicId());
        map.put("pid", dic.getPdicId());
        map.put("text", dic.getDicText());
        return map;
    }

    public List<ComboxNode> getDicComboWithDefault(String dicCode) {
        return ComboxUtils.dictoComboWithDefault(this.basDicDao.findByDicCodeAndIsEnableOrderByDisplayNoAscDicCodeAscDicValueAsc(dicCode, "1"));
    }

    public List<ComboxNode> getDicComboWithEmpty(String dicCode) {
        ComboxNode rootnode = new ComboxNode();
        rootnode.setText("---\u8bf7\u9009\u62e9---");
        List<ComboxNode> list = ComboxUtils.dictoCombo(this.basDicDao.findByDicCodeAndIsEnableOrderByDisplayNoAscDicCodeAscDicValueAsc(dicCode, "1"));
        list.add(0, rootnode);
        return list;
    }

    public List<ComboxNode> getDicComboWithAll(String dicCode) {
        ComboxNode rootnode = new ComboxNode();
        rootnode.setText("\u5168\u90e8");
        rootnode.setSelected(true);
        List<ComboxNode> list = ComboxUtils.dictoCombo(this.basDicDao.findByDicCodeAndIsEnableOrderByDisplayNoAscDicCodeAscDicValueAsc(dicCode, "1"));
        list.add(0, rootnode);
        return list;
    }

    public List<ComboxNode> getTopData(String typeCode) {
        List<BasDic> list = this.basDicDao.findTop2ByDicCodeOrderByDicValueAsc(typeCode);
        return ComboxUtils.dictoCombo(list);
    }

    public Map<String, List<ComboxNode>> getDictionary(String[] dicTypes) {
        HashMap<String, List<ComboxNode>> map = new HashMap<String, List<ComboxNode>>();
        for (String type : dicTypes) {
            List<ComboxNode> lbdv = ComboxUtils.dictoCombo(this.basDicDao.findByDicCodeAndIsEnableOrderByDisplayNoAscDicCodeAscDicValueAsc(type, "1"));
            map.put(type, lbdv);
        }
        return map;
    }

    public List<ComboxNode> multdics(String[] dicTypes) {
        ArrayList<ComboxNode> list = new ArrayList<ComboxNode>();
        for (String type : dicTypes) {
            list.addAll(ComboxUtils.dictoCombo(this.basDicDao.findByDicCodeAndIsEnableOrderByDisplayNoAscDicCodeAscDicValueAsc(type, "1")));
        }
        return list;
    }

    public String getPK(String tablename) {
        String pk = this.bSqlHelper.getStringValue("gen.db.getPk", MapUtil.of((Object)"tableName", (Object)tablename));
        return pk;
    }

    public boolean isColumnExsit(String tablename, String column) {
        if (!StrKit.notBlank(tablename, column)) {
            return false;
        }
        tablename = tablename.toUpperCase().trim();
        String sql = "select count(*)\n  from INFORMATION_SCHEMA.`COLUMNS` t\n where  t.TABLE_SCHEMA=schema() and t.column_name=?1\n   and t.table_name = ?2";
        Object object = this.sqlHelper.getSingal(sql, new Object[]{column.toUpperCase(), tablename.toUpperCase()});
        int count = Integer.parseInt(object.toString());
        return count != 0;
    }

    public static ConcurrentHashMap<Long, LoginUser> getOnlineUsers() {
        return onlineMaps;
    }

    public static void updateOnlineUser(LoginUser loginUser) {
        onlineMaps.putIfAbsent(loginUser.getAccountid(), loginUser);
    }

    public static void delOnlineUser(LoginUser loginUser) {
        if (onlineMaps != null && loginUser != null) {
            onlineMaps.remove(loginUser.getAccountid(), loginUser);
        }
    }

    public static void addOnlineUser(LoginUser loginUser) {
        onlineMaps.put(loginUser.getAccountid(), loginUser);
    }

    public static LoginUser getLoginUserById(Long empId) {
        return onlineMaps.get(empId);
    }

    public static List<Long> getOnlineUserAccount() {
        ArrayList<Long> accountIdList = new ArrayList<Long>();
        for (Map.Entry<Long, LoginUser> entry : CommonService.getOnlineUsers().entrySet()) {
            Long accountId = entry.getValue().getAccountid();
            if (SysContent.ADMIN_ACCOUNT_ID.equals(accountId)) continue;
            accountIdList.add(accountId);
        }
        return accountIdList;
    }

    public static LoginUser getLoginUserByAccountId(Long accountId) {
        return onlineMaps.get(accountId);
    }

    public static boolean containsKey(Long accountId) {
        return onlineMaps.containsKey(accountId);
    }

    public void setLogOutLog(String sessionId, Long accountid) {
        List<BasSysLoginlog> basSysLoginlogs = this.basSysLoginlogDao.findBySessionIdAndAccountIdAndLogoutTimeIsNull(sessionId, accountid);
        if (!basSysLoginlogs.isEmpty()) {
            for (BasSysLoginlog basSysLoginlog : basSysLoginlogs) {
                Date now = new Date();
                basSysLoginlog.setLogoutTime(now);
                this.basSysLoginlogDao.save(basSysLoginlog);
            }
        }
    }

    public LoginUser setSessionAndLogInLog(HttpSession session, BasEmp emp, Long loginAccountid, String ip) {
        BasDept dept;
        BasOrg org;
        BasEmpAccount empaccount = this.basEmpAccountService.findById(loginAccountid);
        List<BasEmpAccount> accountList = this.basEmpAccountService.findByEmpId(emp.getEmpId());
        LoginUser loginUser = new LoginUser();
        if (emp.getHrEmpId() != null) {
            try {
                loginUser.setHrEmp(this.bSqlHelper.getMap("business.workflow.common.getHrEmp", MapUtil.of((Object)"empId", (Object)emp.getHrEmpId())));
                loginUser.setStation(Objects.toString(loginUser.getHrEmp().get("station"), ""));
                loginUser.setJobLevel(this.bSqlHelper.getStringValue("business.hr.HrEmp.getMaxJobLevel", MapUtil.of((Object)"accountId", (Object)loginAccountid)));
            }
            catch (Throwable e) {
                this.loger.warn((Object)"\u83b7\u53d6\u5458\u5de5\u6863\u6848\u4fe1\u606f\u5931\u8d25", e);
            }
        }
        loginUser.setEmp(emp);
        loginUser.setEmpAccount(empaccount);
        if ("1".equals(session.getAttribute("mobile"))) {
            loginUser.setPlatform("mobile");
        } else {
            loginUser.setPlatform("pc");
        }
        if (StringUtils.isNotBlank((String)empaccount.getThemes())) {
            loginUser.setThemes(empaccount.getThemes());
        } else {
            loginUser.setThemes("default");
        }
        if (StringUtils.isNotBlank((String)empaccount.getMenuStyle())) {
            loginUser.setMenuStyle(empaccount.getMenuStyle());
        } else {
            loginUser.setMenuStyle("4");
        }
        if (StringUtils.isNotBlank((String)empaccount.getMenuDisplay())) {
            loginUser.setMenuDisplay(empaccount.getMenuDisplay());
        } else {
            loginUser.setMenuDisplay("float");
        }
        if (empaccount.getOrgId() != null && (org = this.basOrgService.findByOrgId(empaccount.getOrgId())) != null) {
            loginUser.setOrgName(org.getAbbr());
            loginUser.setOrgFullName(org.getOrgName());
            loginUser.setEmpOrgIsOut(StringUtil.null2String(org.getType()));
            loginUser.setOrgCode(org.getOrgCode());
            loginUser.setOrgRetrieveCode(org.getRetrieveCode());
        }
        if (empaccount.getDeptId() != null && (dept = this.basDeptService.findByDeptId(empaccount.getDeptId())) != null) {
            loginUser.setDeptName(this.basDeptService.findByDeptId(empaccount.getDeptId()).getDeptName());
        }
        loginUser.setEmpDeptId(empaccount.getDeptId());
        if (loginUser.getEmpDeptId() != null) {
            loginUser.setEmpDeptName(this.basDeptService.findByDeptId(loginUser.getEmpDeptId()).getDeptName());
        }
        loginUser.setEmpOrgId(empaccount.getOrgId());
        if (loginUser.getEmpOrgId() != null) {
            org = this.basOrgService.findByOrgId(loginUser.getEmpOrgId());
            loginUser.setEmpOrgName(org.getOrgName());
            if (org.getBelongDept() != null) {
                loginUser.setBusinessUnitId(org.getBelongDept());
                BasDept belongedept = this.basDeptService.findByDeptId(org.getBelongDept());
                if (belongedept != null) {
                    loginUser.setBusinessUnitOrgId(belongedept.getOrgId());
                }
            } else {
                loginUser.setBusinessUnitId(loginUser.getDeptid());
                loginUser.setBusinessUnitOrgId(loginUser.getOrgid());
            }
            session.setAttribute("isGroup", (Object)loginUser.getEmpOrgId().equals(10000000L));
        }
        loginUser.setAccountList(accountList);
        loginUser.setWebIMServer(this.WebIMServer);
        try {
            byte[] textByte = String.valueOf(loginAccountid).getBytes("UTF-8");
            loginUser.setErpUser(Base64.getEncoder().encodeToString(textByte));
        }
        catch (UnsupportedEncodingException e) {
            this.loger.error((Object)"erp\u8f6c\u7801\u5931\u8d25");
        }
        session.setAttribute("LOGIN_USER", (Object)loginUser);
        BasSysLoginlog basSysLoginlog = new BasSysLoginlog();
        basSysLoginlog.setSessionId(session.getId());
        basSysLoginlog.setAccountId(loginUser.getAccountid());
        basSysLoginlog.setEmpId(loginUser.getEmpid());
        basSysLoginlog.setLoginTime(new Date());
        basSysLoginlog.setLoginType("1");
        basSysLoginlog.setLoginIp(ip);
        this.basSysLoginlogDao.save(basSysLoginlog);
        return loginUser;
    }

    public boolean isPasswordValid(String password) {
        if (this.getInitPassword()) {
            String reg = "^(?![0-9]+$)(?![a-zA-Z]+$)(?!\\W+$)\\S{8,16}$";
            return password.matches(reg);
        }
        return true;
    }

    private boolean getInitPassword() {
        return initPassword;
    }

    public List<ComboxNode> getDicComboWithPart(String typeCode, String includeValue) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)typeCode)) {
            params.put("typeCode", typeCode);
        }
        if (!StringUtils.isEmpty((String)includeValue)) {
            params.put("includeValue", includeValue);
        }
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("sys.BasDic.getDicComboWithPart", params);
        return ComboxUtils.buildComboxNodes(list);
    }

    public List<ComboxNode> findPayAndReceiveBills() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("sys.BasDic.findPayAndReceiveBills", params);
        return ComboxUtils.buildComboxNodes(list);
    }
}

