/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import com.guochuang.imp.base.common.util.NativeSqlHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.dao.BasUserFeedbackDao;
import com.guochuang.imp.base.entity.BasUserFeedback;
import com.guochuang.imp.base.service.CommonService;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasUserFeedbackService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private BasUserFeedbackDao basuserfeedbackDao;

    public BasUserFeedback findBasUserFeedback(Long id) {
        BasUserFeedback entity = (BasUserFeedback)this.basuserfeedbackDao.findById(id).get();
        return entity;
    }

    public void saveBasUserFeedback(BasUserFeedback entity) {
        this.basuserfeedbackDao.save(entity);
    }

    public void delBasUserFeedback(Long id) {
        BasUserFeedback entity = (BasUserFeedback)this.basuserfeedbackDao.findById(id).get();
        entity.setIsUse("N");
        this.basuserfeedbackDao.save(entity);
    }

    public PageObject PageAllByAccountId(Long accountid, String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select t.USER_FEEDBACK_ID,t.TOPIC_NAME,t.BROWSER_VERSION,t.CONTACTS_WAY,t.FEEDBACK_OPINION,t.CONTACT_WAY,t.PROCESS_STATUS,t.PROCESS_RESULT,DATE_FORMAT(t.FEEDBACK_DATE,'%Y-%m-%d %H:%i:%s') as FEEDBACK_DATE,DATE_FORMAT(t.PROCESS_DATE,'%Y-%m-%d %H:%i:%s') as PROCESS_DATE,a.account_name,b.account_name PROCESS_MAN_NAME from BAS_USER_FEEDBACK t left join bas_emp_account a on t.login_account_id=a.account_id left join bas_emp_account b on t.PROCESS_MAN=b.account_id where t.is_use=:isUse and t.LOGIN_ACCOUNT_ID=:accountid ");
        params.put("isUse", "Y");
        params.put("accountid", accountid);
        if (!StringUtils.isEmpty((String)search)) {
            sql.append("and  (");
            sql.append("  upper(t.USER_FEEDBACK_ID) like :search ");
            sql.append(" or upper(t.LOGIN_ACCOUNT_ID) like :search ");
            sql.append(" or upper(t.TOPIC_NAME) like :search ");
            sql.append(" or upper(t.BROWSER_VERSION) like :search ");
            sql.append(" or upper(t.FEEDBACK_DATE) like :search ");
            sql.append(" or upper(t.FEEDBACK_OPINION) like :search ");
            sql.append(" or upper(t.CONTACT_WAY) like :search ");
            sql.append(" or upper(t.PROCESS_MAN) like :search ");
            sql.append(" or upper(t.PROCESS_DATE) like :search ");
            sql.append(" or upper(t.PROCESS_RESULT) like :search ");
            sql.append(" or upper(t.PROCESS_STATUS) like :search ");
            sql.append(" or upper(t.VIEW_STATE) like :search ");
            sql.append(" or upper(t.IS_USE) like :search ");
            sql.append(" or upper(t.CONTACTS_WAY) like :search ");
            sql.append(")");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by t.FEEDBACK_DATE desc");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public PageObject PageAll(String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select t.USER_FEEDBACK_ID,t.TOPIC_NAME,t.BROWSER_VERSION,t.CONTACTS_WAY, CASE t.CONTACTS_WAY WHEN 1 THEN '\u5c40\u57df\u7f51\u8bbf\u95ee' WHEN 2 THEN '\u4e92\u8054\u7f51\u8bbf\u95ee' ELSE '' END AS CONTACTS_WAY_TEXT,t.FEEDBACK_OPINION,t.CONTACT_WAY,t.PROCESS_STATUS,t.PROCESS_RESULT,CASE t.PROCESS_STATUS WHEN 1 THEN '\u672a\u5904\u7406' WHEN 2 THEN '\u5904\u7406\u4e2d' WHEN 3 THEN '\u5df2\u5904\u7406' ELSE '' END AS PROCESS_STATUS_TEXT,DATE_FORMAT(t.FEEDBACK_DATE,'%Y-%m-%d %H:%i:%s') as FEEDBACK_DATE,DATE_FORMAT(t.PROCESS_DATE,'%Y-%m-%d %H:%i:%s') as PROCESS_DATE,a.account_name,b.account_name PROCESS_MAN_NAME from BAS_USER_FEEDBACK t left join bas_emp_account a on t.login_account_id=a.account_id left join bas_emp_account b on t.PROCESS_MAN=b.account_id where t.is_use=:isUse ");
        params.put("isUse", "Y");
        if (!StringUtils.isEmpty((String)search)) {
            sql.append("and  (");
            sql.append(" upper(t.TOPIC_NAME) like :search ");
            sql.append(" or upper(a.account_name) like :search ");
            sql.append(" or upper(b.account_name) like :search ");
            sql.append(" or upper(t.BROWSER_VERSION) like :search ");
            sql.append(" or upper(t.FEEDBACK_DATE) like :search ");
            sql.append(" or upper(t.FEEDBACK_OPINION) like :search ");
            sql.append(" or upper(t.CONTACT_WAY) like :search ");
            sql.append(" or upper(t.PROCESS_DATE) like :search ");
            sql.append(" or upper(t.PROCESS_RESULT) like :search ");
            sql.append(")");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by t.USER_FEEDBACK_ID desc");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }
}

