/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.common.util.MemCache;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.base.dao.BasUkeyDao;
import com.guochuang.imp.base.entity.BasUkey;
import com.guochuang.imp.base.service.BasEmpAccountService;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import com.guochuang.imp.util.StringUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class BasUkeyService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasUkeyDao basUkeyDao;
    @Autowired
    private BasEmpAccountService basEmpAccountService;

    public PageObject pageAll(String fuzzy, String produceDateStart, String produceDateEnd, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtil.isEmpty(fuzzy)) {
            params.put("fuzzy", "%" + fuzzy + "%");
        }
        if (!StringUtil.isEmpty(produceDateStart)) {
            params.put("produceDateStart", produceDateStart);
        }
        if (!StringUtil.isEmpty(produceDateEnd)) {
            params.put("produceDateEnd", produceDateEnd);
        }
        if (!StringUtil.isEmpty(sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtil.isEmpty(order)) {
            params.put("order", order);
        }
        PageObject<Map<String, Object>> pageObject = this.bSqlHelper.serachPage("base.BasUkey.pageAll", params, PageRequest.of((int)page, (int)rows));
        for (Map<String, Object> map : pageObject.getRows()) {
            map.put("isEnableText", MemCache.getDicText("IS_OR_NOT", StringUtil.null2String(map.get("isEnable"))));
        }
        return pageObject;
    }

    @Transactional
    public JsonMsg saveBasUkey(BasUkey entity, Boolean isChangeOwnUser) {
        Subject currentUser = SecurityUtils.getSubject();
        if (!currentUser.hasRole("admin")) {
            return new JsonMsg(false, "\u9700\u8981\u7ba1\u7406\u5458\u6743\u9650\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\uff01");
        }
        String deviceChipId = entity.getDeviceChipId();
        if (entity.getUkeyId() != null) {
            boolean isRepeat;
            String newDeviceChipId;
            BasUkey basUkey = this.findBasUkey(entity.getUkeyId());
            String oldDeviceChipId = basUkey.getDeviceChipId();
            if (!oldDeviceChipId.equals(newDeviceChipId = entity.getDeviceChipId()) && (isRepeat = this.deviceChipIdRepeat(deviceChipId))) {
                return new JsonMsg(false, "\u8bbe\u5907\u82af\u7247id\u91cd\u590d\uff01");
            }
        } else {
            boolean isRepeat = this.deviceChipIdRepeat(deviceChipId);
            if (isRepeat) {
                return new JsonMsg(false, "\u8bbe\u5907\u82af\u7247id\u91cd\u590d\uff01");
            }
            entity.setCreateAccount(SysUtils.getLoginAccountId());
            entity.setCreateTime(new Date());
        }
        entity.setIsUse("Y");
        this.basUkeyDao.save(entity);
        return new JsonMsg();
    }

    public BasUkey findBasUkey(Long id) {
        BasUkey entity = (BasUkey)this.basUkeyDao.findById(id).get();
        return entity;
    }

    public JsonMsg delBasUkey(Long id) {
        Subject currentUser = SecurityUtils.getSubject();
        if (!currentUser.hasRole("admin")) {
            return new JsonMsg(false, "\u9700\u8981\u7ba1\u7406\u5458\u6743\u9650\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\uff01");
        }
        BasUkey entity = (BasUkey)this.basUkeyDao.findById(id).get();
        entity.setIsUse("N");
        this.basUkeyDao.save(entity);
        return new JsonMsg();
    }

    public boolean deviceChipIdRepeat(String deviceChipId) {
        if (StringUtil.isEmpty(deviceChipId)) {
            return false;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("deviceChipId", deviceChipId);
        PageObject<BasUkey> basUkeyPageObject = this.bSqlHelper.searchPage("base.BasUkey.selectBydeviceChipId", map, BasUkey.class, PageRequest.of((int)1, (int)1));
        List<BasUkey> rows = basUkeyPageObject.getRows();
        return rows.size() > 0;
    }

    public JsonMsg enableUkey(Long uKeyId) {
        Subject currentUser = SecurityUtils.getSubject();
        if (!currentUser.hasRole("admin")) {
            return new JsonMsg(false, "\u9700\u8981\u7ba1\u7406\u5458\u6743\u9650\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\uff01");
        }
        Optional byId = this.basUkeyDao.findById(uKeyId);
        BasUkey one = (BasUkey)byId.get();
        one.setIsEnable("Y");
        one.setModifyAccount(SysUtils.getLoginAccountId());
        one.setModifyTime(new Date());
        this.basUkeyDao.save(one);
        return new JsonMsg();
    }

    public BasUkey findBasUkeyByDeviceChipId(String deviceChipId) {
        return this.basUkeyDao.findBasUkeyByDeviceChipIdAndIsUseAndIsEnable(deviceChipId, "Y", "Y");
    }
}

