/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import com.guochuang.imp.base.common.CronTask.CronTaskRegistrar;
import com.guochuang.imp.base.common.CronTask.SchedulingRunnable;
import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.dao.BasTimedTaskDao;
import com.guochuang.imp.base.entity.BasTimedTask;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.beetl.sql.core.SQLManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasTimedTaskService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasTimedTaskDao basTimedTaskDao;
    @Autowired
    private CronTaskRegistrar cronTaskRegistrar;
    @Autowired
    SQLManager sqlManager;

    public BasTimedTask findBasTimedTask(Long id) {
        BasTimedTask entity = (BasTimedTask)this.basTimedTaskDao.findById(id).get();
        return entity;
    }

    public void saveBasTimedTask(BasTimedTask entity) {
        this.basTimedTaskDao.save(entity);
        if (entity.getTaskAble().equals("Y")) {
            this.addTimedTask(entity.getClassName(), entity.getMethodName(), entity.getTaskId(), entity.getTimingExpression());
        }
    }

    public void delBasTimedTask(Long id) {
        BasTimedTask entity = (BasTimedTask)this.basTimedTaskDao.findById(id).get();
        entity.setIsUse("N");
        this.basTimedTaskDao.save(entity);
        this.removeTimedTask(id);
    }

    public void doOnceBasTimedTask(Long id, String className, String methodName, HttpServletRequest request) throws InterruptedException {
        SchedulingRunnable taskmaterial = new SchedulingRunnable(className, methodName, id);
        this.cronTaskRegistrar.addCronTask("BasTimedTaskTemp" + id, (Runnable)taskmaterial, new Date());
        Thread.sleep(1000L);
    }

    public void optionUseBasTimedTask(Long taskId, String option) {
        BasTimedTask entity = (BasTimedTask)this.basTimedTaskDao.findById(taskId).get();
        entity.setTaskAble(option);
        this.basTimedTaskDao.save(entity);
        if (option.equals("Y")) {
            this.addTimedTask(entity.getClassName(), entity.getMethodName(), entity.getTaskId(), entity.getTimingExpression());
        } else {
            this.removeTimedTask(taskId);
        }
    }

    public PageObject PageAll(String search, String isAbleOrNo, String startDate, String endDate, String applyPerson, String applyDept, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)isAbleOrNo)) {
            params.put("isAbleOrNo", isAbleOrNo);
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        if (!StringUtils.isEmpty((String)startDate)) {
            params.put("startDate", startDate);
        }
        if (!StringUtils.isEmpty((String)endDate)) {
            params.put("endDate", endDate);
        }
        if (!StringUtils.isEmpty((String)applyPerson)) {
            params.put("applyPerson", "%" + applyPerson.toUpperCase().replace("%", "/%") + "%");
        }
        if (applyDept != null) {
            params.put("applyDept", applyDept);
        }
        return this.bSqlHelper.serachPage("base.BasTimedTask.select", params, PageRequest.of((int)page, (int)rows));
    }

    @PostConstruct
    public void inttExcuteTimedTask() throws InterruptedException {
        List<BasTimedTask> list = this.bSqlHelper.getList("base.BasTimedTask.selectByTaskAble", new HashMap<String, Object>(), BasTimedTask.class);
        for (int i = 0; i < list.size(); ++i) {
            BasTimedTask task = list.get(i);
            if (!task.getTaskAble().equals("Y")) continue;
            this.addTimedTask(task.getClassName(), task.getMethodName(), task.getTaskId(), task.getTimingExpression());
        }
    }

    public void addTimedTask(String className, String methodName, Long taskId, String timingExpression) {
        SchedulingRunnable taskmaterial = new SchedulingRunnable(className, methodName, taskId);
        this.cronTaskRegistrar.addCronTask("BasTimedTask" + taskId, (Runnable)taskmaterial, timingExpression);
    }

    public void removeTimedTask(Long taskId) {
        this.cronTaskRegistrar.removeCronTask("BasTimedTask" + taskId);
    }

    public void testTaskDemo() {
        System.out.println("\u6b63\u5728\u6267\u884ctestTaskDemo---" + System.currentTimeMillis());
    }

    public void testTaskDemo2() {
        System.out.println("testTaskDemo2\u6267\u884c\u4e2d---" + System.currentTimeMillis());
    }

    public void testTaskDemo3() {
        System.out.println("----\u6267\u884ctestTaskDemo3\u4e2d---" + System.currentTimeMillis());
    }
}

