/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.dao.BasTemplateDao;
import com.guochuang.imp.base.dao.BasTemplateDsDao;
import com.guochuang.imp.base.entity.BasTemplate;
import com.guochuang.imp.base.entity.BasTemplateDs;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import com.guochuang.imp.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class BasTemplateService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasTemplateDao basTemplateDao;
    @Autowired
    private BasTemplateDsDao basTemplateDsDao;

    public PageObject pageAll(String fuzzy, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtil.isEmpty(fuzzy)) {
            params.put("fuzzy", "%" + fuzzy + "%");
        }
        if (!StringUtil.isEmpty(sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtil.isEmpty(order)) {
            params.put("order", order);
        }
        PageObject<Map<String, Object>> pageObject = this.bSqlHelper.serachPage("base.BasTemplate.pageAll", params, PageRequest.of((int)page, (int)rows));
        return pageObject;
    }

    @Transactional
    public void saveBasTemplate(BasTemplate entity) {
        if (ObjectUtils.isNotEmpty((Object)entity.getTemplateId())) {
            this.basTemplateDao.save(entity);
        } else {
            entity.setEnable("N");
            this.basTemplateDao.save(entity);
        }
    }

    public BasTemplate findBasTemplate(Long id) {
        BasTemplate entity = (BasTemplate)this.basTemplateDao.findById(id).get();
        return entity;
    }

    public void delBasTemplate(Long id) {
        BasTemplate entity = (BasTemplate)this.basTemplateDao.findById(id).get();
        entity.setIsUse("N");
        this.basTemplateDao.save(entity);
    }

    public void enableTemplate(Long id, String enable) {
        BasTemplate entity = (BasTemplate)this.basTemplateDao.findById(id).get();
        entity.setEnable(enable);
        this.basTemplateDao.save(entity);
    }

    public void enableTemplate(Map<String, Object> params, Long templateId) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        BasTemplate entity = (BasTemplate)this.basTemplateDao.findById(templateId).get();
        List<BasTemplateDs> dss = this.basTemplateDsDao.findByTemplateIdAndIsUse(templateId, "Y");
        for (BasTemplateDs ds : dss) {
            if ("1".equals(ds.getDsType())) {
                List<Map<String, Object>> list = this.bSqlHelper.serachBySql(ds.getSqlScript(), params);
                data.put(ds.getDsName(), list != null && !list.isEmpty() ? list.get(0) : null);
                continue;
            }
            data.put(ds.getDsName(), this.bSqlHelper.serachBySql(ds.getSqlScript(), params));
        }
    }
}

