/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.ComBoxTreeNode;
import com.guochuang.imp.base.common.util.DataSourceutil;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.dao.BasTemplateDsDao;
import com.guochuang.imp.base.entity.BasTemplateDs;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import com.guochuang.imp.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Component
public class BasTemplateDsService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasTemplateDsDao basTemplateDsDao;
    @Autowired
    private DataSourceutil dataSourceutil;
    private static final Logger logger = Logger.getLogger(BasTemplateDsService.class);

    public PageObject pageAll(int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtil.isEmpty(sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtil.isEmpty(order)) {
            params.put("order", order);
        }
        PageObject<Map<String, Object>> pageObject = this.bSqlHelper.serachPage("base.BasTemplateDs.pageAll", params, PageRequest.of((int)page, (int)rows));
        return pageObject;
    }

    @Transactional
    public void saveBasTemplateDs(BasTemplateDs entity) {
        this.basTemplateDsDao.save(entity);
    }

    public BasTemplateDs findBasTemplateDs(Long id) {
        BasTemplateDs entity = (BasTemplateDs)this.basTemplateDsDao.findById(id).get();
        return entity;
    }

    public void delBasTemplateDs(Long id) {
        BasTemplateDs entity = (BasTemplateDs)this.basTemplateDsDao.findById(id).get();
        entity.setIsUse("N");
        this.basTemplateDsDao.save(entity);
    }

    public Object treeBasTemplateDs(Long templateId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("templateId", templateId);
        List<Map<String, Object>> dslistMap = this.bSqlHelper.getMapList("base.BasTemplateDs.getDisList", params);
        ArrayList<ComBoxTreeNode> treeList = new ArrayList<ComBoxTreeNode>(dslistMap.size());
        for (Map<String, Object> ds : dslistMap) {
            ComBoxTreeNode node = new ComBoxTreeNode();
            node.setId(ds.get("id").toString());
            node.setText(ds.get("dsName").toString());
            node.setState("closed");
            node.setIconCls("icon-datasource");
            if (ds.get("sqlScript") != null) {
                logger.info((Object)("[\u89e3\u6790sql\u5b57\u6bb5]\uff1a\n" + ds.get("sqlScript")));
                Map<String, Map<String, Object>> sqlcolumns = this.dataSourceutil.getColunms(ds.get("sqlScript").toString());
                for (String field : sqlcolumns.keySet()) {
                    ComBoxTreeNode child = new ComBoxTreeNode();
                    child.setId("");
                    child.setText(field);
                    child.setIconCls("icon-field");
                    node.addChild(child);
                }
            }
            treeList.add(node);
        }
        return treeList;
    }

    public Object treeBasTemplateDsWithoutId(List<BasTemplateDs> dsList, BasTemplateDs entity) {
        if (ObjectUtils.isEmpty(dsList)) {
            dsList = new ArrayList<BasTemplateDs>();
        }
        dsList.add(entity);
        ArrayList<ComBoxTreeNode> treeList = new ArrayList<ComBoxTreeNode>(dsList.size());
        for (BasTemplateDs ds : dsList) {
            ComBoxTreeNode node = new ComBoxTreeNode();
            node.setText(ds.getDsName().toString());
            node.setState("closed");
            node.setIconCls("icon-datasource");
            if (ds.getSqlScript() != null) {
                logger.info((Object)("[\u89e3\u6790sql\u5b57\u6bb5]\uff1a\n" + ds.getSqlScript()));
                Map<String, Map<String, Object>> sqlcolumns = this.dataSourceutil.getColunms(ds.getSqlScript().toString());
                for (String field : sqlcolumns.keySet()) {
                    ComBoxTreeNode child = new ComBoxTreeNode();
                    child.setId(field);
                    child.setText(field);
                    child.setIconCls("icon-field");
                    node.addChild(child);
                }
            }
            treeList.add(node);
        }
        return treeList;
    }
}

