/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONObject;
import com.guochuang.imp.base.common.support.SysConfigEnum;
import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.common.util.LoginUser;
import com.guochuang.imp.base.common.util.MemCache;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.base.dao.BasSystemConfigDao;
import com.guochuang.imp.base.entity.BasDic;
import com.guochuang.imp.base.entity.BasSystemConfig;
import com.guochuang.imp.base.service.BasDicService;
import com.guochuang.imp.base.service.MemCacheService;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import com.guochuang.imp.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Component
public class BasSystemConfigService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasSystemConfigDao basSystemConfigDao;
    @Autowired
    private MemCacheService memCacheService;
    @Autowired
    private BasDicService basDicService;

    public PageObject pageAll(int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtil.isEmpty(sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtil.isEmpty(order)) {
            params.put("order", order);
        }
        PageObject<Map<String, Object>> pageObject = this.bSqlHelper.serachPage("base.BasSystemConfig.pageAll", params, PageRequest.of((int)page, (int)rows));
        return pageObject;
    }

    public Object getAllData() {
        ArrayList configAppendList = new ArrayList();
        List<SysConfigEnum> list = Arrays.stream(SysConfigEnum.values()).collect(Collectors.toList());
        list.forEach(x -> {
            BasSystemConfig basSystemConfig;
            String code = x.getCode();
            String name = x.getName();
            String dicCode = x.getDicCode();
            String groupName = x.getGroupName();
            String desc = x.getDesc();
            String configContent = MemCache.SysConfigMap.get(code);
            if (StringUtil.isEmpty(configContent) && !ObjectUtils.isEmpty((Object)(basSystemConfig = this.basSystemConfigDao.findByConfigCodeAndIsUse(code, "Y")))) {
                configContent = basSystemConfig.getConfigContent();
            }
            HashMap<String, String> newConfig = new HashMap<String, String>();
            newConfig.put("configDicCode", dicCode);
            newConfig.put("configGroupName", groupName);
            newConfig.put("configDesc", desc);
            newConfig.put("configCode", code);
            newConfig.put("configName", name);
            newConfig.put("configContent", configContent);
            newConfig.put("isEnable", "Y");
            newConfig.put("isUse", "Y");
            newConfig.put("configType", "new");
            configAppendList.add(newConfig);
        });
        return configAppendList;
    }

    @Transactional
    public void saveBasSystemConfig(BasSystemConfig entity) {
        this.basSystemConfigDao.save(entity);
        this.memCacheService.setSysConfigCache();
    }

    public List<BasSystemConfig> saveBasSystemConfigByJsonStr(String configs, LoginUser loginUser) {
        ArrayList<BasSystemConfig> result = new ArrayList<BasSystemConfig>();
        List configList = JSONObject.parseArray((String)configs, JSONObject.class);
        if (configList == null || configList.size() == 0) {
            return result;
        }
        for (int i = 0; i < configList.size(); ++i) {
            BasSystemConfig basSystemConfig;
            if ("new".equals(((JSONObject)configList.get(i)).get((Object)"configType").toString())) {
                MemCache.SysConfigMap.put(StringUtil.null2String(((JSONObject)configList.get(i)).get((Object)"configCode")), StringUtil.null2String(((JSONObject)configList.get(i)).get((Object)"configContent")));
                basSystemConfig = new BasSystemConfig();
                basSystemConfig.setConfigCode(((JSONObject)configList.get(i)).get((Object)"configCode").toString());
                basSystemConfig.setConfigName(((JSONObject)configList.get(i)).get((Object)"configName").toString());
                basSystemConfig.setConfigContent(((JSONObject)configList.get(i)).get((Object)"configContent").toString());
                basSystemConfig.setIsEnable("Y");
                basSystemConfig.setIsUse("Y");
                basSystemConfig.setCreateTime(new Date());
                basSystemConfig.setCreateAccount(loginUser.getAccountid());
                basSystemConfig.setModifyTime(new Date());
                basSystemConfig.setModifyAccount(loginUser.getAccountid());
                this.basSystemConfigDao.save(basSystemConfig);
                result.add(basSystemConfig);
                continue;
            }
            if ("edit".equals(((JSONObject)configList.get(i)).get((Object)"configType").toString())) {
                MemCache.SysConfigMap.put(StringUtil.null2String(((JSONObject)configList.get(i)).get((Object)"configCode")), StringUtil.null2String(((JSONObject)configList.get(i)).get((Object)"configContent")));
                basSystemConfig = this.findBasSystemConfig(Long.parseLong(((JSONObject)configList.get(i)).get((Object)"id").toString()));
                basSystemConfig.setConfigCode(((JSONObject)configList.get(i)).get((Object)"configCode").toString());
                basSystemConfig.setConfigName(((JSONObject)configList.get(i)).get((Object)"configName").toString());
                basSystemConfig.setConfigContent(((JSONObject)configList.get(i)).get((Object)"configContent").toString());
                basSystemConfig.setIsEnable(((JSONObject)configList.get(i)).get((Object)"isEnable").toString());
                basSystemConfig.setIsUse(((JSONObject)configList.get(i)).get((Object)"isUse").toString());
                basSystemConfig.setModifyTime(new Date());
                basSystemConfig.setModifyAccount(loginUser.getAccountid());
                this.basSystemConfigDao.save(basSystemConfig);
                result.add(basSystemConfig);
                continue;
            }
            if (!"del".equals(((JSONObject)configList.get(i)).get((Object)"configType").toString()) && !"enable".equals(((JSONObject)configList.get(i)).get((Object)"configType").toString())) continue;
        }
        return result;
    }

    public BasSystemConfig findBasSystemConfig(Long id) {
        BasSystemConfig entity = (BasSystemConfig)this.basSystemConfigDao.findById(id).get();
        return entity;
    }

    public void delBasSystemConfig(Long id) {
        BasSystemConfig entity = (BasSystemConfig)this.basSystemConfigDao.findById(id).get();
        entity.setIsUse("N");
        this.memCacheService.setSysConfigCache();
        this.basSystemConfigDao.save(entity);
    }

    public void saveBasSystemConfigFlow(String enableSet, String userSet) {
        BasSystemConfig entity;
        Long accountId = SysUtils.getLoginAccountId();
        if (StringUtil.isNotEmpty(enableSet)) {
            entity = this.basSystemConfigDao.findByConfigCodeAndIsUse("MESSAGE_DEADLINE_ENABLE", "Y");
            if (entity == null) {
                entity = new BasSystemConfig();
                entity.setCreateAccount(accountId);
                entity.setCreateTime(new Date());
                entity.setConfigCode("MESSAGE_DEADLINE_ENABLE");
                entity.setConfigName("\u542f\u7528\u6d41\u7a0b\u65f6\u9650\u8bbe\u7f6e");
                entity.setConfigContent(enableSet);
                entity.setIsEnable("Y");
                entity.setIsUse("Y");
            } else {
                entity.setConfigContent(enableSet);
                entity.setModifyAccount(accountId);
                entity.setModifyTime(new Date());
            }
            this.basSystemConfigDao.save(entity);
        }
        if (StringUtil.isNotEmpty(userSet)) {
            entity = this.basSystemConfigDao.findByConfigCodeAndIsUse("MESSAGE_DEADLINE_USER_DEFINED", "Y");
            if (entity == null) {
                entity = new BasSystemConfig();
                entity.setCreateAccount(accountId);
                entity.setCreateTime(new Date());
                entity.setConfigCode("MESSAGE_DEADLINE_USER_DEFINED");
                entity.setConfigName("\u5141\u8bb8\u7528\u6237\u81ea\u5b9a\u4e49\u6d41\u7a0b\u65f6\u9650\u8bbe\u7f6e");
                entity.setConfigContent(userSet);
                entity.setIsEnable("Y");
                entity.setIsUse("Y");
            } else {
                entity.setConfigContent(userSet);
                entity.setModifyAccount(accountId);
                entity.setModifyTime(new Date());
            }
            this.basSystemConfigDao.save(entity);
        }
    }

    public JsonMsg findBasSystemConfigFlow() {
        JsonMsg msg = new JsonMsg();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("enableSet", false);
        map.put("userSet", false);
        BasSystemConfig enableEntity = this.basSystemConfigDao.findByConfigCodeAndIsUse("MESSAGE_DEADLINE_ENABLE", "Y");
        BasSystemConfig userEntity = this.basSystemConfigDao.findByConfigCodeAndIsUse("MESSAGE_DEADLINE_USER_DEFINED", "Y");
        if (enableEntity != null) {
            map.put("enableSet", "Y".equals(enableEntity.getConfigContent()));
        }
        if (userEntity != null) {
            map.put("userSet", "Y".equals(userEntity.getConfigContent()));
        }
        msg.setO(map);
        return msg;
    }

    public List<BasDic> getDicInfo(String dicCode) {
        List<BasDic> dicList = this.basDicService.findByDicCode(dicCode);
        return dicList;
    }

    public List<BasSystemConfig> saveQueryVerifyDataByJsonStr(String configs, LoginUser loginUser) {
        ArrayList<BasSystemConfig> result = new ArrayList<BasSystemConfig>();
        List configList = JSONObject.parseArray((String)configs, JSONObject.class);
        if (configList == null || configList.size() == 0) {
            return result;
        }
        for (int i = 0; i < configList.size(); ++i) {
            BasSystemConfig basSystemConfig;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("code", ((JSONObject)configList.get(i)).get((Object)"configCode"));
            Map<String, Object> map = this.bSqlHelper.getMap("base.BasSystemConfig.getBasSystemConfigByCode", params);
            if (MapUtil.isNotEmpty(map)) {
                MemCache.SysConfigMap.put(StringUtil.null2String(((JSONObject)configList.get(i)).get((Object)"configCode")), StringUtil.null2String(((JSONObject)configList.get(i)).get((Object)"configContent")));
                basSystemConfig = this.findBasSystemConfig(Long.parseLong(map.get("id").toString()));
                basSystemConfig.setConfigCode(((JSONObject)configList.get(i)).get((Object)"configCode").toString());
                basSystemConfig.setConfigName(((JSONObject)configList.get(i)).get((Object)"configName").toString());
                basSystemConfig.setConfigContent(((JSONObject)configList.get(i)).get((Object)"configContent").toString());
                basSystemConfig.setIsEnable(((JSONObject)configList.get(i)).get((Object)"isEnable").toString());
                basSystemConfig.setIsUse(((JSONObject)configList.get(i)).get((Object)"isUse").toString());
                basSystemConfig.setModifyTime(new Date());
                basSystemConfig.setModifyAccount(loginUser.getAccountid());
                this.basSystemConfigDao.save(basSystemConfig);
                result.add(basSystemConfig);
                continue;
            }
            MemCache.SysConfigMap.put(StringUtil.null2String(((JSONObject)configList.get(i)).get((Object)"configCode")), StringUtil.null2String(((JSONObject)configList.get(i)).get((Object)"configContent")));
            basSystemConfig = new BasSystemConfig();
            basSystemConfig.setConfigCode(((JSONObject)configList.get(i)).get((Object)"configCode").toString());
            basSystemConfig.setConfigName(((JSONObject)configList.get(i)).get((Object)"configName").toString());
            basSystemConfig.setConfigContent(((JSONObject)configList.get(i)).get((Object)"configContent").toString());
            basSystemConfig.setIsEnable("Y");
            basSystemConfig.setIsUse("Y");
            basSystemConfig.setCreateTime(new Date());
            basSystemConfig.setCreateAccount(loginUser.getAccountid());
            basSystemConfig.setModifyTime(new Date());
            basSystemConfig.setModifyAccount(loginUser.getAccountid());
            this.basSystemConfigDao.save(basSystemConfig);
            result.add(basSystemConfig);
        }
        return result;
    }

    public BasSystemConfig getBasSysConfigByCode(String code) {
        return this.basSystemConfigDao.findByConfigCodeAndIsUse(code, "Y");
    }
}

