/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import cn.hutool.core.map.MapUtil;
import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.dao.BasSpaceComponentAssociatedDao;
import com.guochuang.imp.base.dao.BasSpaceComponentDefinitionDao;
import com.guochuang.imp.base.entity.BasSpaceComponentAssociated;
import com.guochuang.imp.base.entity.BasSpaceComponentDefinition;
import com.guochuang.imp.base.entity.GmInfoType;
import com.guochuang.imp.base.service.BasSpaceDefineService;
import com.guochuang.imp.base.service.GmInfoTypeService;
import com.guochuang.imp.report.entity.ReportBase;
import com.guochuang.imp.report.service.ReportBaseService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasSpaceComponentAssociatedService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasSpaceComponentAssociatedDao basspacecomponentassociatedDao;
    @Autowired
    private GmInfoTypeService gminfotypeService;
    @Autowired
    private BasSpaceComponentDefinitionDao basSpaceComponentDefinitionDao;
    @Autowired
    private BasSpaceDefineService basSpaceDefineService;
    @Autowired
    private ReportBaseService reportBaseService;

    public BasSpaceComponentAssociated findBasSpaceComponentAssociated(Long id) {
        BasSpaceComponentAssociated entity = null;
        Optional optional = this.basspacecomponentassociatedDao.findById(id);
        if (optional.isPresent()) {
            entity = (BasSpaceComponentAssociated)optional.get();
            String componentId = entity.getComponentId();
            String componentType = entity.getComponentType();
            String columnNames = "";
            if ("1".equals(componentType)) {
                if (componentId.indexOf(",") == -1) {
                    GmInfoType gmInfoType = this.gminfotypeService.findGmInfoType(Long.parseLong(componentId));
                    columnNames = columnNames + gmInfoType.getTypeName();
                } else {
                    String[] ids;
                    for (String cid : ids = componentId.split(",")) {
                        GmInfoType gmInfoType = this.gminfotypeService.findGmInfoType(Long.parseLong(cid));
                        columnNames = columnNames + gmInfoType.getTypeName() + " ";
                    }
                }
            } else if ("2".equals(componentType)) {
                if (componentId.indexOf(",") == -1) {
                    BasSpaceComponentDefinition basSpaceComponentDefinition = (BasSpaceComponentDefinition)this.basSpaceComponentDefinitionDao.findById(Long.parseLong(componentId)).get();
                    columnNames = columnNames + basSpaceComponentDefinition.getComponentName();
                } else {
                    String[] ids;
                    for (String cid : ids = componentId.split(",")) {
                        BasSpaceComponentDefinition basSpaceComponentDefinition = (BasSpaceComponentDefinition)this.basSpaceComponentDefinitionDao.findById(Long.parseLong(cid)).get();
                        columnNames = columnNames + basSpaceComponentDefinition.getComponentName() + " ";
                    }
                }
            } else if (componentId.indexOf(",") == -1) {
                ReportBase report = this.reportBaseService.findReportBase(Long.parseLong(componentId));
                columnNames = columnNames + report.getReportName();
            } else {
                String[] ids;
                for (String cid : ids = componentId.split(",")) {
                    ReportBase report = this.reportBaseService.findReportBase(Long.parseLong(cid));
                    columnNames = columnNames + report.getReportName() + " ";
                }
            }
            entity.setComponentName(columnNames);
        }
        return entity;
    }

    public void saveBasSpaceComponentAssociated(BasSpaceComponentAssociated entity) {
        this.basspacecomponentassociatedDao.save(entity);
    }

    public void delBasSpaceComponentAssociated(Long id) {
        BasSpaceComponentAssociated entity = (BasSpaceComponentAssociated)this.basspacecomponentassociatedDao.findById(id).get();
        entity.setIsUse("N");
        this.basspacecomponentassociatedDao.save(entity);
    }

    public List<Map<String, Object>> findBySpaceId(Long spaceId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (spaceId != null) {
            params.put("spaceId", spaceId);
        }
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasSpaceComponentAssociated.findBySpaceId", params);
        for (Map<String, Object> map : list) {
            String[] ids;
            String componentId = (String)map.get("componentId");
            String columnNames = "";
            if ("1".equals(map.get("componentType").toString())) {
                if (componentId.indexOf(",") == -1) {
                    GmInfoType gmInfoType = this.gminfotypeService.findGmInfoType(Long.parseLong(componentId));
                    columnNames = columnNames + gmInfoType.getTypeName();
                } else {
                    for (String id : ids = componentId.split(",")) {
                        GmInfoType gmInfoType = this.gminfotypeService.findGmInfoType(Long.parseLong(id));
                        columnNames = columnNames + gmInfoType.getTypeName() + " ";
                    }
                }
                map.put("componentName", columnNames);
                continue;
            }
            if ("2".equals(map.get("componentType").toString())) {
                if (componentId.indexOf(",") == -1) {
                    BasSpaceComponentDefinition basSpaceComponentDefinition = (BasSpaceComponentDefinition)this.basSpaceComponentDefinitionDao.findById(Long.parseLong(componentId)).get();
                    columnNames = columnNames + basSpaceComponentDefinition.getComponentName();
                    map.put("linkAddress", basSpaceComponentDefinition.getLinkAddress());
                } else {
                    for (String id : ids = componentId.split(",")) {
                        BasSpaceComponentDefinition basSpaceComponentDefinition = (BasSpaceComponentDefinition)this.basSpaceComponentDefinitionDao.findById(Long.parseLong(id)).get();
                        columnNames = columnNames + basSpaceComponentDefinition.getComponentName() + " ";
                    }
                }
                map.put("componentName", columnNames);
                continue;
            }
            if (!"3".equals(map.get("componentType").toString())) continue;
            map.put("componentName", this.bSqlHelper.getStringValue("report.reportBase.getReportNameById", MapUtil.of((Object)"componentId", (Object)componentId)));
        }
        return list;
    }

    public void deleteBySpaceId(Long spaceId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (spaceId != null) {
            params.put("spaceId", spaceId);
        }
        this.bSqlHelper.updateOrDelete("base.BasSpaceComponentAssociated.deleteBySpaceId", params);
    }

    public Integer countInfoTypeIsOrNotUse(Long id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        int info = 0;
        List<BasSpaceComponentAssociated> list = this.bSqlHelper.getList("base.BasSpaceComponentAssociated.countInfoTypeIsOrNotUse", params, BasSpaceComponentAssociated.class);
        for (BasSpaceComponentAssociated associated : list) {
            String componentId = associated.getComponentId();
            if (componentId.indexOf(id + "") == -1) continue;
            info = 1;
            return info;
        }
        return info;
    }

    public Map<String, Object> findPublishScopeByTypeId(Long id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (id != null) {
            params.put("typeId", "%" + id + "%");
        }
        String userId = "";
        String userName = "";
        List<Map<String, Object>> mapList = this.bSqlHelper.getMapList("base.BasSpaceComponentAssociated.findPublishScopeByTypeId", params);
        for (Map<String, Object> map : mapList) {
            userId = userId + map.get("userType").toString() + ":" + map.get("userId").toString() + ",";
            userName = userName + map.get("userName").toString() + ",";
        }
        HashMap<String, Object> info = new HashMap<String, Object>();
        if (!mapList.isEmpty() && StringUtils.isNotBlank((String)userId)) {
            userId = userId.substring(0, userId.length() - 1);
            userName = userName.substring(0, userName.length() - 1);
            info.put("userId", userId);
            info.put("userName", userName);
        }
        return info;
    }
}

