/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.common.util.NativeSqlHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.common.util.StrKit;
import com.guochuang.imp.base.common.util.SysContent;
import com.guochuang.imp.base.dao.BasSendSmsDao;
import com.guochuang.imp.base.entity.BasSendSms;
import com.guochuang.imp.base.service.BasRolesAccountService;
import com.guochuang.imp.base.service.CommonService;
import com.guochuang.imp.webservice.sms.ISmsManagerService;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasSendSmsService {
    Logger loger = Logger.getLogger(BasSendSmsService.class);
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private BasSendSmsDao bassendsmsDao;
    @Autowired
    private BasRolesAccountService basRolesAccountService;
    @Autowired(required=false)
    private ISmsManagerService smsManagerService;

    public BasSendSms findBasSendSms(Long id) {
        BasSendSms entity = (BasSendSms)this.bassendsmsDao.findById(id).get();
        return entity;
    }

    public void saveBasSendSms(BasSendSms entity) {
        this.bassendsmsDao.save(entity);
    }

    public void delBasSendSms(Long id) {
        BasSendSms entity = (BasSendSms)this.bassendsmsDao.findById(id).get();
        entity.setIsUse("N");
        this.bassendsmsDao.save(entity);
    }

    public PageObject PageAll(String formcode, Long accountId, String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select t.*,a.account_name,date_format(t.SENDERTIME,'%Y-%m-%d %T') as sendtime_text_ from BAS_SEND_SMS t \n");
        sql.append(" left join bas_emp_account  a on t.sender=a.account_id \n");
        sql.append(" where t.is_use=:isUse \n");
        params.put("isUse", "Y");
        if (!SysContent.ADMIN_ACCOUNT_ID.equals(accountId)) {
            sql.append(" and t.sender = :accountId \n");
            params.put("accountId", accountId);
        }
        if (StrKit.notBlank(formcode)) {
            sql.append(" and t.form_code = :formcode \n");
            params.put("formcode", formcode);
        } else {
            sql.append(" and t.form_code is null \n");
        }
        if (!StrUtil.isEmpty((CharSequence)search)) {
            sql.append(" and  (");
            sql.append("  upper(t.SMS_ID) like :search ");
            sql.append(" or upper(t.SMS_CONTENT) like :search ");
            sql.append(" or upper(t.RECEIVER) like :search ");
            sql.append(" or upper(a.account_name) like :search ");
            sql.append(" or upper(t.SENDERTIME) like :search ");
            sql.append(" or upper(t.RESULT_CODE) like :search ");
            sql.append(" or upper(t.RESULT_MSG) like :search ");
            sql.append(" or upper(t.RECEIVER_NUMBER) like :search ");
            sql.append(" or upper(t.FORM_CODE) like :search ");
            sql.append(") ");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by t.SENDERTIME desc");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public JsonMsg sendSMS(BasSendSms sms) {
        this.bassendsmsDao.save(sms);
        JsonMsg jsonMsg = new JsonMsg();
        if (sms != null) {
            List numbers = StrUtil.split((CharSequence)sms.getReceiverNumber(), (CharSequence)",", (int)-1, (boolean)true, (boolean)true);
            List extnumbers = StrUtil.split((CharSequence)sms.getExtReceiverNumber(), (CharSequence)",", (int)-1, (boolean)true, (boolean)true);
            CollUtil.addAllIfNotContains((List)numbers, (List)extnumbers);
            if (numbers.size() > 0) {
                if (StrUtil.isNotEmpty((CharSequence)sms.getSmsContent())) {
                    JsonMsg msg = this.smsManagerService.sendSms(numbers, sms.getSmsContent());
                    sms.setResultMsg(msg.getMsg().toString());
                    sms.setResultCode(String.valueOf(msg.isSuccess()));
                    this.bassendsmsDao.save(sms);
                    return msg;
                }
                jsonMsg.setSuccess(false);
                jsonMsg.setMsg("\u77ed\u4fe1\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
                return jsonMsg;
            }
            jsonMsg.setSuccess(false);
            jsonMsg.setMsg("\u9009\u4e2d\u7684\u4eba\u5458\u4e2d\u6ca1\u6709\u624b\u673a\u53f7\u7801");
            return jsonMsg;
        }
        jsonMsg.setSuccess(false);
        jsonMsg.setMsg("\u6d88\u606f\u5bf9\u8c61\u4e3a\u7a7a");
        return jsonMsg;
    }

    public JsonMsg SendSmsMsg(String telephoneNums, String checkMonth, String msgTitleType, String ids, String formCode) {
        JsonMsg jsonMsg = new JsonMsg();
        if (telephoneNums != null) {
            List numbers = StrUtil.split((CharSequence)telephoneNums, (CharSequence)",", (int)-1, (boolean)true, (boolean)true);
            if (numbers.size() > 0) {
                String SmsContent = "";
                SmsContent = "\u8003\u6838\u6307\u6807".equals(msgTitleType) || "\u8003\u6838\u81ea\u8bc4".equals(msgTitleType) ? "\u60a8" + checkMonth + "\u6708\u7684" + msgTitleType + "\u672a\u5b8c\u6210,\u8bf7\u5c3d\u5feb\u5b8c\u6210" : msgTitleType;
                JsonMsg msg = this.smsManagerService.sendSms(numbers, SmsContent);
                return msg;
            }
            jsonMsg.setSuccess(false);
            jsonMsg.setMsg("\u9009\u4e2d\u7684\u4eba\u5458\u4e2d\u6ca1\u6709\u624b\u673a\u53f7\u7801");
            return jsonMsg;
        }
        jsonMsg.setSuccess(false);
        jsonMsg.setMsg("\u8bf7\u9009\u62e9\u8981\u53d1\u9001\u77ed\u4fe1\u7684\u7528\u6237!");
        return jsonMsg;
    }
}

