/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.common.util.NativeSqlHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.common.util.StrKit;
import com.guochuang.imp.base.dao.BasRolesDao;
import com.guochuang.imp.base.entity.BasRoles;
import com.guochuang.imp.base.service.BasEmpAccountService;
import com.guochuang.imp.base.service.BasRolesAccountService;
import com.guochuang.imp.base.service.CommonService;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasRolesService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private BasRolesDao basrolesDao;
    @Autowired
    private BasEmpAccountService basEmpAccountService;
    @Autowired
    private BasRolesAccountService basrolesaccountService;
    @Autowired
    private BeetlSQLHelper bSqlHelper;

    public List<BasRoles> findAll() {
        return this.basrolesDao.findByIsUse("Y");
    }

    public JsonMsg checkRepeat(BasRoles entity) {
        JsonMsg msg = new JsonMsg();
        List<BasRoles> list = this.basrolesDao.findByRoleNameAndIsUse(entity.getRoleName(), "Y");
        if (list.size() > 1) {
            msg.setSuccess(false);
            msg.setMsg("\u89d2\u8272\u540d\u79f0\u6709\u91cd\u590d,\u8bf7\u6838\u5bf9\u540e\u91cd\u65b0\u4fdd\u5b58");
        } else if (list.size() == 1 && !list.get(0).getRoleId().equals(entity.getRoleId())) {
            msg.setSuccess(false);
            msg.setMsg("\u89d2\u8272\u540d\u79f0\u6709\u91cd\u590d,\u8bf7\u6838\u5bf9\u540e\u91cd\u65b0\u4fdd\u5b58");
        }
        return msg;
    }

    public BasRoles findBasRoles(Long id) {
        BasRoles entity = (BasRoles)this.basrolesDao.findById(id).get();
        return entity;
    }

    public void saveBasRoles(BasRoles entity) {
        this.basrolesDao.save(entity);
    }

    public PageObject PageAll(String roleType, Long orgid, String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuffer sql = new StringBuffer("select * from BAS_ROLES t where  t.is_use=:isUse \n");
        params.put("isUse", "Y");
        if (StrKit.notBlank(roleType)) {
            sql.append(" and t.role_type in (:roleType) \n");
            params.put("roleType", Arrays.asList(roleType.split(",")));
        }
        if (!StringUtils.isEmpty((String)search)) {
            sql.append(" and (");
            sql.append("   upper(t.ROLE_NAME) like :search ");
            sql.append(" or  upper(t.ROLE_CODE) like :search ");
            sql.append(") ");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append("\torder by t.DISPLAY_NO ");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("ROLE_TYPE", "ROLE_TYPE");
        dicmapper.put("ROLE_ORIGIN", "ROLE_ORIGIN");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public PageObject PageAllocated(Long accountId, String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase().replace("%", "/%") + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        params.put("accountId", accountId);
        return this.bSqlHelper.serachPage("base.BasRoles.selectAllocate", params, PageRequest.of((int)page, (int)rows));
    }

    public String isRoleUseInFlow(Long roleId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("roleId", ">" + roleId);
        return this.bSqlHelper.getStringValue("base.BasRoles.getRolesFlow", params);
    }

    public Map<String, Object> findRoleLevelByAccountId(String ids) {
        int roleLevel = 10;
        long acc = 0L;
        long rorgId = 0L;
        HashMap<String, Object> obj = new HashMap<String, Object>();
        String[] idStr = null;
        if (ids == null || ids.length() <= 0) {
            return null;
        }
        idStr = ids.split(",");
        if (idStr != null && idStr.length > 0) {
            for (int i = 0; i < idStr.length; ++i) {
                long account = Long.parseLong(idStr[i]);
                List<Map<String, Object>> findRolesByAccountId = this.basrolesaccountService.findRolesByAccountId(account);
                long orgId = this.basEmpAccountService.findById(account).getOrgId();
                if (findRolesByAccountId == null || findRolesByAccountId.size() <= 0) continue;
                for (Map<String, Object> roelsBy : findRolesByAccountId) {
                    int level;
                    if (roelsBy.get("ROLE_LEVEL") == null || (level = Integer.parseInt(roelsBy.get("ROLE_LEVEL").toString())) != 3 && level != 5) continue;
                    if (orgId == 10000000L && (rorgId == 0L || rorgId == 10000000L) && level < roleLevel) {
                        roleLevel = level;
                        acc = account;
                        rorgId = orgId;
                    }
                    if (orgId != 10000000L && (rorgId == 0L || rorgId != 0L && rorgId != 10000000L) && level < roleLevel) {
                        roleLevel = level;
                        acc = account;
                        rorgId = orgId;
                    }
                    if (orgId == 10000000L || rorgId == 0L || rorgId == 0L || rorgId == 10000000L) {
                        // empty if block
                    }
                    if (orgId != 10000000L || rorgId != 0L && (rorgId == 0L || rorgId == 10000000L)) continue;
                    roleLevel = level;
                    acc = account;
                    rorgId = orgId;
                }
            }
        }
        if (rorgId == 0L) {
            return null;
        }
        obj.put("highestAccount", acc);
        obj.put("highestOrg", rorgId);
        obj.put("roleLevel", roleLevel);
        return obj;
    }

    public String getAllRoles() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        return this.bSqlHelper.getStringValue("base.BasRoles.getAllRoles", params);
    }

    public Map<String, Object> getRolesLevelByAccount(Long accountId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accountId", accountId);
        Map<String, Object> codeList = this.bSqlHelper.getMap("base.BasRoles.getRolesCodeByAccount", params);
        return codeList;
    }

    public BasRoles findByRoleCode(String roleCode) {
        return this.basrolesDao.findByRoleCodeAndIsUse(roleCode, "Y");
    }

    public Object pageBasEmpAccountData(String orgId, String search, int page, int rows) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)orgId)) {
            params.put("orgId", orgId);
        }
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        return this.bSqlHelper.serachPage("base.BasRoles.pageBasEmpAccountData", params, PageRequest.of((int)page, (int)rows));
    }

    public Object pageRolesDataByAccount(Long accountId, String search, int page, int rows) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (accountId != null) {
            params.put("accountId", accountId);
            return this.bSqlHelper.searchPage("base.BasRoles.pageRolesDataByAccount", params, PageRequest.of((int)page, (int)rows));
        }
        return this.bSqlHelper.searchPage("base.BasRoles.pageRolesDataAll", params, PageRequest.of((int)page, (int)rows));
    }

    public Object pageRolesMenuDataByAccount(Long accountId, String roleId, String roleSign, String search, int page, int rows) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (accountId != null) {
            params.put("accountId", accountId);
        }
        if (!StringUtils.isEmpty((String)roleId)) {
            params.put("roleId", roleId);
            return this.bSqlHelper.searchPage("base.BasRoles.pageRolesMenuDataByAccount", params, PageRequest.of((int)page, (int)rows));
        }
        return this.bSqlHelper.searchPage("base.BasRoles.pageRolesMenuDataAll", params, PageRequest.of((int)page, (int)rows));
    }

    public Object pageRolesButtonDataByAccount(Long accountId, String menuId, String search, int page, int rows) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)menuId)) {
            return null;
        }
        params.put("menuId", menuId);
        if (accountId != null) {
            params.put("accountId", accountId);
            return this.bSqlHelper.searchPage("base.BasRoles.pageRolesButtonDataByAccount", params, PageRequest.of((int)page, (int)rows));
        }
        return this.bSqlHelper.searchPage("base.BasRoles.pageRolesButtonDataByMenuId", params, PageRequest.of((int)page, (int)rows));
    }

    public Object pageRolesReferAccountData(String roleSign, String roleId, String search, int page, int rows) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)roleId)) {
            return null;
        }
        params.put("roleId", roleId);
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)roleSign)) {
            params.put("roleSign", roleSign);
        }
        return this.bSqlHelper.searchPage("base.BasRoles.pageRolesReferAccountData", params, PageRequest.of((int)page, (int)rows));
    }

    public Object pageMenuReferAccountData(String menuId, String search, int page, int rows) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)menuId)) {
            return null;
        }
        params.put("menuId", menuId);
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        return this.bSqlHelper.searchPage("base.BasRoles.pageMenuReferAccountData", params, PageRequest.of((int)page, (int)rows));
    }

    public Object pageMenuReferRolesData(String menuId, String search, int page, int rows) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)menuId)) {
            return null;
        }
        params.put("menuId", menuId);
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        return this.bSqlHelper.searchPage("base.BasRoles.pageMenuReferRolesData", params, PageRequest.of((int)page, (int)rows));
    }

    public List<Map<String, Object>> getRoleAccountByRoleId(Long id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("roleId", id);
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasRoles.getRoleAccountByRoleId", params);
        return list;
    }

    @Transactional
    public Object delBasRolesAndAccount(Long id) {
        String useFlows;
        BasRoles entity = this.findBasRoles(id);
        if (entity != null) {
            if ("1".equals(entity.getRoleOrigin())) {
                return new JsonMsg(false, "\u7cfb\u7edf\u9884\u7f6e\u89d2\u8272\u4e0d\u5141\u8bb8\u5220\u9664");
            }
            entity.setIsUse("N");
            this.saveBasRoles(entity);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("roleId", id);
            this.bSqlHelper.updateOrDelete("base.BasRoles.delRoleAccountByRoleId", params);
        }
        if (com.gexin.rp.sdk.base.uitls.StringUtils.isNotBlank((CharSequence)(useFlows = this.isRoleUseInFlow(id)))) {
            return new JsonMsg(false, "\u89d2\u8272\u5df2\u7ecf\u7528\u5728" + useFlows + "\u6d41\u7a0b\u4e2d\u4f7f\u7528,\u6682\u65f6\u4e0d\u80fd\u5220\u9664");
        }
        return new JsonMsg();
    }
}

