/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.dao.BasQuerySettingDao;
import com.guochuang.imp.base.entity.BasQuerySetting;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import com.guochuang.imp.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class BasQuerySettingService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasQuerySettingDao basQuerySettingDao;

    public PageObject pageAll(int page, int rows, String sort, String order, String search) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtil.isEmpty(sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtil.isEmpty(order)) {
            params.put("order", order);
        }
        if (!StringUtil.isEmpty(search)) {
            params.put("search", "%" + search.toUpperCase().replace("%", "/%") + "%");
        }
        PageObject<Map<String, Object>> pageObject = this.bSqlHelper.serachPage("base.BasQuerySetting.pageAll", params, PageRequest.of((int)page, (int)rows));
        return pageObject;
    }

    @Transactional
    public void saveBasQuerySetting(BasQuerySetting entity) {
        this.basQuerySettingDao.save(entity);
    }

    public BasQuerySetting findBasQuerySetting(Long id) {
        BasQuerySetting entity = (BasQuerySetting)this.basQuerySettingDao.findById(id).get();
        return entity;
    }

    public void delBasQuerySetting(Long id) {
        BasQuerySetting entity = (BasQuerySetting)this.basQuerySettingDao.findById(id).get();
        entity.setIsUse("N");
        this.basQuerySettingDao.save(entity);
    }

    public List<Map<String, Object>> listHomeSearchBox() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        return this.bSqlHelper.getMapList("base.BasQuerySetting.getHomeSearchBox", params);
    }
}

