/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import com.guochuang.imp.base.common.util.ComBoxTreeNode;
import com.guochuang.imp.base.common.util.CommTreeUtils;
import com.guochuang.imp.base.common.util.NativeSqlHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.base.dao.BasMenuDao;
import com.guochuang.imp.base.entity.BasEmpAccount;
import com.guochuang.imp.base.entity.BasMenu;
import com.guochuang.imp.base.entity.BasMenuButton;
import com.guochuang.imp.base.entity.BasSpaceDefine;
import com.guochuang.imp.base.service.BasEmpAccountService;
import com.guochuang.imp.base.service.BasMenuButtonService;
import com.guochuang.imp.base.service.BasRolesAccountService;
import com.guochuang.imp.base.service.BasSpaceDefineService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasMenuService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private BasMenuDao basmenuDao;
    @Autowired
    private BasRolesAccountService basrolesaccountService;
    @Autowired
    private BasSpaceDefineService basspacedefineService;
    @Autowired
    private BasMenuButtonService basMenuButtonService;
    @Autowired
    private BasEmpAccountService basEmpAccountService;

    public BasMenu findBasMenu(Long id) {
        Optional entity = this.basmenuDao.findById(id);
        if (entity.isPresent()) {
            return (BasMenu)entity.get();
        }
        return null;
    }

    public void saveBasMenu(BasMenu entity) {
        this.basmenuDao.save(entity);
        if ("N".equals(entity.getEnable())) {
            this.calcelBasMenuAndChild(entity.getMenuId());
        }
    }

    public void delBasMenu(Long id) {
        this.basmenuDao.deleteById(id);
    }

    public void delBasMenuAndChild(Long id) {
        StringBuilder sql = new StringBuilder();
        sql.append("\tUPDATE \tBAS_MENU T \n\tSET\t\tT.IS_USE='N' \n\tWHERE \tT.MENU_ID in ( with recursive menu as(\n\t\t\t\t select a.* from BAS_MENU a where  a.menu_id = ?1 and a.IS_USE = 'Y' \n\t\t\t\t union all\n\t\t\t\t select a.* from BAS_MENU a,menu where menu.menu_id=a.pmenu_id and a.IS_USE = 'Y' )\n\t\t\t\t select menu.menu_id from menu) \n");
        this.sqlHelper.exeNativeSQL(sql.toString(), new Object[]{id});
    }

    public void calcelBasMenuAndChild(Long id) {
        StringBuilder sql = new StringBuilder();
        sql.append("\tUPDATE \tBAS_MENU T \n\tSET\t\tT.ENABLE='N' \n\tWHERE \tT.MENU_ID in ( with recursive menu as\n\t (select m.* from bas_menu m \n\t where   m.pmenu_id =?1  and m.is_use='Y' \n\t union all\n\t select m.* from bas_menu m,menu  where m.pmenu_id=menu.menu_id and m.is_use='Y' \n\t )\n select t.menu_id\n from menu t ) \n");
        this.sqlHelper.exeNativeSQL(sql.toString(), new Object[]{id});
    }

    public PageObject PageAll(String search, int page, int rows) {
        String sql = "select * from BAS_MENU t  order by t.MENU_ID";
        if (!StringUtils.isEmpty((String)search)) {
            sql = "select * from BAS_MENU t where   upper(t.MENU_ID) like ?1  or upper(t.MENU_TYPE) like ?1  or upper(t.APP_CODE) like ?1  or upper(t.MENU_NAME) like ?1  or upper(t.PMENU_ID) like ?1  or upper(t.BUSINESS_TYPE) like ?1  or upper(t.MENU_ADDR) like ?1  or upper(t.MENU_ICO) like ?1  or upper(t.IS_USE) like ?1  or upper(t.ENABLE) like ?1  or upper(t.DISPLAY_NO) like ?1  or upper(t.OPERATION_PRIVILEGE) like ?1  order by t.MENU_ID";
            return this.sqlHelper.pagerNativeSQL(sql, new Object[]{"%" + search.toUpperCase() + "%"}, page, rows);
        }
        return this.sqlHelper.pagerNativeSQL(sql, page, rows);
    }

    public List<ComBoxTreeNode> treeBasMenu(Long pid) {
        StringBuilder sql = new StringBuilder();
        sql.append("with recursive menu as\n\t (select m.* from bas_menu m \n\t where   m.pmenu_id = ?1  and m.is_use='Y' \n\t union all\n\t select m.* from bas_menu m,menu  where  m.pmenu_id=menu.menu_id and m.is_use='Y' \n\t )\n select \n\t\t\tt.MENU_ID id, \n\t\t\tT.PMENU_ID PID, \n\t\t\tt.MENU_NAME text, \n\t\t\tt.app_code,\n\t\t\tt.menu_addr,\n\t\t\tt.menu_type,\n\t\t\tt.menu_ico,\n\t\t\tifnull(t.BACKGROUND_COLOR,'#01aaed')BACKGROUND_COLOR,\n\t\t\tconcat('iconfont blue2 ',t.menu_ico) ico,\n\t\t\tt.enable,\n\t\t\tt.business_type \n from menu t\n ORDER BY t.DISPLAY_NO");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new Object[]{pid}, new int[0]);
        return CommTreeUtils.buildTreeNode(list);
    }

    public List<BasMenu> getAccountBasMenuForDD(Long accountid) {
        String sql = "select t.* from bas_menu t\n         where t.is_use = ?1 \n           and t.enable = ?1 \n           and t.app_code = '3' \n           and t.menu_type = '2' \n           and a.id in (select distinct b.menu_id\n                  from bas_roles_menu b\n                  left join bas_roles_account c on b.role_id = c.role_id\n                  left join bas_menu d on b.menu_id=d.menu_id\n                 where c.account_id = ?2 and  d.menu_type=2 and d.is_use='Y' and d.enable='Y')\n         order by t.display_no ";
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new Object[]{"Y", accountid}, BasMenu.class, new int[0]);
        return list;
    }

    public List<ComBoxTreeNode> getAccountBasMenu(Long accountid) {
        return this.getAccountBasMenu(accountid, null);
    }

    public List<ComBoxTreeNode> getAccountBasMenu(Long accountid, Long pid) {
        if (pid == null) {
            pid = 0L;
        }
        return CommTreeUtils.buildTreeNode(this.getmenu(accountid, pid));
    }

    public boolean hasMenuRole(Long accountid, String menuurl) {
        String sql = "select 1\n                  from bas_roles_menu b\n                  left join bas_roles_account c on b.role_id = c.role_id\n                  left join bas_menu d on b.menu_id=d.menu_id\n                 where c.account_id = ?2 and  d.menu_type=2 and d.is_use='Y' and d.enable='Y' and d.menu_addr=?1 ";
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new Object[]{menuurl, accountid}, new int[0]);
        return list != null && !list.isEmpty();
    }

    public List<ComBoxTreeNode> getAccountBasMenuSiteMap(Long accountid) {
        String sql = "WITH recursive tmp AS (\n   SELECT\n       d.* \n   FROM\n       bas_roles_menu b\n       LEFT JOIN bas_roles_account c ON b.role_id = c.role_id \n       AND ifnull( c.org_id, -99999 )= ifnull( b.org_id, -99999 ) \n       AND ifnull( c.dept_id, -99999 )= ifnull( b.dept_id, -99999 )\n       LEFT JOIN bas_menu d ON b.menu_id = d.menu_id \n   WHERE\n       c.account_id = ?1 \n       AND d.menu_type = 2 \n       AND d.ENABLE = 'Y' \n       AND d.is_use = 'Y' UNION ALL\n   SELECT\n       t.* \n   FROM\n       bas_menu t,\n       tmp \n   WHERE\n       t.MENU_ID = tmp.PMENU_ID \n       AND tmp.is_use = 'Y' \n       AND t.ENABLE = 'Y' \n   ) SELECT DISTINCT\n   tmp.menu_id AS id,\n   tmp.pmenu_id AS pid,\n   tmp.menu_name AS text,\n   tmp.menu_ico AS ico,\n   tmp.app_code,\n   tmp.IS_TWICE_PASSWORD_CONFIRM,\n   tmp.menu_addr,\n   tmp.menu_type,\n   tmp.display_no, \n   tmp.background_color \nFROM\n   tmp \nWHERE\n   tmp.PMENU_ID = 0 \n   AND tmp.ENABLE = 'Y'";
        List topmenu = this.sqlHelper.queryByNativeSQL(sql.toString(), new Object[]{accountid}, new int[0]);
        ArrayList<ComBoxTreeNode> menulist = new ArrayList<ComBoxTreeNode>();
        for (Object o : topmenu) {
            Map row = (Map)o;
            ComBoxTreeNode node = new ComBoxTreeNode();
            CommTreeUtils.fillTreeNodeProperty(node, row);
            String submenusql = "SELECT\n   a.* \nFROM\n   (\n   SELECT\n       t.menu_id AS id,\n       t.pmenu_id AS pid,\n       t.menu_name AS text,\n       t.menu_ico AS ico,\n       t.FRONTMENU_CSS,\n       t.app_code,\n       t.IS_TWICE_PASSWORD_CONFIRM,\n       t.menu_addr,\n       t.display_no,\n       t.menu_type,\n       t.business_type \n   FROM\n       bas_menu t \n   WHERE\n       t.is_use = 'Y' \n       AND t.ENABLE = 'Y'  \n   ORDER BY\n       t.display_no \n   ) a\n   LEFT JOIN bas_menu c ON a.pid = c.menu_id \nWHERE\n   a.id IN (\n   SELECT DISTINCT\n       b.menu_id \n   FROM\n       bas_roles_menu b\n       LEFT JOIN bas_roles_account c ON b.role_id = c.role_id \n       AND ifnull( c.org_id, -99999 )= ifnull( b.org_id, -99999 ) \n       AND ifnull( c.dept_id, -99999 )= ifnull( b.dept_id, -99999 ) \n   WHERE\n       c.account_id = ?1 \n   ) \n   AND a.menu_type = 2 \n   AND a.id IN (\n       WITH recursive tmp AS (\n       SELECT\n           x.menu_id \n       FROM\n           bas_menu x \n       WHERE\n           x.pmenu_id = ?2 UNION ALL\n       SELECT\n           t.menu_id \n       FROM\n           bas_menu t,\n           tmp \n       WHERE\n           t.pmenu_id = tmp.menu_id \n       ) SELECT\n       tmp.menu_id \n   FROM\n       tmp\n   ) \nORDER BY\n   c.display_no,\n   a.display_no";
            List sublist = this.sqlHelper.queryByNativeSQL(submenusql.toString(), new Object[]{accountid, node.getId()}, new int[0]);
            for (Object subo : sublist) {
                Map subrow = (Map)subo;
                ComBoxTreeNode subnode = new ComBoxTreeNode();
                CommTreeUtils.fillTreeNodeProperty(subnode, subrow);
                node.addChild(subnode);
            }
            menulist.add(node);
        }
        return menulist;
    }

    public List<ComBoxTreeNode> getAccountSecondTopMenu(Long accountid, Long menuid) {
        String submenusql = "with recursive tmp as (select o1.* from (select t.menu_id   as id, t.pmenu_id  as pid,t.menu_name as text,t.menu_ico as ico, t.app_code,t.menu_addr, t.menu_type,t.display_no from bas_menu t where t.is_use = ?1 and t.enable = ?1 and t.app_code <> '3' order by t.display_no) o1 where o1.id in (select distinct b.menu_id  left join bas_roles_account c on b.role_id = c.role_idleft join bas_menu d on b.menu_id=d.menu_idwhere c.account_id = ?2 and  d.menu_type=2 and d.is_use='Y' and d.enable='Y')UNION ALL select o2.* from (select t.menu_id   as id, t.pmenu_id  as pid,t.menu_name as text,t.menu_ico as ico,t.app_code,t.menu_addr,t.menu_type,t.display_nofrom bas_menu t where t.is_use = 'Y' and t.enable = 'Y'  and t.app_code <> '3' order by t.display_no) o2,tmp t  where t.id = o2.pid)  select *  from tmp p;";
        List sublist = this.sqlHelper.queryByNativeSQL(submenusql.toString(), new Object[]{"Y", accountid, menuid}, new int[0]);
        return CommTreeUtils.buildTreeNode(sublist);
    }

    public List getmenu(Long accountid, Long pid) {
        if (pid == null) {
            pid = 0L;
        }
        BasEmpAccount account = this.basEmpAccountService.findByAccountId(accountid);
        String sql = "with temp as(with recursive menu as\n(select m.menu_id,m.pmenu_id from bas_menu m ,(select  b.menu_id\n                       from bas_roles_menu b\n                       left join bas_roles_account c\n                         on b.role_id = c.role_id\n                       left join bas_menu d\n                         on b.menu_id = d.menu_id, bas_roles r\n                      where b.role_id = r.role_id\n                        and c.account_id =?1\n                        and d.menu_type = 2\n                        and d.is_use = 'Y'\n                        and d.enable = 'Y'\n                        and r.is_use = 'Y'\n and (r.role_type='common' or ifnull(c.org_id,-99999)=ifnull(b.org_id,-99999)) and (r.role_type='common' or ifnull(c.dept_id,-99999)=ifnull(b.dept_id,-99999))\n                     union all\n                     select m.menu_id\n                       from bas_menu m\n                      where m.menu_type = 2\n                        and m.is_use = 'Y'\n                        and m.enable = 'Y'\n                        and m.PERMISSION_CONTROL = 'N')p \nwhere  p.menu_id=m.menu_id  and m.is_use='Y' and m.enable='Y'\nunion all\nselect m.menu_id,m.pmenu_id from bas_menu m,menu  where m.menu_id=menu.pmenu_id and m.is_use='Y' and m.enable='Y'\n) \nselect  distinct menu_id from menu order by menu_id )select  *\r\n  from (select t.menu_id   as ID,\r\n               concat(t.pmenu_id,'')  as PID,\r\n               t.menu_name as TEXT,\r\n               t.menu_ico,\r\n               t.app_code,\r\n               CASE WHEN t.pmenu_id=0 then nvl2(s.space_id,concat('/BasSpaceDefine/priewSpace?spaceId=','', s.space_id ),'') else t.menu_addr end MENU_ADDR,\r\n               t.menu_type,\r\n               t.business_type,\r\n               t.IS_TWICE_PASSWORD_CONFIRM,\r\n               t.IS_REGULAR_PASSWORD,\r\n               t.background_color,\r\n               t.display_no\r\n          from (select a.* from bas_menu a   where a.is_use = 'Y'  and a.enable = 'Y') t\r\nleft join(select s.*,row_number()over(partition by s.menu_id order by s.tp) rw  from(select s.space_id, s.menu_id,\ncase\n         when (s.EMP_LV is null or s.EMP_LV = '') and u.user_type = 'user' then\n          1\n         when (s.EMP_LV is null or s.EMP_LV = '') and u.user_type = 'role' then\n          2\n         when (s.EMP_LV is null or s.EMP_LV = '') and u.user_type = 'dept' then\n          3\n         when (s.EMP_LV is null or s.EMP_LV = '') and u.user_type = 'org' then\n          4\n         else\n          s.EMP_LV\n       end tp\n  from BAS_SPACE_define s, (select u.space_id,u.user_type from  BAS_SPACE_use u ,(\nwith recursive org as\n(select m.id,m.pid from view_bas_org_bizdept m where m.id=?3\nunion all\nselect m.id,m.pid from view_bas_org_bizdept m,org  where  m.pid=org.id\n) \nselect org.id from org) org \nwhere u.user_type = 'org' and u.is_use = 'Y' and u.user_id =org.id\nunion all\nselect u.space_id,u.user_type from  BAS_SPACE_use u ,(\nwith recursive org as\n(select m.id,m.pid from view_bas_org_bizdept m where m.id=?2\nunion all\nselect m.id,m.pid from view_bas_org_bizdept m,org  where  m.pid=org.id\n) \nselect org.id from org) org \nwhere u.user_type = 'dept' and u.is_use = 'Y' and u.user_id =org.id\nunion all\nselect u.SPACE_ID, u.user_type\n  from BAS_SPACE_use u,\n       (select case\n                 when r.ROLE_TYPE = 'org' then\n                  concat(a.ORG_ID, '>', a.ROLE_ID)\n                 when r.ROLE_TYPE = 'dept' then\n                  concat(a.ORG_ID, '>', a.DEPT_ID, '>', a.ROLE_ID)\n                 else\n                  r.ROLE_ID\n               end ROLE_ID\n          from bas_roles_account a, bas_roles r\n         where a.ACCOUNT_ID = ?1\n           and a.ROLE_ID = r.ROLE_ID) r\n where u.user_type = 'role'\n   and r.role_id LIKE u.USER_ID\n   AND u.is_use = 'Y'union all\nselect u.space_id,u.user_type from  BAS_SPACE_use u \nwhere u.user_type = 'user' and u.is_use = 'Y' and u.user_id =?1) u\n where s.space_id = u.space_id \n   and s.is_use = 'Y' \n   and s.menu_id is not null\n   and s.space_type = '5')s)s on s.menu_id=t.menu_id  and s.rw=1         where t.is_use = 'Y'\r\n           and t.enable = 'Y' \r\n           and t.app_code <> '3' \r\n         order by t.display_no) a,temp\r\n where a.id =temp.menu_id order by a.display_no";
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new Object[]{accountid, account.getDeptId(), account.getOrgId()}, new int[0]);
        List<BasSpaceDefine> spaceList = this.basspacedefineService.getMySpaceList(account);
        if (!spaceList.isEmpty()) {
            for (int i = spaceList.size() - 1; i >= 0; --i) {
                BasSpaceDefine space = spaceList.get(i);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", "space" + space.getSpaceId());
                map.put("text", space.getSpaceName());
                map.put("pid", "space0");
                map.put("menu_addr", "/BasSpaceDefine/priewSpace?spaceId=" + space.getSpaceId());
                map.put("menu_type", "2");
                map.put("background_color", "#01aaed");
                map.put("menu_ico", "icon-caidan");
                map.put("business_type", "1");
                list.add(0, map);
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", "space0");
        map.put("menu_ico", "icon-home");
        map.put("text", "\u9996\u9875");
        map.put("pid", "0");
        map.put("menu_type", "1");
        map.put("business_type", "1");
        list.add(0, map);
        return list;
    }

    public List getmenuByProjectPeople(Long projectId, Long accountid, Long pid) {
        if (pid == null) {
            pid = 0L;
        }
        String sql = "select distinct *\r\n\t\tfrom (select t.menu_id   as id,\r\n\t\t\t\t\t\t\t\t t.pmenu_id  as pid,\r\n\t\t\t\t\t\t\t\t t.menu_name as text,\r\n\t\t\t\t\t\t\t\t t.menu_ico,\r\n\t\t\t\t\t\t\t\t t.app_code,\r\n\t\t\t\t\t\t\t\t t.menu_addr,\r\n\t\t\t\t\t\t\t\t t.menu_type,\r\n\t\t\t\t\t\t\t\t t.business_type,\r\n\t\t\t\t\t\t\t\t t.display_no\r\n\t\t\t\t\t\tfrom (select a.* from bas_menu a start with a.pmenu_id=" + pid + " connect by a.pmenu_id=prior a.menu_id) t\r\n\t\t\t\t\t where t.is_use = 'Y'\r\n\t\t\t\t\t\t and t.enable = 'Y' \r\n\t\t\t\t\t\t and t.app_code <> '3' \r\n\t\t\t\t\t order by t.display_no) a\r\n\t start with a.id in (select distinct b.menu_id\r\n\t\t\t\t\t\t\t\t\t\tfrom bas_roles_menu b  where b.role_id in (select e.role_name from ( select b.ROLE_NAME from PM_PLOT_PEOPLE a  LEFT JOIN PM_PERSON b ON A.JOBNAME=b.ID  where instr(','||a.name||',',','||?2||',')>0  and a.project_id=?1 and b.role_name is not null  \r\n UNION\r\n select DECODE( (select COUNT(1) from  B_PM_PROJECT c where c.project_id=?1 and c.PROJECT_MGR=?2) , 1, 1000000)  as role_name  from dual) e where e.role_name is not null)\r\n union all select  m.menu_id from bas_menu m where m.menu_type=2 and m.is_use='Y' and m.enable='Y' and m.PERMISSION_CONTROL='N')\r\n\tconnect by prior a.pid = a.id\r\n\t order by a.display_no  ";
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new Object[]{projectId, accountid}, new int[0]);
        return list;
    }

    public void refreshMemu(Long projectId) {
    }

    public List getAccountFormMap(String resId) {
        String sql = "select distinct b.form_code,\n       e.menu_name,\n       f.form_name,\n       e.menu_ico,\n       y.name pname,\ny.porder_index,yp.order_index,y.order_index order_index2,nvl(p2.display_no,p.display_no),\t\tdecode((select count(1) from BAS_FORM_LINK l where l.form_code=b.form_code  and l.is_use='Y' and l.create_account=?1),0,0,1) link,       (select u.menu_name from bas_menu u where u.pmenu_id=0 start with u.menu_id=e.menu_id connect by u.menu_id = prior u.pmenu_id) pmenuname\n  from bas_menu_button b\n  left join bas_menu e on e.menu_id=b.menu_id\n  left join gen_form f on f.form_code=b.form_code and f.is_use='Y'\nleft join stf_business_process p on p.design_name=f.flow_code\nleft join gen_form_flow o on o.form_id=f.id and comparestr(o.apply_orgs,?2) > 0\nleft join stf_business_process p2 on p2.design_name=o.flow_code\n  left join (select s.res_id,s.parent_id,s.name,s.order_index, (select u.order_index from STF_BUSINESS_TYPE u where u.parent_id= 0 start with u.res_id = s.res_id connect by u.res_id = prior u.parent_id)porder_index from STF_BUSINESS_TYPE s) y on nvl(p2.business_type_id,p.business_type_id)=y.res_id \n  left join STF_BUSINESS_TYPE yp on yp.res_id=y.parent_id \n where (b.is_control = 'N'\n    or b.button_id in (select m.button_id from bas_roles_menu m\n where m.role_id in\n       (select b.role_Id from Bas_Roles_Account b where b.account_Id = ?1 and nvl(b.org_id,-99999)=nvl(m.org_id,-99999) and nvl(b.dept_id,-99999)=nvl(m.dept_id,-99999))\n   and m.button_id is not null))\n   and b.form_code  is not null\n   and (f.flow_code is not null  or exists ( select 1 from gen_form_flow o where o.form_id=f.id and o.org_id=?2 and o.is_use='Y'))\n  and e.is_use='Y' and e.enable='Y' ";
        if (StringUtils.isNotEmpty((String)resId)) {
            sql = sql + " and y.res_id=" + resId;
        }
        sql = sql + "  and y.name  is not null order by  y.porder_index,yp.order_index,y.order_index,nvl(p2.display_no,p.display_no)";
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new Object[]{SysUtils.getLoginAccountId(), SysUtils.getLoginUser().getOrgid()}, new int[0]);
        return list;
    }

    public void genMenu(String menuName, Long pmenuId, String src, String type) {
        BasMenu menu = new BasMenu();
        menu.setMenuAddr(src);
        menu.setAppCode("1");
        menu.setBusinessType(1L);
        menu.setOperationPrivilege("0");
        menu.setMenuType("2");
        menu.setMenuName(menuName);
        menu.setFormCode(src.substring(src.lastIndexOf("/") + 1));
        menu.setPmenuId(pmenuId);
        menu.setMenuIco("icon-default");
        menu.setIsUse("Y");
        menu.setEnable("Y");
        menu.setDisplayNo(10L);
        menu = (BasMenu)this.basmenuDao.save(menu);
        BasMenuButton btnsave = new BasMenuButton();
        btnsave.setMenuId(menu.getMenuId());
        btnsave.setIsUse("Y");
        btnsave.setButtonText("\u4fdd\u5b58");
        btnsave.setButtonHtmlid("save" + src.substring(src.lastIndexOf("/") + 1));
        btnsave.setIsControl("Y");
        this.basMenuButtonService.saveBasMenuButton(btnsave);
        if ("process".equals(type)) {
            BasMenuButton btnflow = new BasMenuButton();
            btnflow.setMenuId(menu.getMenuId());
            btnflow.setIsUse("Y");
            btnflow.setButtonText("\u6d41\u7a0b");
            btnflow.setButtonHtmlid("flow" + src.substring(src.lastIndexOf("/") + 1));
            btnflow.setIsControl("Y");
            this.basMenuButtonService.saveBasMenuButton(btnflow);
        }
    }

    public Object getAccountFirstMenu(Long pid) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT \tt.MENU_ID id, \n\t\t\tT.PMENU_ID PID, \n     \tt.MENU_NAME text, \n               t.app_code,\n               t.menu_addr,\n               t.menu_type,\n               t.business_type\n FROM  BAS_MENU T \n WHERE  T.IS_USE='Y' and t.enable = 'Y'\n and T.PMENU_ID = ?1 \n ORDER BY T.DISPLAY_NO");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new Object[]{pid}, new int[0]);
        return CommTreeUtils.buildTreeNode(list);
    }

    public List<ComBoxTreeNode> treeBasMenuWithEnable(Long pid) {
        StringBuilder sql = new StringBuilder();
        sql.append("with recursive temp as \n ( select b.* from BAS_MENU b where b.IS_USE = 'Y' and b.ENABLE = 'Y' and b.PMENU_ID =? \n  union all  select b.* from BAS_MENU b,temp t where b.IS_USE = 'Y' AND b.ENABLE = 'Y' AND t.MENU_ID=b.PMENU_ID) \n               SELECT t.MENU_ID id,\n               T.PMENU_ID PID,\n               t.MENU_NAME text,\n               t.app_code,\n               t.menu_addr,\n               t.menu_type,\n\t\t\t       t.menu_ico,\n\t\t\t      ifnull(t.BACKGROUND_COLOR,'#01aaed')BACKGROUND_COLOR,\n               t.business_type \n FROM \ttemp t \n ORDER BY T.DISPLAY_NO");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new Object[]{pid}, new int[0]);
        return CommTreeUtils.buildTreeNode(list);
    }
}

