/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.dao.BasInterfaceInfoDao;
import com.guochuang.imp.base.entity.BasInterfaceInfo;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasInterfaceInfoService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasInterfaceInfoDao basInterfaceInfoDao;

    public BasInterfaceInfo findBasInterfaceInfo(Long id) {
        BasInterfaceInfo entity = (BasInterfaceInfo)this.basInterfaceInfoDao.findById(id).get();
        return entity;
    }

    public BasInterfaceInfo findBasInterfaceInfoByinterfaceCode(String interfaceCode) {
        BasInterfaceInfo entity = this.basInterfaceInfoDao.findByInterfaceCodeAndIsUse(interfaceCode, "Y").get(0);
        return entity;
    }

    public BasInterfaceInfo findByInterfaceCodeAndIsUse(String interfaceCode) {
        List<BasInterfaceInfo> list = this.basInterfaceInfoDao.findByInterfaceCodeAndIsUse(interfaceCode, "Y");
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public void saveBasInterfaceInfo(BasInterfaceInfo entity) {
        this.basInterfaceInfoDao.save(entity);
    }

    public void delBasInterfaceInfo(Long id) {
        BasInterfaceInfo entity = (BasInterfaceInfo)this.basInterfaceInfoDao.findById(id).get();
        entity.setIsUse("N");
        this.basInterfaceInfoDao.save(entity);
    }

    public PageObject PageAll(String search, String startDate, String endDate, String applyPerson, String applyDept, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        if (!StringUtils.isEmpty((String)startDate)) {
            params.put("startDate", startDate);
        }
        if (!StringUtils.isEmpty((String)endDate)) {
            params.put("endDate", endDate);
        }
        if (!StringUtils.isEmpty((String)applyPerson)) {
            params.put("applyPerson", "%" + applyPerson.toUpperCase().replace("%", "/%") + "%");
        }
        if (applyDept != null) {
            params.put("applyDept", applyDept);
        }
        return this.bSqlHelper.serachPage("base.BasInterfaceInfo.select", params, PageRequest.of((int)page, (int)rows));
    }

    public List<Map<String, Object>> getInterfaceType() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        return this.bSqlHelper.getMapList("base.BasInterfaceInfo.getInterfaceType", params);
    }

    public String selectInterfaceName(String interfaceCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)interfaceCode)) {
            params.put("interfaceCode", interfaceCode.trim());
        }
        return this.bSqlHelper.getStringValue("base.BasInterfaceInfo.selectInterfaceName", params);
    }
}

