/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.ComBoxTreeNode;
import com.guochuang.imp.base.common.util.CommTreeUtils;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.base.dao.BasGroupDao;
import com.guochuang.imp.base.entity.BasGroup;
import com.guochuang.imp.base.entity.BasGroupAccountRelate;
import com.guochuang.imp.base.entity.BasGroupScope;
import com.guochuang.imp.base.service.BasEmpAccountService;
import com.guochuang.imp.base.service.BasGroupAccountRelateService;
import com.guochuang.imp.base.service.BasGroupScopeService;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import com.guochuang.imp.util.StringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasGroupService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasGroupDao basgroupDao;
    @Autowired
    private BasGroupAccountRelateService basGroupAccountRelateService;
    @Autowired
    private BasGroupScopeService basGroupScopeService;
    @Autowired
    private BasEmpAccountService baspAccountService;

    public BasGroup findBasGroup(Long id) {
        BasGroup entity = (BasGroup)this.basgroupDao.findById(id).get();
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (id != null) {
            params.put("groupId", id);
        }
        Map<String, Object> mapUseUser = this.bSqlHelper.getMap("base.BasGroup.getComponentsByGroupId", params);
        entity.setGroupComponent((String)mapUseUser.get("userId"));
        entity.setGroupComponent_TEXT_((String)mapUseUser.get("userName"));
        entity.setScopeId(Objects.toString(mapUseUser.get("scopeId"), ""));
        entity.setScopeId_TEXT_(Objects.toString(mapUseUser.get("scopeName"), ""));
        return entity;
    }

    public void saveBasGroup(BasGroup entity) {
        this.basgroupDao.save(entity);
        this.basGroupAccountRelateService.deleteByGroupId(entity.getGroupId());
        String groupComponent = entity.getGroupComponent();
        if (StringUtils.isNotBlank((String)groupComponent)) {
            String[] ids;
            for (String id : ids = groupComponent.split(",")) {
                BasGroupAccountRelate b = new BasGroupAccountRelate();
                String[] split = id.split(":");
                b.setGroupId(entity.getGroupId());
                b.setUserType(split[0]);
                b.setUserId(Long.parseLong(split[1]));
                b.setModifyAccount(SysUtils.getLoginUser().getAccountid());
                b.setModifyTime(new Date());
                b.setIsUse("Y");
                b.setCreateAccount(SysUtils.getLoginUser().getAccountid());
                b.setCreateTime(new Date());
                this.basGroupAccountRelateService.saveBasGroupAccountRelate(b);
            }
        }
        this.basGroupScopeService.deleteByGroupId(entity.getGroupId());
        String scopeIds = entity.getScopeId();
        if (StringUtils.isNotBlank((String)scopeIds)) {
            String[] ids;
            for (String id : ids = scopeIds.split(",")) {
                BasGroupScope b = new BasGroupScope();
                String[] split = id.split(":");
                b.setGroupId(entity.getGroupId());
                b.setUserType(split[0]);
                b.setUserId(Long.parseLong(split[1]));
                b.setModifyAccount(SysUtils.getLoginUser().getAccountid());
                b.setModifyTime(new Date());
                b.setIsUse("Y");
                b.setCreateAccount(SysUtils.getLoginUser().getAccountid());
                b.setCreateTime(new Date());
                this.basGroupScopeService.saveBasGroupScope(b);
            }
        }
    }

    public void delBasGroup(Long id) {
        BasGroup entity = (BasGroup)this.basgroupDao.findById(id).get();
        entity.setIsUse("N");
        this.basgroupDao.save(entity);
    }

    public PageObject PageAll(String search, int page, int rows, String sort, String order, String mgrFilter) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        if (!StringUtils.isEmpty((String)mgrFilter)) {
            params.put("mgrFilter", mgrFilter);
            params.put("accountId", SysUtils.getLoginUser().getAccountid());
        }
        return this.bSqlHelper.serachPage("base.BasGroup.select", params, PageRequest.of((int)page, (int)rows));
    }

    public List<ComBoxTreeNode> getAllGroup(String search, String sort, String order, String mgrFilter, String groupName, String groupComponent) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> commonList = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> privateList = new ArrayList<Map<String, Object>>();
        ComBoxTreeNode commonNode = new ComBoxTreeNode();
        ComBoxTreeNode privateNode = new ComBoxTreeNode();
        ArrayList<ComBoxTreeNode> allComboxNodes = new ArrayList<ComBoxTreeNode>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)groupName)) {
            params.put("groupName", "%" + groupName.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)groupComponent)) {
            params.put("groupComponent", "%" + groupComponent.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        if (!StringUtils.isEmpty((String)mgrFilter)) {
            params.put("mgrFilter", mgrFilter);
            params.put("accountId", SysUtils.getLoginUser().getAccountid());
        }
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasGroup.getAllGroup", params);
        for (Map<String, Object> map : list) {
            if ("1".equals(map.get("groupType").toString())) {
                commonList.add(map);
                continue;
            }
            if (!"2".equals(map.get("groupType").toString())) continue;
            privateList.add(map);
        }
        List<ComBoxTreeNode> commonComboxNodes = CommTreeUtils.buildTreeNode(commonList);
        List<ComBoxTreeNode> privateComboxNodes = CommTreeUtils.buildTreeNode(privateList);
        commonNode.setId("common");
        commonNode.setValue("common");
        commonNode.setText("\u516c\u6709\u7ec4");
        commonNode.setChildren(commonComboxNodes);
        privateNode.setId("private");
        privateNode.setValue("private");
        privateNode.setText("\u79c1\u6709\u7ec4");
        privateNode.setChildren(privateComboxNodes);
        allComboxNodes.add(commonNode);
        allComboxNodes.add(privateNode);
        return allComboxNodes;
    }

    public Object getAccontIdByGroupId(String search, String sort, String order, String groupId, int page, int rows) {
        List<BasGroup> groups;
        StringBuffer orgIds = new StringBuffer();
        StringBuffer deptIds = new StringBuffer();
        StringBuffer userIds = new StringBuffer();
        ArrayList result = new ArrayList();
        List<Object> basGroupAccountRelates = new ArrayList();
        if ("common".equals(groupId)) {
            groups = this.findByGroupType(null, null, null, "1", "Y");
            basGroupAccountRelates = this.basGroupAccountRelateService.findBasGroupAccountRelateByGroupEntityList(groups);
        } else if ("private".equals(groupId)) {
            groups = this.findByGroupType(null, null, null, "2", null);
            basGroupAccountRelates = this.basGroupAccountRelateService.findBasGroupAccountRelateByGroupEntityList(groups);
        } else {
            basGroupAccountRelates = this.basGroupAccountRelateService.findBasGroupAccountRelateByGroupId(Long.parseLong(groupId));
        }
        for (int i = 0; i < basGroupAccountRelates.size(); ++i) {
            if ("org".equals(((BasGroupAccountRelate)basGroupAccountRelates.get(i)).getUserType())) {
                orgIds.append(((BasGroupAccountRelate)basGroupAccountRelates.get(i)).getUserId() + ",");
                continue;
            }
            if ("dept".equals(((BasGroupAccountRelate)basGroupAccountRelates.get(i)).getUserType())) {
                deptIds.append(((BasGroupAccountRelate)basGroupAccountRelates.get(i)).getUserId() + ",");
                continue;
            }
            if (!"user".equals(((BasGroupAccountRelate)basGroupAccountRelates.get(i)).getUserType())) continue;
            userIds.append(((BasGroupAccountRelate)basGroupAccountRelates.get(i)).getUserId() + ",");
        }
        if (!StringUtils.isEmpty((String)search)) {
            search = "'%" + search.toUpperCase() + "%'";
        }
        return this.baspAccountService.findByOrgIdsAndDeptIdsAndAccountIds(search, orgIds.toString(), deptIds.toString(), userIds.toString(), page, rows);
    }

    public List<BasGroup> findByGroupType(String search, String sort, String order, String groupType, String searchCommonGroup) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtil.isNotEmpty(groupType)) {
            return new ArrayList<BasGroup>();
        }
        params.put("groupType", groupType);
        if (StringUtil.isNotEmpty(searchCommonGroup)) {
            params.put("searchCommonGroup", searchCommonGroup);
        }
        return this.bSqlHelper.getList("base.BasGroup.findByGroupType", params, BasGroup.class);
    }
}

