/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.base.dao.BasFlowPrintDao;
import com.guochuang.imp.base.entity.BasFlowPrint;
import com.guochuang.imp.base.entity.BasFlowPrintDetail;
import com.guochuang.imp.base.service.BasFlowPrintDetailService;
import com.guochuang.imp.gen.entity.GenForm;
import com.guochuang.imp.gen.service.GenFormService;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import com.guochuang.imp.util.StringUtil;
import com.guochuang.imp.workflow.service.FlowUtilService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class BasFlowPrintService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasFlowPrintDao basFlowPrintDao;
    @Autowired
    private FlowUtilService flowUtilService;
    @Autowired
    private BasFlowPrintDetailService basFlowPrintDetailService;
    @Autowired
    private GenFormService formService;

    public PageObject pageAll(String createTimeStart, String createTimeEnd, String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtil.isEmpty(search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtil.isEmpty(createTimeStart)) {
            params.put("createTimeStart", createTimeStart);
        }
        if (!StringUtil.isEmpty(createTimeEnd)) {
            params.put("createTimeEnd", createTimeEnd);
        }
        if (!StringUtil.isEmpty(sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtil.isEmpty(order)) {
            params.put("order", order);
        }
        PageObject<Map<String, Object>> pageObject = this.bSqlHelper.serachPage("base.BasFlowPrint.pageAll", params, PageRequest.of((int)page, (int)rows));
        return pageObject;
    }

    @Transactional
    public void saveBasFlowPrint(BasFlowPrint entity) {
        this.basFlowPrintDao.save(entity);
        if (entity.getDetailList() != null && !entity.getDetailList().isEmpty()) {
            List<BasFlowPrintDetail> detailList = entity.getDetailList();
            this.basFlowPrintDetailService.saveBasFlowPrintDetail(detailList, entity.getPrintId());
        }
    }

    public BasFlowPrint findBasFlowPrint(Long id) {
        BasFlowPrint entity = (BasFlowPrint)this.basFlowPrintDao.findById(id).get();
        return entity;
    }

    public void delBasFlowPrint(Long id) {
        BasFlowPrint entity = (BasFlowPrint)this.basFlowPrintDao.findById(id).get();
        entity.setIsUse("N");
        this.basFlowPrintDao.save(entity);
    }

    public PageObject pageFlowDeFine(String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtil.isEmpty(search)) {
            params.put("search", "%" + search.trim().toUpperCase() + "%");
        }
        if (!StringUtil.isEmpty(sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtil.isEmpty(order)) {
            params.put("order", order);
        }
        PageObject<Map<String, Object>> pageObject = this.bSqlHelper.serachPage("base.BasFlowPrint.pageFlowDeFine", params, PageRequest.of((int)page, (int)rows));
        return pageObject;
    }

    @Deprecated
    public Map<String, Map<String, Object>> loadFlowInfo(Long processinstid, Long id) throws Exception {
        LinkedHashMap<String, Map<String, Object>> flowInfo = new LinkedHashMap<String, Map<String, Object>>();
        if (processinstid != null) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("processinstid", processinstid);
            Map<String, Object> map = this.bSqlHelper.getMap("base.BasFlowPrint.getFlowNameByProcessinstid", param);
            if (map != null) {
                String flowName = String.valueOf(map.get("processdefname"));
                String processdefid = String.valueOf(map.get("processdefid"));
                if (!StringUtil.isEmpty(flowName) && !StringUtil.isEmpty(processdefid)) {
                    param.put("flowNo", flowName);
                    param.put("processdefid", processdefid);
                    BasFlowPrint entity = this.bSqlHelper.getEntity("base.BasFlowPrint.findByFlowNo", param, BasFlowPrint.class);
                    if (entity != null && "N".equals(entity.getIsEnable())) {
                        this.fillingAdvice(entity.getFirstAct(), entity.getSecondAct(), entity.getThirdAct(), entity.getFourthAct(), entity.getFifthAct(), processinstid, flowInfo);
                    }
                    if (entity != null && "Y".equals(entity.getIsEnable())) {
                        List<BasFlowPrintDetail> list1 = this.basFlowPrintDetailService.findListById(entity.getPrintId());
                        BasFlowPrintDetail detail = this.getActs(list1, entity.getFormCode(), id);
                        this.fillingAdvice(detail.getFirstAct(), detail.getSecondAct(), detail.getThirdAct(), detail.getFourthAct(), detail.getFifthAct(), processinstid, flowInfo);
                    }
                    return flowInfo;
                }
            }
        }
        return new HashMap<String, Map<String, Object>>();
    }

    public BasFlowPrintDetail getActs(List<BasFlowPrintDetail> list, String formCode, Long id) throws Exception {
        GenForm genForm = this.formService.findGenFormByCode(formCode);
        Object data = SysUtils.sendHttp(((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest(), ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse(), genForm.getLoaddataUrl() + "?id=" + id);
        Map entityData = (Map)data;
        for (int i = 0; i < list.size(); ++i) {
            Object eval;
            BasFlowPrintDetail item = list.get(i);
            String exp = StringUtil.null2String(item.getExp());
            ScriptEngine engine = new ScriptEngineManager().getEngineByName("js");
            for (Map.Entry next : entityData.entrySet()) {
                String key = (String)next.getKey();
                Object value = next.getValue();
                engine.put(key, value);
            }
            try {
                eval = engine.eval(exp);
            }
            catch (Exception e) {
                throw new RuntimeException("\u8868\u8fbe\u5f0f\u5185\u5bb9\u5f02\u5e38");
            }
            boolean b = Boolean.parseBoolean(StringUtil.null2String(eval));
            if (!b) continue;
            return item;
        }
        return new BasFlowPrintDetail();
    }

    public List<Map<String, Object>> findActListByFlowName(String flowName) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        HashMap<String, String> ma = new HashMap<String, String>();
        ma.put("text", "\u8bf7\u9009\u62e9");
        ma.put("value", "");
        list.add(ma);
        if (StringUtil.isEmpty(flowName)) {
            return new ArrayList<Map<String, Object>>();
        }
        List<Map<String, Object>> flowActList = this.flowUtilService.getFlowActList(flowName);
        Iterator<Map<String, Object>> iterator = flowActList.iterator();
        while (iterator.hasNext()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Map<String, Object> next = iterator.next();
            map.put("text", next.get("ACTNAME").toString() + "(" + next.get("ACTIVITYDEFID").toString() + ")");
            map.put("value", next.get("ACTIVITYDEFID"));
            list.add(map);
        }
        return list;
    }

    public Map<String, Object> findAdviceByActs(String acts, Long processinstid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtil.isEmpty(acts) || processinstid == null) {
            return new HashMap<String, Object>();
        }
        params.put("processinstid", processinstid);
        params.put("acts", acts);
        Map<String, Object> map = this.bSqlHelper.getMap("base.BasFlowPrint.getFlowAdvice", params);
        if (map != null && map.size() > 0) {
            return map;
        }
        return new HashMap<String, Object>();
    }

    public void fillingAdvice(String firstActs, String secondActs, String thirdActs, String fourthActs, String fifthActs, Long processinstid, Map<String, Map<String, Object>> flowInfo) throws ExecutionException, InterruptedException {
        ExecutorService threadPool = Executors.newFixedThreadPool(5);
        CompletableFuture<Map> firstFuture = CompletableFuture.supplyAsync(() -> {
            Map<String, Object> adviceByActs = this.findAdviceByActs(firstActs, processinstid);
            return adviceByActs;
        }, threadPool);
        CompletableFuture<Map> secondFuture = CompletableFuture.supplyAsync(() -> {
            Map<String, Object> adviceByActs = this.findAdviceByActs(secondActs, processinstid);
            return adviceByActs;
        }, threadPool);
        CompletableFuture<Map> thiredFuture = CompletableFuture.supplyAsync(() -> {
            Map<String, Object> adviceByActs = this.findAdviceByActs(thirdActs, processinstid);
            return adviceByActs;
        }, threadPool);
        CompletableFuture<Map> fourthFuture = CompletableFuture.supplyAsync(() -> {
            Map<String, Object> adviceByActs = this.findAdviceByActs(fourthActs, processinstid);
            return adviceByActs;
        }, threadPool);
        CompletableFuture<Map> fifthFuture = CompletableFuture.supplyAsync(() -> {
            Map<String, Object> adviceByActs = this.findAdviceByActs(fifthActs, processinstid);
            return adviceByActs;
        }, threadPool);
        CompletableFuture.allOf(firstFuture, secondFuture, thiredFuture, fourthFuture, fifthFuture);
        Map firstAct = firstFuture.get();
        Map secondAct = secondFuture.get();
        Map thirdAct = thiredFuture.get();
        Map fourthAct = fourthFuture.get();
        Map fifthAct = fifthFuture.get();
        if (firstAct != null && firstAct.size() > 0) {
            flowInfo.put("firstAct", firstAct);
        }
        if (secondAct != null && secondAct.size() > 0) {
            flowInfo.put("secondAct", secondAct);
        }
        if (thirdAct != null && thirdAct.size() > 0) {
            flowInfo.put("thirdAct", thirdAct);
        }
        if (fourthAct != null && fourthAct.size() > 0) {
            flowInfo.put("fourthAct", fourthAct);
        }
        if (fifthAct != null && fifthAct.size() > 0) {
            flowInfo.put("fifthAct", fifthAct);
        }
        threadPool.shutdownNow();
    }
}

