/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import com.alibaba.fastjson.JSON;
import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.base.dao.BasFlowActPrintDetailDao;
import com.guochuang.imp.base.entity.BasFlowActPrintDetail;
import com.guochuang.imp.base.service.BasFlowActPrintService;
import com.guochuang.imp.util.StringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class BasFlowActPrintDetailService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasFlowActPrintDetailDao basFlowActPrintDetailDao;
    @Autowired
    private BasFlowActPrintService basFlowActPrintService;

    public List<Map<String, Object>> pageAll(String search, Long mainId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtil.isEmpty(search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (mainId == null) {
            return new ArrayList<Map<String, Object>>();
        }
        params.put("mainId", mainId);
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasFlowActPrintDetail.pageAll", params);
        return list;
    }

    @Transactional
    public void saveBasFlowActPrintDetail(String data, Long mainId) {
        List list = JSON.parseArray((String)data, BasFlowActPrintDetail.class);
        for (BasFlowActPrintDetail entiy : list) {
            if (entiy.getDetailId() == null) {
                entiy.setCreateTime(new Date());
                entiy.setCreateAccount(SysUtils.getLoginAccountId());
            } else {
                entiy.setModifyTime(new Date());
                entiy.setModifyAccount(SysUtils.getLoginAccountId());
            }
            entiy.setMainId(mainId);
            entiy.setIsUse("Y");
        }
        this.basFlowActPrintDetailDao.saveAll(list);
    }

    public BasFlowActPrintDetail findBasFlowActPrintDetail(Long id) {
        BasFlowActPrintDetail entity = (BasFlowActPrintDetail)this.basFlowActPrintDetailDao.findById(id).get();
        return entity;
    }

    public void delBasFlowActPrintDetail(Long id) {
        BasFlowActPrintDetail entity = (BasFlowActPrintDetail)this.basFlowActPrintDetailDao.findById(id).get();
        entity.setIsUse("N");
        this.basFlowActPrintDetailDao.save(entity);
    }

    public List<Map<String, Object>> findByForeignId(Long id) {
        AtomicReference listAct = new AtomicReference(new ArrayList());
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("mainId", id);
        List<Map<String, Object>> mapList = this.bSqlHelper.getMapList("base.BasFlowActPrintDetail.pageAll", params);
        mapList.forEach(map -> {
            if (((List)listAct.get()).isEmpty()) {
                String processdefid = StringUtil.null2String(map.get("processdefid"));
                listAct.set(this.basFlowActPrintService.findActListByFlowName(processdefid));
            }
            Optional<Map> first = ((List)listAct.get()).stream().filter(e -> {
                String s = StringUtil.null2String(e.get("value"));
                return s.equals(map.get("actId"));
            }).findFirst();
            first.ifPresent(stringObjectMap -> map.put("actName", stringObjectMap.get("text")));
        });
        return mapList;
    }
}

