/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.dao.BasEmpDeviceDao;
import com.guochuang.imp.base.entity.BasEmpDevice;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import com.guochuang.imp.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class BasEmpDeviceService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasEmpDeviceDao basEmpDeviceDao;

    public PageObject pageAll(String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtil.isEmpty(search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtil.isEmpty(sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtil.isEmpty(order)) {
            params.put("order", order);
        }
        PageObject<Map<String, Object>> pageObject = this.bSqlHelper.serachPage("base.BasEmpDevice.pageAll", params, PageRequest.of((int)page, (int)rows));
        return pageObject;
    }

    @Transactional
    public void saveBasEmpDevice(BasEmpDevice entity) {
        this.basEmpDeviceDao.save(entity);
    }

    @Transactional
    @Async(value="taskExecutor")
    public void saveBasEmpDeviceSync(String IMEI, String deviceMode, String appVersion, Long accountId) {
        List<BasEmpDevice> devs = this.basEmpDeviceDao.findByAccountIdOrderByIdDesc(accountId);
        if (!devs.isEmpty() && StringUtils.compare((String)devs.get(0).getImei(), (String)IMEI) == 0 && StringUtils.compare((String)devs.get(0).getDeviceMode(), (String)deviceMode) == 0 && StringUtils.compare((String)devs.get(0).getAppVersion(), (String)appVersion) == 0) {
            return;
        }
        BasEmpDevice entity = new BasEmpDevice();
        entity.setAppVersion(appVersion);
        entity.setDeviceMode(deviceMode);
        entity.setImei(IMEI);
        entity.setAccountId(accountId);
        this.basEmpDeviceDao.save(entity);
    }

    public BasEmpDevice findBasEmpDevice(Long id) {
        BasEmpDevice entity = (BasEmpDevice)this.basEmpDeviceDao.findById(id).get();
        return entity;
    }

    public void delBasEmpDevice(Long id) {
        BasEmpDevice entity = (BasEmpDevice)this.basEmpDeviceDao.findById(id).get();
        this.basEmpDeviceDao.delete(entity);
    }
}

