/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.MemCache;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.base.dao.BasEarlyWarningSettingFilterDao;
import com.guochuang.imp.base.entity.BasEarlyWarningSettingFilter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class BasEarlyWarningSettingFilterService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasEarlyWarningSettingFilterDao basEarlyWarningSettingFilterDao;

    public List<Map<String, Object>> findDetailList(Long mainId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("mainId", mainId);
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasEarlyWarningSettingFilter.pageAll", params);
        if (list != null && !list.isEmpty()) {
            for (Map<String, Object> row : list) {
                if (row.get("leftBracket") != null) {
                    row.put("leftBracketName", MemCache.getDicText("LEFT_BRACKET", row.get("leftBracket").toString()));
                }
                if (row.get("compareMark") != null) {
                    row.put("compareMarkName", MemCache.getDicText("COMPARE_MARK", row.get("compareMark").toString()));
                }
                if (row.get("rightBracket") != null) {
                    row.put("rightBracketName", MemCache.getDicText("RIGHT_BRACKET", row.get("rightBracket").toString()));
                }
                if (row.get("logicalMark") == null) continue;
                row.put("logicalMarkName", MemCache.getDicText("LOGICAL_MARK", row.get("logicalMark").toString()));
            }
            return list;
        }
        return null;
    }

    @Transactional
    public void saveBasEarlyWarningSettingFilter(BasEarlyWarningSettingFilter entity) {
        this.basEarlyWarningSettingFilterDao.save(entity);
    }

    public BasEarlyWarningSettingFilter findBasEarlyWarningSettingFilter(Long id) {
        BasEarlyWarningSettingFilter entity = (BasEarlyWarningSettingFilter)this.basEarlyWarningSettingFilterDao.findById(id).get();
        return entity;
    }

    @Transactional
    public void delBasEarlyWarningSettingFilter(Long id) {
        BasEarlyWarningSettingFilter entity = (BasEarlyWarningSettingFilter)this.basEarlyWarningSettingFilterDao.findById(id).get();
        entity.setIsUse("N");
        this.basEarlyWarningSettingFilterDao.save(entity);
    }

    @Transactional
    public void delBasEarlyWarningSettingFilterBySettingId(Long warningSettingId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("mainId", warningSettingId);
        params.put("modifyAccount", SysUtils.getLoginAccountId());
        this.bSqlHelper.updateOrDelete("base.BasEarlyWarningSettingFilter.delBasEarlyWarningSettingFilterBySettingId", params);
    }

    public List<Map<String, Object>> findDataModelList(Long modelId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("modelId", modelId);
        return this.bSqlHelper.getMapList("base.BasEarlyWarningSettingFilter.findDataModelList", params);
    }
}

