/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.base.dao.BasDeviceUserDao;
import com.guochuang.imp.base.entity.BasDeviceUser;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasDeviceUserService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasDeviceUserDao basdeviceuserDao;

    public BasDeviceUser findBasDeviceUser(Long id) {
        BasDeviceUser entity = (BasDeviceUser)this.basdeviceuserDao.findById(id).get();
        return entity;
    }

    public List<BasDeviceUser> findByAccountId(Long accountId) {
        return this.basdeviceuserDao.findByAccountIdOrderByIdDesc(accountId);
    }

    public void saveBasDeviceUser(BasDeviceUser entity) {
        this.basdeviceuserDao.save(entity);
    }

    public BasDeviceUser save(String clientId) {
        BasDeviceUser entity;
        List<BasDeviceUser> devs = this.basdeviceuserDao.findByClientId(clientId);
        if (devs.isEmpty()) {
            entity = new BasDeviceUser();
            entity.setClientId(clientId);
        } else {
            devs.forEach(dev -> {
                if (!SysUtils.getLoginAccountId().equals(dev.getAccountId()) && dev.getAccountId() > 0L) {
                    dev.setAccountId(-dev.getAccountId().longValue());
                    dev.setClientId("-" + clientId);
                    this.basdeviceuserDao.save(dev);
                }
            });
            List<BasDeviceUser> accountDevs = this.basdeviceuserDao.findByAccountIdOrderByIdDesc(SysUtils.getLoginAccountId());
            if (accountDevs.isEmpty() || !Objects.equals(accountDevs.get(0).getClientId(), clientId)) {
                entity = new BasDeviceUser();
                entity.setClientId(clientId);
            } else {
                entity = accountDevs.get(0);
                entity.setClientId(clientId);
            }
        }
        entity.setAccountId(SysUtils.getLoginAccountId());
        return (BasDeviceUser)this.basdeviceuserDao.save(entity);
    }

    public void delBasDeviceUser(Long id) {
        BasDeviceUser entity = (BasDeviceUser)this.basdeviceuserDao.findById(id).get();
        this.basdeviceuserDao.save(entity);
    }

    public PageObject PageAll(String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        return this.bSqlHelper.serachPage("base.BasDeviceUser.select", params, PageRequest.of((int)page, (int)rows));
    }

    public List<String> getAllDeviceIds() {
        return this.bSqlHelper.getList("base.BasDeviceUser.getAllDeviceIds", null, String.class);
    }

    public void delUserClient(Long accountId, String clientId) {
        if (accountId == null || StringUtils.isBlank((String)clientId)) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accountId", accountId);
        params.put("clientId", clientId);
        String sql = "update bas_device_user t \nset t.ACCOUNT_ID=-t.ACCOUNT_ID ,t.CLIENT_ID=concat('-',t.CLIENT_ID)\nwhere t.CLIENT_ID=#clientId# and t.ACCOUNT_ID=#accountId#";
        this.bSqlHelper.updateBysql(sql, params);
    }
}

